/*
 * Decompiled with CFR 0.152.
 */
package noppes.mpm;

import java.security.MessageDigest;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;
import noppes.mpm.ModelDataShared;
import noppes.mpm.ModelPartData;
import noppes.mpm.MorePlayerModels;
import noppes.mpm.constants.EnumAnimation;

public class ModelData
extends ModelDataShared
implements IExtendedEntityProperties {
    public String username;
    public boolean loaded = false;
    public ResourceLocation playerResource;
    public int rev = MorePlayerModels.Revision;
    public ItemStack backItem;
    public int inLove = 0;
    public int animationTime = 0;
    public EnumAnimation animation = EnumAnimation.NONE;
    public int animationStart = 0;
    public short soundType = 0;
    public String url = "";

    @Override
    public NBTTagCompound writeToNBT() {
        NBTTagCompound compound = super.writeToNBT();
        compound.func_74768_a("Revision", this.rev);
        compound.func_74768_a("Animation", this.animation.ordinal());
        compound.func_74777_a("SoundType", this.soundType);
        compound.func_74778_a("CustomSkinUrl", this.url);
        return compound;
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        super.readFromNBT(compound);
        this.rev = compound.func_74762_e("Revision");
        this.soundType = compound.func_74765_d("SoundType");
        this.url = compound.func_74779_i("CustomSkinUrl");
        this.setAnimation(compound.func_74762_e("Animation"));
        this.loaded = false;
    }

    public void setAnimation(int i) {
        this.animation = i < EnumAnimation.values().length ? EnumAnimation.values()[i] : EnumAnimation.NONE;
        if (this.animation == EnumAnimation.WAVING) {
            this.animationTime = 80;
        }
    }

    public EntityLivingBase getEntity(World world, EntityPlayer player) {
        if (this.entityClass == null) {
            return null;
        }
        if (this.entity == null) {
            try {
                this.entity = (EntityLivingBase)this.entityClass.getConstructor(World.class).newInstance(world);
                this.entity.func_70037_a(this.extra);
                if (this.entity instanceof EntityLiving) {
                    EntityLiving living = (EntityLiving)this.entity;
                    living.func_70062_b(0, player.func_70694_bm());
                    living.func_70062_b(1, player.field_71071_by.func_70440_f(3));
                    living.func_70062_b(2, player.field_71071_by.func_70440_f(2));
                    living.func_70062_b(3, player.field_71071_by.func_70440_f(1));
                    living.func_70062_b(4, player.field_71071_by.func_70440_f(0));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.entity;
    }

    public String getHash() {
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            String toHash = this.arms.toString() + this.legs.toString() + this.body.toString() + this.head.toString();
            if (this.entityClass != null) {
                toHash = toHash + this.entityClass.getCanonicalName();
            }
            toHash = toHash + this.legParts.toString() + this.headwear + this.breasts + this.soundType + this.url;
            for (String name : this.parts.keySet()) {
                toHash = toHash + name + ":" + ((ModelPartData)this.parts.get(name)).toString();
            }
            byte[] hash = digest.digest(toHash.getBytes("UTF-8"));
            StringBuilder sb = new StringBuilder(2 * hash.length);
            for (byte b : hash) {
                sb.append(String.format("%02x", b & 0xFF));
            }
            return sb.toString();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public ModelData copy() {
        ModelData data = new ModelData();
        data.readFromNBT(this.writeToNBT());
        return data;
    }

    public boolean isSleeping() {
        return this.isSleeping(this.animation);
    }

    private boolean isSleeping(EnumAnimation animation) {
        return animation == EnumAnimation.SLEEPING_EAST || animation == EnumAnimation.SLEEPING_NORTH || animation == EnumAnimation.SLEEPING_SOUTH || animation == EnumAnimation.SLEEPING_WEST;
    }

    public boolean animationEquals(EnumAnimation animation2) {
        return animation2 == this.animation || this.isSleeping() && this.isSleeping(animation2);
    }

    public void saveNBTData(NBTTagCompound compound) {
    }

    public void loadNBTData(NBTTagCompound compound) {
    }

    public void init(Entity entity, World world) {
    }
}

