/*
 * Decompiled with CFR 0.152.
 */
package io.endertech.util;

import io.endertech.item.ItemExchanger;
import io.endertech.util.BlockCoord;
import io.endertech.util.helper.BlockHelper;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.BlockTorch;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class Exchange {
    public static final int radiusTicksDefault = 10;
    public static final Set<Block> specialBlocks = new HashSet<Block>();
    public BlockCoord origin = null;
    public int radius;
    public int currentRadius = 1;
    public int currentRadiusTicks = 0;
    public Block source;
    public int sourceMeta;
    public ItemStack target;
    public int hotbar_id = 0;
    public EntityPlayer player = null;
    public ForgeDirection orientation = null;

    public Exchange(BlockCoord origin, int radius, Block source, int sourceMeta, ItemStack target, EntityPlayer p, int hotbar_id, ForgeDirection orientation) {
        this.origin = origin;
        this.radius = radius;
        this.source = source;
        this.sourceMeta = sourceMeta;
        this.target = target;
        this.player = p;
        this.hotbar_id = hotbar_id;
        this.orientation = orientation;
    }

    public static void initSpecialBlocks() {
        for (Object o : Block.field_149771_c) {
            Block block = (Block)o;
            if (!(block instanceof BlockFence) && !(block instanceof BlockFenceGate) && !(block instanceof BlockTorch)) continue;
            specialBlocks.add(block);
        }
    }

    public static boolean blockSuitableForSelection(BlockCoord blockCoord, World world, Block block, int blockMeta, ItemStack itemStack) {
        if (world.func_147438_o(blockCoord.x, blockCoord.y, blockCoord.z) != null) {
            return false;
        }
        if (world.func_147437_c(blockCoord.x, blockCoord.y, blockCoord.z)) {
            return false;
        }
        if (block.func_149712_f(world, blockCoord.x, blockCoord.y, blockCoord.z) < 0.0f) {
            return false;
        }
        if (BlockHelper.softBlocks.contains(block)) {
            return false;
        }
        return ItemExchanger.isCreative(itemStack) || !ItemExchanger.creativeOverrideBlocks.contains(block);
    }

    public static boolean blockSuitableForExchange(BlockCoord blockCoord, World world, Block source, int sourceMeta, ItemStack target, ItemStack itemStack, int radius) {
        int worldMeta;
        Block worldBlock = world.func_147439_a(blockCoord.x, blockCoord.y, blockCoord.z);
        if (!Exchange.blockSuitableForSelection(blockCoord, world, worldBlock, worldMeta = world.func_72805_g(blockCoord.x, blockCoord.y, blockCoord.z), itemStack)) {
            return false;
        }
        if (!Exchange.isBlockExposedWithExchangerExceptions(world, blockCoord.x, blockCoord.y, blockCoord.z) && radius > 0) {
            return false;
        }
        if (source != worldBlock || sourceMeta != worldMeta) {
            return false;
        }
        return !target.func_77969_a(new ItemStack(source, 1, sourceMeta));
    }

    public static boolean isBlockExposedWithExchangerExceptions(World world, int x, int y, int z) {
        return BlockHelper.isBlockExposed(world, x, y, z) || Exchange.isBlockNextToException(world, x, y, z);
    }

    public static boolean isBlockNextToException(World world, int x, int y, int z) {
        return Exchange.isBlockException(world, x + 1, y, z) || Exchange.isBlockException(world, x - 1, y, z) || Exchange.isBlockException(world, x, y + 1, z) || Exchange.isBlockException(world, x, y - 1, z) || Exchange.isBlockException(world, x, y, z + 1) || Exchange.isBlockException(world, x, y, z - 1);
    }

    public static boolean isBlockException(World world, int x, int y, int z) {
        if (world.func_147437_c(x, y, z)) {
            return false;
        }
        Block block = world.func_147439_a(x, y, z);
        return Exchange.isBlockException(block);
    }

    public static boolean isBlockException(Block block) {
        return block != null && specialBlocks.contains(block);
    }
}

