/*
 * Decompiled with CFR 0.152.
 */
package io.endertech.block;

import cofh.lib.util.helpers.ServerHelper;
import io.endertech.EnderTech;
import io.endertech.tile.TileET;
import io.endertech.tile.TileInventory;
import io.endertech.util.helper.WorldHelper;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockET
extends Block {
    public BlockET() {
        this(Material.field_151573_f);
    }

    public BlockET(Material material) {
        super(material);
        this.func_149647_a(EnderTech.tabET);
    }

    public static ArrayList<ItemStack> dismantleBlockInWorld(EntityPlayer player, World world, int x, int y, int z, boolean returnDrops) {
        TileET tileET;
        Block block = world.func_147439_a(x, y, z);
        int meta = world.func_72805_g(x, y, z);
        ItemStack drop = new ItemStack(block, 1, block.func_149692_a(meta));
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        drops.add(drop);
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileInventory) {
            TileInventory tileInventory = (TileInventory)tile;
            for (ItemStack itemStack : tileInventory.inventory) {
                if (itemStack == null) continue;
                drops.add(itemStack);
            }
            tileInventory.inventory = new ItemStack[tileInventory.inventory.length];
        }
        if (tile instanceof TileET && (tileET = (TileET)tile).hasItemState()) {
            drop.func_77982_d(new NBTTagCompound());
            tileET.writeStateToNBT(drop.field_77990_d);
        }
        world.func_147468_f(x, y, z);
        if (!returnDrops) {
            for (ItemStack itemStack : drops) {
                WorldHelper.spawnItemInWorldWithRandomness(itemStack, world, 0.3f, x, y, z, 2);
            }
        }
        return drops;
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entityLiving, ItemStack itemStack) {
        if (world.func_147438_o(x, y, z) instanceof TileET) {
            int direction = 0;
            int facing = MathHelper.func_76128_c((double)((double)(entityLiving.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
            if (facing == 0) {
                direction = ForgeDirection.NORTH.ordinal();
            } else if (facing == 1) {
                direction = ForgeDirection.EAST.ordinal();
            } else if (facing == 2) {
                direction = ForgeDirection.SOUTH.ordinal();
            } else if (facing == 3) {
                direction = ForgeDirection.WEST.ordinal();
            }
            ((TileET)world.func_147438_o(x, y, z)).setOrientation(direction);
        }
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float fx, float fy, float fz) {
        TileET tileET = (TileET)world.func_147438_o(x, y, z);
        if (tileET == null) {
            return false;
        }
        if (tileET.hasGui()) {
            if (ServerHelper.isServerWorld(world)) {
                tileET.openGui(player);
            }
            return true;
        }
        return false;
    }
}

