/*
 * Decompiled with CFR 0.152.
 */
package io.endertech;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLFingerprintViolationEvent;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import io.endertech.block.BlockChargePad;
import io.endertech.block.BlockHealthPad;
import io.endertech.block.ETBlocks;
import io.endertech.client.handler.GUIEventHandler;
import io.endertech.client.handler.KeyBindingHandler;
import io.endertech.config.ConfigHandler;
import io.endertech.config.GeneralConfig;
import io.endertech.creativetab.CreativeTabET;
import io.endertech.gui.GuiHandler;
import io.endertech.item.ETItems;
import io.endertech.multiblock.block.BlockMultiblockGlass;
import io.endertech.multiblock.block.BlockTankController;
import io.endertech.multiblock.block.BlockTankPart;
import io.endertech.network.PacketHandler;
import io.endertech.network.PacketKeyPressed;
import io.endertech.network.PacketTile;
import io.endertech.proxy.CommonProxy;
import io.endertech.util.Exchange;
import io.endertech.util.fluid.BucketHandler;
import io.endertech.util.helper.BlockHelper;
import io.endertech.util.helper.LocalisationHelper;
import io.endertech.util.helper.LogHelper;
import io.endertech.util.helper.ModuleHelper;
import java.io.File;
import net.minecraft.client.Minecraft;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.launchwrapper.Launch;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.oredict.ShapedOreRecipe;

@Mod(modid="EnderTech", name="EnderTech", version="1.7.10-0.3.0.358", certificateFingerprint="60da3693ba702836f120dba30a9a79e6130d70a6", dependencies="after:ThermalExpansion@[1.7.10R4.0.0B1,)")
public class EnderTech {
    public static final CreativeTabs tabET = new CreativeTabET();
    public static final GuiHandler guiHandler = new GuiHandler();
    @Mod.Instance(value="EnderTech")
    public static EnderTech instance;
    @SidedProxy(clientSide="io.endertech.proxy.ClientProxy", serverSide="io.endertech.proxy.CommonProxy")
    public static CommonProxy proxy;
    public static boolean loadDevModeContent;
    public static Item capacitor;

    @Mod.EventHandler
    public void invalidFingerprint(FMLFingerprintViolationEvent event) {
        if ("60da3693ba702836f120dba30a9a79e6130d70a6".equals("@FINGERPRINT@")) {
            LogHelper.warn(LocalisationHelper.localiseString("warning.fingerprint.missing", new Object[0]), new Object[0]);
        } else {
            LogHelper.fatal(LocalisationHelper.localiseString("error.fingerprint.tampered", new Object[0]), new Object[0]);
        }
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        ConfigHandler.init(event.getModConfigurationDirectory().getAbsolutePath() + File.separator + "EnderTech".toLowerCase() + File.separator);
        LogHelper.debug("Loaded config", new Object[0]);
        if (((Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment")).booleanValue() || GeneralConfig.forceLoadDevContent) {
            loadDevModeContent = true;
        }
        ModuleHelper.setupModules();
        ModuleHelper.pulsar.preInit(event);
        PacketHandler.instance.init();
        proxy.registerTickerHandlers();
        if (FMLCommonHandler.instance().getSide().isClient()) {
            KeyBindingHandler.init();
        }
        ETBlocks.init();
        ETItems.init();
        BucketHandler.initialize();
        LogHelper.debug("preInit complete", new Object[0]);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)guiHandler);
        PacketTile.init();
        PacketKeyPressed.init();
        ModuleHelper.pulsar.init(event);
        proxy.registerTESRs();
        proxy.registerRenderers();
        proxy.registerItemRenderers();
        FMLInterModComms.sendMessage((String)"Waila", (String)"register", (String)"io.endertech.integration.waila.MultiblockWailaProvider.callbackRegister");
        FMLInterModComms.sendMessage((String)"Waila", (String)"register", (String)"io.endertech.integration.waila.GenericWailaProvider.callbackRegister");
        LogHelper.debug("init complete", new Object[0]);
        MinecraftForge.EVENT_BUS.register((Object)proxy);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        ModuleHelper.pulsar.postInit(event);
        PacketHandler.instance.postInit();
        if (FMLCommonHandler.instance().getSide().isClient()) {
            MinecraftForge.EVENT_BUS.register((Object)new GUIEventHandler(Minecraft.func_71410_x()));
        }
        BlockHelper.initSoftBlocks();
        Exchange.initSpecialBlocks();
        LogHelper.info(LocalisationHelper.localiseString("info.postinit.recipes", new Object[0]), new Object[0]);
        if (Loader.isModLoaded((String)"ThermalExpansion")) {
            ItemStack capacitorReinforced = GameRegistry.findItemStack((String)"ThermalExpansion", (String)"capacitorReinforced", (int)1);
            ItemStack capacitorResonant = GameRegistry.findItemStack((String)"ThermalExpansion", (String)"capacitorResonant", (int)1);
            capacitor = capacitorResonant.func_77973_b();
            ItemStack powerCoilElectrumStack = GameRegistry.findItemStack((String)"ThermalExpansion", (String)"powerCoilElectrum", (int)1);
            ItemStack tesseract = new ItemStack(GameRegistry.findBlock((String)"ThermalExpansion", (String)"Tesseract"));
            ItemStack enderiumIngot = GameRegistry.findItemStack((String)"ThermalFoundation", (String)"ingotEnderium", (int)1);
            ItemStack electrumIngot = GameRegistry.findItemStack((String)"ThermalFoundation", (String)"ingotElectrum", (int)1);
            ItemStack machineResonant = new ItemStack(GameRegistry.findBlock((String)"ThermalExpansion", (String)"Frame"), 1, 3);
            ItemStack machineRedstone = new ItemStack(GameRegistry.findBlock((String)"ThermalExpansion", (String)"Frame"), 1, 2);
            ItemStack hardenedGlass = new ItemStack(GameRegistry.findBlock((String)"ThermalExpansion", (String)"Glass"));
            ItemStack tankResonant = new ItemStack(GameRegistry.findBlock((String)"ThermalExpansion", (String)"Tank"), 1, 4);
            ItemStack enderEyeStack = new ItemStack(Items.field_151061_bv);
            ItemStack goldenApple = new ItemStack(Items.field_151153_ao);
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(ETItems.toolExchangerRedstone, new Object[]{"XEX", "ITI", "XCX", Character.valueOf('E'), enderEyeStack, Character.valueOf('I'), electrumIngot, Character.valueOf('C'), capacitorReinforced, Character.valueOf('T'), tesseract}));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(ETItems.toolExchangerResonant, new Object[]{"XEX", "ITI", "XCX", Character.valueOf('E'), enderEyeStack, Character.valueOf('I'), enderiumIngot, Character.valueOf('C'), capacitorResonant, Character.valueOf('T'), tesseract}));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(ETItems.toolExchangerResonant, new Object[]{"XSX", "IEI", "XCX", Character.valueOf('S'), enderEyeStack, Character.valueOf('E'), ETItems.toolExchangerRedstone, Character.valueOf('I'), enderiumIngot, Character.valueOf('C'), capacitorResonant, Character.valueOf('T'), tesseract}));
            ItemStack enderTankFrame = new ItemStack(BlockTankPart.itemBlockTankFrame.func_77973_b(), 8, BlockTankPart.itemBlockTankFrame.func_77960_j());
            ItemStack enderTankEnergyInput = new ItemStack(BlockTankPart.itemBlockTankEnergyInput.func_77973_b(), 8, BlockTankPart.itemBlockTankEnergyInput.func_77960_j());
            ItemStack enderTankValve = new ItemStack(BlockTankPart.itemBlockTankValve.func_77973_b(), 8, BlockTankPart.itemBlockTankValve.func_77960_j());
            ItemStack enderTankGlass = new ItemStack(BlockMultiblockGlass.itemBlockMultiblockGlass.func_77973_b(), 16, BlockMultiblockGlass.itemBlockMultiblockGlass.func_77960_j());
            ItemStack enderTankController = BlockTankController.itemBlockTankController;
            GameRegistry.addRecipe((ItemStack)enderTankFrame, (Object[])new Object[]{"IEI", "EFE", "IEI", Character.valueOf('I'), enderiumIngot, Character.valueOf('F'), machineResonant, Character.valueOf('E'), enderEyeStack});
            GameRegistry.addRecipe((ItemStack)enderTankEnergyInput, (Object[])new Object[]{"ICI", "EFE", "ITI", Character.valueOf('I'), enderiumIngot, Character.valueOf('F'), machineResonant, Character.valueOf('C'), capacitorResonant, Character.valueOf('T'), tesseract, Character.valueOf('E'), enderEyeStack});
            GameRegistry.addRecipe((ItemStack)enderTankValve, (Object[])new Object[]{"IAI", "EFE", "ITI", Character.valueOf('I'), enderiumIngot, Character.valueOf('A'), tankResonant, Character.valueOf('F'), machineResonant, Character.valueOf('T'), tesseract, Character.valueOf('E'), enderEyeStack});
            GameRegistry.addRecipe((ItemStack)enderTankController, (Object[])new Object[]{"IEI", "EFE", "ITI", Character.valueOf('I'), enderiumIngot, Character.valueOf('F'), machineResonant, Character.valueOf('T'), tesseract, Character.valueOf('E'), enderEyeStack});
            GameRegistry.addRecipe((ItemStack)enderTankGlass, (Object[])new Object[]{"GIG", "EFE", "GIG", Character.valueOf('I'), enderiumIngot, Character.valueOf('G'), hardenedGlass, Character.valueOf('F'), machineResonant, Character.valueOf('E'), enderEyeStack});
            GameRegistry.addRecipe((ItemStack)BlockChargePad.itemChargePadResonant, (Object[])new Object[]{"IEI", "CFC", "IAI", Character.valueOf('I'), enderiumIngot, Character.valueOf('F'), machineResonant, Character.valueOf('E'), enderEyeStack, Character.valueOf('C'), powerCoilElectrumStack, Character.valueOf('T'), tesseract, Character.valueOf('A'), capacitorResonant});
            GameRegistry.addRecipe((ItemStack)BlockChargePad.itemChargePadRedstone, (Object[])new Object[]{"IEI", "CFC", "IAI", Character.valueOf('I'), electrumIngot, Character.valueOf('F'), machineRedstone, Character.valueOf('E'), enderEyeStack, Character.valueOf('C'), powerCoilElectrumStack, Character.valueOf('T'), tesseract, Character.valueOf('A'), capacitorReinforced});
            GameRegistry.addRecipe((ItemStack)BlockHealthPad.itemHealthPadResonant, (Object[])new Object[]{"IEI", "CFC", "IAI", Character.valueOf('I'), enderiumIngot, Character.valueOf('F'), machineResonant, Character.valueOf('E'), enderEyeStack, Character.valueOf('C'), goldenApple, Character.valueOf('T'), tesseract, Character.valueOf('A'), capacitorResonant});
            GameRegistry.addRecipe((ItemStack)BlockHealthPad.itemHealthPadRedstone, (Object[])new Object[]{"IEI", "CFC", "IAI", Character.valueOf('I'), electrumIngot, Character.valueOf('F'), machineRedstone, Character.valueOf('E'), enderEyeStack, Character.valueOf('C'), goldenApple, Character.valueOf('T'), tesseract, Character.valueOf('A'), capacitorReinforced});
        } else {
            LogHelper.warn(LocalisationHelper.localiseString("warning.thermalexpansion.missing", new Object[0]), new Object[0]);
        }
    }

    static {
        loadDevModeContent = false;
    }
}

