/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.world.feature;

import cofh.lib.world.feature.FeatureBase;
import java.util.Random;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.feature.WorldGenerator;

public class FeatureOreGenUniform
extends FeatureBase {
    final WorldGenerator worldGen;
    final int count;
    final int minY;
    final int maxY;

    public FeatureOreGenUniform(String name, WorldGenerator worldGen, int count, int minY, int maxY, FeatureBase.GenRestriction biomeRes, boolean regen, FeatureBase.GenRestriction dimRes) {
        super(name, biomeRes, regen, dimRes);
        this.worldGen = worldGen;
        this.count = count;
        this.minY = minY;
        this.maxY = maxY;
    }

    @Override
    public boolean generateFeature(Random random, int chunkX, int chunkZ, World world, boolean newGen) {
        if (!newGen && !this.regen) {
            return false;
        }
        if (this.dimensionRestriction != FeatureBase.GenRestriction.NONE && this.dimensionRestriction == FeatureBase.GenRestriction.BLACKLIST == this.dimensions.contains(world.field_73011_w.field_76574_g)) {
            return false;
        }
        int blockX = chunkX * 16;
        int blockZ = chunkZ * 16;
        boolean generated = false;
        for (int i = 0; i < this.count; ++i) {
            BiomeGenBase biome;
            int x = blockX + random.nextInt(16);
            int y = this.minY + random.nextInt(this.maxY - this.minY);
            int z = blockZ + random.nextInt(16);
            if (this.biomeRestriction != FeatureBase.GenRestriction.NONE && this.biomeRestriction == FeatureBase.GenRestriction.BLACKLIST == ((biome = world.func_72807_a(x, z)) != null && this.biomes.contains(biome.field_76791_y))) continue;
            generated |= this.worldGen.func_76484_a(world, random, x, y, z);
        }
        return generated;
    }
}

