/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.world.feature;

import cofh.lib.util.helpers.BlockHelper;
import cofh.lib.world.feature.FeatureBase;
import java.util.Random;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.feature.WorldGenerator;

public class FeatureOreGenSurface
extends FeatureBase {
    final WorldGenerator worldGen;
    final int count;
    final int chance;

    public FeatureOreGenSurface(String name, WorldGenerator worldGen, int count, int chance, FeatureBase.GenRestriction biomeRes, boolean regen, FeatureBase.GenRestriction dimRes) {
        super(name, biomeRes, regen, dimRes);
        this.worldGen = worldGen;
        this.count = count;
        this.chance = chance;
    }

    @Override
    public boolean generateFeature(Random random, int chunkX, int chunkZ, World world, boolean newGen) {
        if (!newGen && !this.regen) {
            return false;
        }
        if (this.dimensionRestriction != FeatureBase.GenRestriction.NONE && this.dimensionRestriction == FeatureBase.GenRestriction.BLACKLIST == this.dimensions.contains(world.field_73011_w.field_76574_g)) {
            return false;
        }
        if (this.chance > 1 && random.nextInt(this.chance) != 0) {
            return false;
        }
        int blockX = chunkX * 16;
        int blockZ = chunkZ * 16;
        boolean generated = false;
        for (int i = 0; i < this.count; ++i) {
            int y;
            BiomeGenBase biome;
            int x = blockX + random.nextInt(16);
            int z = blockZ + random.nextInt(16);
            if (this.biomeRestriction != FeatureBase.GenRestriction.NONE && this.biomeRestriction == FeatureBase.GenRestriction.BLACKLIST == ((biome = world.func_72807_a(x, z)) != null && this.biomes.contains(biome.field_76791_y)) || world.func_147439_a(x, y = BlockHelper.getSurfaceBlockY(world, x, z), z).isAir((IBlockAccess)world, x, y, z)) continue;
            generated |= this.worldGen.func_76484_a(world, random, x, y, z);
        }
        return generated;
    }
}

