/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.world;

import cofh.lib.util.WeightedRandomBlock;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.util.WeightedRandom;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class WorldGenMinableCluster
extends WorldGenerator {
    private final List<WeightedRandomBlock> cluster;
    private final int genClusterSize;
    private final WeightedRandomBlock[] genBlock;

    public static final List<WeightedRandomBlock> fabricateList(WeightedRandomBlock resource) {
        ArrayList<WeightedRandomBlock> list = new ArrayList<WeightedRandomBlock>();
        list.add(resource);
        return list;
    }

    public static final List<WeightedRandomBlock> fabricateList(Block resource) {
        ArrayList<WeightedRandomBlock> list = new ArrayList<WeightedRandomBlock>();
        list.add(new WeightedRandomBlock(new ItemStack(resource, 1, 0)));
        return list;
    }

    public WorldGenMinableCluster(ItemStack ore, int clusterSize) {
        this(new WeightedRandomBlock(ore), clusterSize);
    }

    public WorldGenMinableCluster(WeightedRandomBlock resource, int clusterSize) {
        this(WorldGenMinableCluster.fabricateList(resource), clusterSize);
    }

    public WorldGenMinableCluster(List<WeightedRandomBlock> resource, int clusterSize) {
        this(resource, clusterSize, Blocks.field_150348_b);
    }

    public WorldGenMinableCluster(ItemStack ore, int clusterSize, Block block) {
        this(new WeightedRandomBlock(ore, 1), clusterSize, block);
    }

    public WorldGenMinableCluster(WeightedRandomBlock resource, int clusterSize, Block block) {
        this(WorldGenMinableCluster.fabricateList(resource), clusterSize, block);
    }

    public WorldGenMinableCluster(List<WeightedRandomBlock> resource, int clusterSize, Block block) {
        this(resource, clusterSize, WorldGenMinableCluster.fabricateList(block));
    }

    public WorldGenMinableCluster(List<WeightedRandomBlock> resource, int clusterSize, List<WeightedRandomBlock> block) {
        this.cluster = resource;
        this.genClusterSize = clusterSize > 32 ? 32 : clusterSize;
        this.genBlock = block.toArray(new WeightedRandomBlock[block.size()]);
    }

    public boolean func_76484_a(World world, Random random, int x, int y, int z) {
        if (this.genClusterSize < 4) {
            return this.generateTiny(world, random, x, y, z);
        }
        float f = random.nextFloat() * (float)Math.PI;
        double d0 = (float)(x + 8) + MathHelper.func_76126_a((float)f) * (float)this.genClusterSize / 8.0f;
        double d1 = (float)(x + 8) - MathHelper.func_76126_a((float)f) * (float)this.genClusterSize / 8.0f;
        double d2 = (float)(z + 8) + MathHelper.func_76134_b((float)f) * (float)this.genClusterSize / 8.0f;
        double d3 = (float)(z + 8) - MathHelper.func_76134_b((float)f) * (float)this.genClusterSize / 8.0f;
        double d4 = y + random.nextInt(3) - 2;
        double d5 = y + random.nextInt(3) - 2;
        boolean r = false;
        for (int l = 0; l <= this.genClusterSize; ++l) {
            double d6 = d0 + (d1 - d0) * (double)l / (double)this.genClusterSize;
            double d7 = d4 + (d5 - d4) * (double)l / (double)this.genClusterSize;
            double d8 = d2 + (d3 - d2) * (double)l / (double)this.genClusterSize;
            double d9 = random.nextDouble() * (double)this.genClusterSize / 16.0;
            double d10 = (double)(MathHelper.func_76126_a((float)((float)l * (float)Math.PI / (float)this.genClusterSize)) + 1.0f) * d9 + 1.0;
            double d11 = (double)(MathHelper.func_76126_a((float)((float)l * (float)Math.PI / (float)this.genClusterSize)) + 1.0f) * d9 + 1.0;
            int i1 = MathHelper.func_76128_c((double)(d6 - d10 / 2.0));
            int j1 = MathHelper.func_76128_c((double)(d7 - d11 / 2.0));
            int k1 = MathHelper.func_76128_c((double)(d8 - d10 / 2.0));
            int l1 = MathHelper.func_76128_c((double)(d6 + d10 / 2.0));
            int i2 = MathHelper.func_76128_c((double)(d7 + d11 / 2.0));
            int j2 = MathHelper.func_76128_c((double)(d8 + d10 / 2.0));
            for (int k2 = i1; k2 <= l1; ++k2) {
                double d12 = ((double)k2 + 0.5 - d6) / (d10 / 2.0);
                if (!(d12 * d12 < 1.0)) continue;
                for (int l2 = j1; l2 <= i2; ++l2) {
                    double d13 = ((double)l2 + 0.5 - d7) / (d11 / 2.0);
                    if (!(d12 * d12 + d13 * d13 < 1.0)) continue;
                    for (int i3 = k1; i3 <= j2; ++i3) {
                        double d14 = ((double)i3 + 0.5 - d8) / (d10 / 2.0);
                        if (!(d12 * d12 + d13 * d13 + d14 * d14 < 1.0)) continue;
                        r |= WorldGenMinableCluster.generateBlock(world, k2, l2, i3, this.genBlock, this.cluster);
                    }
                }
            }
        }
        return r;
    }

    public boolean generateTiny(World world, Random random, int x, int y, int z) {
        boolean r = false;
        for (int i = 0; i < this.genClusterSize; ++i) {
            int d0 = x + random.nextInt(2);
            int d1 = y + random.nextInt(2);
            int d2 = z + random.nextInt(2);
            r |= WorldGenMinableCluster.generateBlock(world, d0, d1, d2, this.genBlock, this.cluster);
        }
        return r;
    }

    public static boolean generateBlock(World world, int x, int y, int z, WeightedRandomBlock[] mat, List<WeightedRandomBlock> o) {
        boolean r = false;
        Block block = world.func_147439_a(x, y, z);
        for (WeightedRandomBlock genBlock : mat) {
            if (-1 != genBlock.metadata && genBlock.metadata != world.func_72805_g(x, y, z) || !block.isReplaceableOreGen(world, x, y, z, genBlock.block)) continue;
            WeightedRandomBlock ore = (WeightedRandomBlock)WeightedRandom.func_76271_a((Random)world.field_73012_v, o);
            r |= world.func_147465_d(x, y, z, ore.block, ore.metadata, 2);
            break;
        }
        return r;
    }
}

