/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.inventory;

import cofh.lib.util.helpers.ItemHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class ComparableItemStack {
    public Item item = null;
    public int metadata = -1;
    public int stackSize = -1;
    public int oreID = -1;

    public ComparableItemStack(ItemStack stack) {
        if (stack != null) {
            this.item = stack.func_77973_b();
            this.metadata = ItemHelper.getItemDamage(stack);
            this.stackSize = stack.field_77994_a;
            this.oreID = ItemHelper.oreProxy.getOreID(stack);
        }
    }

    public ComparableItemStack(Item item, int damage, int stackSize) {
        this.item = item;
        this.metadata = damage;
        this.stackSize = stackSize;
        this.oreID = ItemHelper.oreProxy.getOreID(this.toItemStack());
    }

    public ComparableItemStack(ComparableItemStack stack) {
        this.item = stack.item;
        this.metadata = stack.metadata;
        this.stackSize = stack.stackSize;
        this.oreID = stack.oreID;
    }

    public ComparableItemStack(String oreName) {
        if (ItemHelper.oreNameExists(oreName)) {
            ItemStack stack = ItemHelper.oreProxy.getOre(oreName);
            this.item = stack.func_77973_b();
            this.metadata = ItemHelper.getItemDamage(stack);
            this.stackSize = 1;
            this.oreID = ItemHelper.oreProxy.getOreID(stack);
        }
    }

    public ComparableItemStack set(ItemStack stack) {
        if (stack != null) {
            this.item = stack.func_77973_b();
            this.metadata = ItemHelper.getItemDamage(stack);
            this.stackSize = stack.field_77994_a;
            this.oreID = ItemHelper.oreProxy.getOreID(stack);
        } else {
            this.item = null;
            this.metadata = -1;
            this.stackSize = -1;
            this.oreID = -1;
        }
        return this;
    }

    public ComparableItemStack set(ComparableItemStack stack) {
        if (stack != null) {
            this.item = stack.item;
            this.metadata = stack.metadata;
            this.stackSize = stack.stackSize;
            this.oreID = stack.oreID;
        } else {
            this.item = null;
            this.metadata = -1;
            this.stackSize = -1;
            this.oreID = -1;
        }
        return this;
    }

    public boolean isItemEqual(ComparableItemStack other) {
        return other != null && (this.oreID != -1 && this.oreID == other.oreID || this.item == other.item && this.metadata == other.metadata);
    }

    public boolean isStackEqual(ComparableItemStack other) {
        return this.isItemEqual(other) && this.stackSize == other.stackSize;
    }

    public boolean isStackValid() {
        return this.item != null;
    }

    public ItemStack toItemStack() {
        return this.item != null ? new ItemStack(this.item, this.stackSize, this.metadata) : null;
    }

    public ComparableItemStack clone() {
        return new ComparableItemStack(this);
    }

    public int hashCode() {
        return this.oreID != -1 ? this.oreID : this.metadata | Item.func_150891_b((Item)this.item) << 16;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ComparableItemStack)) {
            return false;
        }
        return this.isItemEqual((ComparableItemStack)o);
    }
}

