/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.gui;

public class GuiColor {
    private final int _color;

    public GuiColor(int color) {
        this._color = color;
    }

    public GuiColor(int r, int g, int b) {
        this(r, g, b, 255);
    }

    public GuiColor(int r, int g, int b, int a) {
        this._color = b & 0xFF | (g & 0xFF) << 8 | (r & 0xFF) << 16 | (a & 0xFF) << 24;
    }

    public int getColor() {
        return this._color;
    }

    public int getIntR() {
        return this._color >> 16 & 0xFF;
    }

    public int getIntG() {
        return this._color >> 8 & 0xFF;
    }

    public int getIntB() {
        return this._color >> 0 & 0xFF;
    }

    public int getIntA() {
        return this._color >> 24 & 0xFF;
    }

    public float getFloatR() {
        return (this._color >> 16 & 0xFF) / 255;
    }

    public float getFloatG() {
        return (this._color >> 8 & 0xFF) / 255;
    }

    public float getFloatB() {
        return (this._color >> 0 & 0xFF) / 255;
    }

    public float getFloatA() {
        return (this._color >> 24 & 0xFF) / 255;
    }
}

