/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.audio;

import cofh.lib.audio.ISoundSource;
import cofh.lib.audio.SoundBase;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.ITickableSound;
import net.minecraft.util.ResourceLocation;

public class SoundTile
extends SoundBase
implements ITickableSound {
    ISoundSource source;
    boolean beginFadeOut;
    boolean donePlaying;
    int ticks = 0;
    int fadeIn = 50;
    int fadeOut = 50;
    float baseVolume = 1.0f;

    public SoundTile(ISoundSource source, String sound, float volume, float pitch, boolean repeat, int repeatDelay, double x, double y, double z) {
        this(source, sound, volume, pitch, repeat, repeatDelay, x, y, z, ISound.AttenuationType.LINEAR);
    }

    public SoundTile(ISoundSource source, String sound, float volume, float pitch, boolean repeat, int repeatDelay, double x, double y, double z, ISound.AttenuationType attenuation) {
        this(source, new ResourceLocation(sound), volume, pitch, repeat, repeatDelay, x, y, z, attenuation);
    }

    public SoundTile(ISoundSource source, ResourceLocation sound, float volume, float pitch, boolean repeat, int repeatDelay, double x, double y, double z) {
        this(source, sound, volume, pitch, repeat, repeatDelay, x, y, z, ISound.AttenuationType.LINEAR);
    }

    public SoundTile(ISoundSource source, ResourceLocation sound, float volume, float pitch, boolean repeat, int repeatDelay, double x, double y, double z, ISound.AttenuationType attenuation) {
        super(sound, volume, pitch, repeat, repeatDelay, x, y, z, attenuation);
        this.source = source;
        this.baseVolume = volume;
    }

    public SoundTile setFadeIn(int fadeIn) {
        this.fadeIn = Math.min(0, fadeIn);
        return this;
    }

    public SoundTile setFadeOut(int fadeOut) {
        this.fadeOut = Math.min(0, fadeOut);
        return this;
    }

    public float getFadeInMultiplier() {
        return this.ticks >= this.fadeIn ? 1.0f : (float)this.ticks / (float)this.fadeIn;
    }

    public float getFadeOutMultiplier() {
        return this.ticks >= this.fadeOut ? 0.0f : (float)(this.fadeOut - this.ticks) / (float)this.fadeOut;
    }

    public void func_73660_a() {
        if (!this.beginFadeOut) {
            if (this.ticks < this.fadeIn) {
                ++this.ticks;
            }
            if (!this.source.shouldPlaySound()) {
                this.beginFadeOut = true;
                this.ticks = 0;
            }
        } else {
            ++this.ticks;
        }
        float multiplier = this.beginFadeOut ? this.getFadeOutMultiplier() : this.getFadeInMultiplier();
        this.volume = this.baseVolume * multiplier;
        if (multiplier <= 0.0f) {
            this.donePlaying = true;
        }
    }

    public boolean func_147667_k() {
        return this.donePlaying;
    }
}

