/*
 * Decompiled with CFR 0.152.
 */
package mal.lootbags.item;

import java.util.List;
import java.util.Random;
import mal.lootbags.LootBags;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.ChestGenHooks;
import org.lwjgl.input.Keyboard;

public class LootbagItem
extends Item {
    private static Random random = new Random();
    private IIcon[] iconlist = new IIcon[7];

    public LootbagItem() {
        this.func_77655_b("lootbag");
        this.field_77777_bU = 1;
        this.func_77656_e(0);
        this.field_77787_bX = true;
        this.func_77637_a(CreativeTabs.field_78026_f);
    }

    public void func_77624_a(ItemStack is, EntityPlayer ep, List list, boolean bool) {
        switch (is.func_77960_j()) {
            case 0: {
                list.add(EnumChatFormatting.WHITE + "Common");
                break;
            }
            case 1: {
                list.add(EnumChatFormatting.GREEN + "Uncommon");
                break;
            }
            case 2: {
                list.add(EnumChatFormatting.BLUE + "Rare");
                break;
            }
            case 3: {
                list.add(EnumChatFormatting.DARK_PURPLE + "Epic");
                break;
            }
            case 4: {
                list.add(EnumChatFormatting.GOLD + "Legendary");
                break;
            }
            case 5: {
                list.add("\u00a7dBacon");
                break;
            }
            case 6: {
                list.add(EnumChatFormatting.GRAY + "Worn Out");
            }
        }
        if (is.func_77978_p() != null && is.func_77978_p().func_74767_n("generated")) {
            if (is.func_77960_j() == 5) {
                list.add("\u00a7dTurns out there is bacon inside...");
            } else if (is.func_77960_j() == 6) {
                list.add("\u00a7bI told you my bags don't");
                list.add("\u00a7bdrop beds! baconNub");
            } else {
                list.add("\u00a7bWhat's inside is not as");
                list.add("\u00a7binteresting as not knowing.");
            }
        } else {
            list.add("\u00a7bOoh, what could be inside?");
        }
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            if (is.func_77960_j() < 5) {
                int lchance;
                int pchance;
                int mchance;
                switch (is.func_77960_j()) {
                    case 0: {
                        mchance = LootBags.CMONSTERDROPCHANCE;
                        pchance = LootBags.CPASSIVEDROPCHANCE;
                        lchance = LootBags.CPLAYERDROPCHANCE;
                        break;
                    }
                    case 1: {
                        mchance = LootBags.UMONSTERDROPCHANCE;
                        pchance = LootBags.UPASSIVEDROPCHANCE;
                        lchance = LootBags.UPLAYERDROPCHANCE;
                        break;
                    }
                    case 2: {
                        mchance = LootBags.RMONSTERDROPCHANCE;
                        pchance = LootBags.RPASSIVEDROPCHANCE;
                        lchance = LootBags.RPLAYERDROPCHANCE;
                        break;
                    }
                    case 3: {
                        mchance = LootBags.EMONSTERDROPCHANCE;
                        pchance = LootBags.EPASSIVEDROPCHANCE;
                        lchance = LootBags.EPLAYERDROPCHANCE;
                        break;
                    }
                    case 4: {
                        mchance = LootBags.LMONSTERDROPCHANCE;
                        pchance = LootBags.LPASSIVEDROPCHANCE;
                        lchance = LootBags.LPLAYERDROPCHANCE;
                        break;
                    }
                    default: {
                        mchance = LootBags.CMONSTERDROPCHANCE;
                        pchance = LootBags.CPASSIVEDROPCHANCE;
                        lchance = LootBags.CPLAYERDROPCHANCE;
                    }
                }
                list.add("\u00a77Current Drop Rates: Monster: " + String.format("%.2f", Float.valueOf((float)mchance / 10.0f)) + "%");
                list.add("\u00a77Passive: " + String.format("%.2f", Float.valueOf((float)pchance / 10.0f)) + "% Player: " + String.format("%.2f", Float.valueOf((float)lchance / 10.0f)) + "%");
            } else if (is.func_77960_j() == 5) {
                list.add("\u00a77Three out of every four bacons agree");
                list.add("\u00a77that they don't have enough bacon.");
                list.add("\u00a77The fourth has a bag full of bacon.");
                list.add("\u00a7b(It still isn't enough bacon.)");
            } else if (is.func_77960_j() == 6) {
                list.add("\u00a77My bags are not configured");
                list.add("\u00a77to drop beds in this pack.");
                list.add("\u00a77I am 100% certain about this.");
                list.add(EnumChatFormatting.DARK_PURPLE + "~Malorolam");
            }
        }
    }

    public static void setTagCompound(ItemStack is, ItemStack[] inventory) {
        NBTTagCompound nbt = new NBTTagCompound();
        NBTTagList nbtinventory = new NBTTagList();
        if (inventory != null) {
            for (int i = 0; i < 5; ++i) {
                NBTTagCompound var4 = new NBTTagCompound();
                var4.func_74768_a("Slot", i);
                if (inventory[i] != null) {
                    inventory[i].func_77955_b(var4);
                }
                nbtinventory.func_74742_a((NBTBase)var4);
            }
        }
        nbt.func_74782_a("inventory", (NBTBase)nbtinventory);
        nbt.func_74757_a("generated", true);
        is.func_77982_d(nbt);
    }

    public static ItemStack[] getInventory(ItemStack is) {
        ItemStack[] inventory = new ItemStack[5];
        NBTTagList items = is.field_77990_d.func_150295_c("inventory", 10);
        for (int i = 0; i < items.func_74745_c(); ++i) {
            ItemStack ii;
            NBTTagCompound item = items.func_150305_b(i);
            int slot = item.func_74762_e("Slot");
            if (slot < 0 || slot >= inventory.length) continue;
            inventory[i] = ii = ItemStack.func_77949_a((NBTTagCompound)item);
        }
        return inventory;
    }

    public static void generateInventory(ItemStack is) {
        boolean gen = false;
        if (is.func_77978_p() != null) {
            gen = is.func_77978_p().func_74767_n("generated");
        }
        if (!gen) {
            int numitems = is.func_77960_j() == 6 ? 1 : random.nextInt(5) + 1;
            NBTTagCompound nbt = new NBTTagCompound();
            NBTTagList nbtinventory = new NBTTagList();
            for (int i = 0; i < numitems; ++i) {
                ItemStack inv = LootbagItem.getLootItem(is.func_77960_j());
                NBTTagCompound var4 = new NBTTagCompound();
                var4.func_74768_a("Slot", i);
                if (inv != null && inv.field_77994_a > 0) {
                    inv.func_77955_b(var4);
                } else {
                    --i;
                    --numitems;
                }
                nbtinventory.func_74742_a((NBTBase)var4);
            }
            nbt.func_74782_a("inventory", (NBTBase)nbtinventory);
            nbt.func_74757_a("generated", true);
            is.func_77982_d(nbt);
        }
    }

    private static ItemStack getLootItem(int damage) {
        return LootbagItem.getLootItem(0, damage);
    }

    private static ItemStack getLootItem(int rerollCount, int damage) {
        if (damage == 5) {
            ItemStack[] stacks = random.nextInt(2) == 0 ? ChestGenHooks.generateStacks((Random)random, (ItemStack)new ItemStack(Items.field_151147_al), (int)4, (int)16) : ChestGenHooks.generateStacks((Random)random, (ItemStack)new ItemStack(Items.field_151157_am), (int)4, (int)16);
            return stacks.length > 0 ? stacks[0] : null;
        }
        if (damage == 6) {
            ItemStack[] stacks = ChestGenHooks.generateStacks((Random)random, (ItemStack)new ItemStack(Items.field_151105_aU), (int)1, (int)1);
            return stacks.length > 0 ? stacks[0] : null;
        }
        if (random.nextInt(1000) == 0) {
            ItemStack[] stacks = ChestGenHooks.generateStacks((Random)random, (ItemStack)new ItemStack((Item)LootBags.lootbag, 1, 6), (int)1, (int)1);
            return stacks.length > 0 ? stacks[0] : null;
        }
        boolean reroll = false;
        ItemStack is = LootBags.LOOTMAP.getRandomItem(LootbagItem.getWeightFromDamage(damage));
        if (is == null || is.func_77973_b() == null || is.field_77994_a <= 0) {
            reroll = true;
        }
        if (reroll && rerollCount < LootBags.MAXREROLLCOUNT) {
            return LootbagItem.getLootItem(++rerollCount, damage);
        }
        if (rerollCount >= LootBags.MAXREROLLCOUNT) {
            return null;
        }
        return is;
    }

    private static int getWeightFromDamage(int damage) {
        switch (damage) {
            case 0: {
                return -1;
            }
            case 1: {
                return LootBags.LOOTMAP.generatePercentileWeight(75);
            }
            case 2: {
                return LootBags.LOOTMAP.generatePercentileWeight(50);
            }
            case 3: {
                return LootBags.LOOTMAP.generatePercentileWeight(25);
            }
            case 4: {
                return LootBags.LOOTMAP.generatePercentileWeight(5);
            }
        }
        return -1;
    }

    public static boolean checkInventory(ItemStack is) {
        boolean gen = is.func_77978_p().func_74767_n("generated");
        if (gen) {
            ItemStack[] stack = LootbagItem.getInventory(is);
            if (stack == null) {
                return true;
            }
            boolean b = true;
            for (int i = 0; i < stack.length; ++i) {
                if (stack[i] == null || stack[i].field_77994_a <= 0) continue;
                b = false;
            }
            return b;
        }
        return false;
    }

    public ItemStack func_77659_a(ItemStack is, World world, EntityPlayer player) {
        if (!world.field_72995_K && !player.func_70093_af()) {
            LootbagItem.generateInventory(is);
            player.openGui((Object)LootBags.LootBagsInstance, 0, world, 0, 0, 0);
        }
        return is;
    }

    public boolean func_77648_a(ItemStack is, EntityPlayer player, World world, int x, int y, int z, int side, float px, float py, float pz) {
        if (!world.field_72995_K) {
            if (!player.func_70093_af()) {
                return false;
            }
            TileEntity te = world.func_147438_o(x, y, z);
            if (te instanceof IInventory) {
                LootbagItem.generateInventory(is);
                ItemStack[] iss = LootbagItem.getInventory(is);
                block0: for (int j = 0; j < iss.length; ++j) {
                    ItemStack stack = iss[j];
                    if (stack == null) continue;
                    IInventory ite = (IInventory)te;
                    int size = ite.func_70302_i_();
                    for (int i = 0; i < size; ++i) {
                        ItemStack itstack = ite.func_70301_a(i);
                        if (!ite.func_94041_b(i, stack) || itstack != null && !LootBags.areItemStacksEqualItem(itstack, stack, false, true) && ite.func_70301_a(i) != null) continue;
                        if (itstack == null) {
                            ite.func_70299_a(i, stack);
                            iss[j] = null;
                            continue block0;
                        }
                        if (itstack.field_77994_a + stack.field_77994_a <= itstack.func_77976_d()) {
                            itstack.field_77994_a += stack.field_77994_a;
                            iss[j] = null;
                            continue block0;
                        }
                        if (itstack.field_77994_a >= itstack.func_77976_d()) continue;
                        int diff = itstack.func_77976_d() - itstack.field_77994_a;
                        ite.func_70301_a((int)i).field_77994_a = ite.func_70301_a(i).func_77976_d();
                        stack.field_77994_a -= diff;
                        if (stack.field_77994_a > 0) continue;
                        iss[j] = null;
                        continue block0;
                    }
                }
                LootbagItem.setTagCompound(is, iss);
                if (LootbagItem.checkInventory(is)) {
                    player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c] = null;
                }
                return true;
            }
        }
        return false;
    }

    public String func_77667_c(ItemStack is) {
        switch (is.func_77960_j()) {
            case 0: {
                return "item.lootbag.common";
            }
            case 1: {
                return "item.lootbag.uncommon";
            }
            case 2: {
                return "item.lootbag.rare";
            }
            case 3: {
                return "item.lootbag.epic";
            }
            case 4: {
                return "item.lootbag.legendary";
            }
            case 5: {
                return "item.lootbag.bacon";
            }
            case 6: {
                return "item.lootbag.wornout";
            }
        }
        return "item.lootbag.derp";
    }

    public void func_94581_a(IIconRegister ir) {
        this.iconlist[0] = ir.func_94245_a("lootbags:lootbagCommonItemTexture");
        this.iconlist[1] = ir.func_94245_a("lootbags:lootbagUncommonItemTexture");
        this.iconlist[2] = ir.func_94245_a("lootbags:lootbagRareItemTexture");
        this.iconlist[3] = ir.func_94245_a("lootbags:lootbagEpicItemTexture");
        this.iconlist[4] = ir.func_94245_a("lootbags:lootbagLegendaryItemTexture");
        this.iconlist[5] = ir.func_94245_a("lootbags:lootbagBaconItemTexture");
        this.iconlist[6] = ir.func_94245_a("lootbags:lootbagCommonItemTexture");
    }

    public IIcon func_77617_a(int value) {
        return this.iconlist[value];
    }

    public IIcon getBlockTextureFromSideAndMetadata(int par1, int par2) {
        if (par2 < 0 || par2 >= this.iconlist.length) {
            par2 = 0;
        }
        return this.iconlist[par2];
    }

    public void func_150895_a(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        par3List.add(new ItemStack(par1, 1, 0));
        par3List.add(new ItemStack(par1, 1, 1));
        par3List.add(new ItemStack(par1, 1, 2));
        par3List.add(new ItemStack(par1, 1, 3));
        par3List.add(new ItemStack(par1, 1, 4));
        par3List.add(new ItemStack(par1, 1, 5));
    }

    public boolean func_77651_p() {
        return true;
    }
}

