/*
 * Decompiled with CFR 0.152.
 */
package extracells.tileentity;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.implementations.tiles.ITileStorageMonitorable;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridBlock;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.MachineSource;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IStorageMonitorable;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.util.AECableType;
import appeng.api.util.DimensionalCoord;
import cpw.mods.fml.common.FMLCommonHandler;
import extracells.api.IECTileEntity;
import extracells.api.IFluidInterface;
import extracells.container.IContainerListener;
import extracells.gridblock.ECFluidGridBlock;
import extracells.network.packet.other.IFluidSlotPartOrBlock;
import extracells.util.EmptyMeItemMonitor;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;

public class TileEntityFluidInterface
extends TileEntity
implements IActionHost,
IFluidHandler,
IECTileEntity,
IFluidInterface,
IFluidSlotPartOrBlock,
ITileStorageMonitorable,
IStorageMonitorable {
    List<IContainerListener> listeners = new ArrayList<IContainerListener>();
    private ECFluidGridBlock gridBlock;
    private IGridNode node = null;
    public FluidTank[] tanks = new FluidTank[6];
    public Integer[] fluidFilter = new Integer[this.tanks.length];
    public boolean doNextUpdate = false;
    private boolean wasIdle = false;
    private int tickCount = 0;
    private boolean isFirstGetGridNode = true;

    public TileEntityFluidInterface() {
        this.gridBlock = new ECFluidGridBlock(this);
        for (int i = 0; i < this.tanks.length; ++i) {
            this.tanks[i] = new FluidTank(10000){

                public FluidTank readFromNBT(NBTTagCompound nbt) {
                    if (!nbt.func_74764_b("Empty")) {
                        FluidStack fluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt);
                        this.setFluid(fluid);
                    } else {
                        this.setFluid(null);
                    }
                    return this;
                }
            };
            this.fluidFilter[i] = -1;
        }
    }

    public IGridNode getGridNode(ForgeDirection dir) {
        if (FMLCommonHandler.instance().getSide().isClient() && (this.func_145831_w() == null || this.func_145831_w().field_72995_K)) {
            return null;
        }
        if (this.isFirstGetGridNode) {
            this.isFirstGetGridNode = false;
            this.getActionableNode().updateState();
        }
        return this.node;
    }

    public AECableType getCableConnectionType(ForgeDirection dir) {
        return AECableType.DENSE;
    }

    public void securityBreak() {
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (from == ForgeDirection.UNKNOWN || resource == null) {
            return 0;
        }
        if ((this.tanks[from.ordinal()].getFluid() == null || this.tanks[from.ordinal()].getFluid().getFluid() == resource.getFluid()) && resource.getFluid() == FluidRegistry.getFluid((int)this.fluidFilter[from.ordinal()])) {
            int added = this.tanks[from.ordinal()].fill(resource.copy(), doFill);
            if (added == resource.amount) {
                this.doNextUpdate = true;
                return added;
            }
            added += this.fillToNetwork(new FluidStack(resource.getFluid(), resource.amount - added), doFill);
            this.doNextUpdate = true;
            return added;
        }
        int filled = 0;
        if ((filled += this.fillToNetwork(resource, doFill)) < resource.amount) {
            filled += this.tanks[from.ordinal()].fill(new FluidStack(resource.fluidID, resource.amount - filled), doFill);
        }
        if (filled > 0 && this.func_145831_w() != null) {
            this.func_145831_w().func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        this.doNextUpdate = true;
        return filled;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        FluidStack tankFluid = this.tanks[from.ordinal()].getFluid();
        if (resource == null || tankFluid == null || tankFluid.getFluid() != resource.getFluid()) {
            return null;
        }
        return this.drain(from, resource.amount, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        if (from == ForgeDirection.UNKNOWN) {
            return null;
        }
        FluidStack drained = this.tanks[from.ordinal()].drain(maxDrain, doDrain);
        if (drained != null && this.func_145831_w() != null) {
            this.func_145831_w().func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        this.doNextUpdate = true;
        return drained;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return from != ForgeDirection.UNKNOWN && this.tanks[from.ordinal()].fill(new FluidStack(fluid, 1), false) > 0;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        if (from == ForgeDirection.UNKNOWN) {
            return false;
        }
        FluidStack tankFluid = this.tanks[from.ordinal()].getFluid();
        return tankFluid != null && tankFluid.getFluid() == fluid;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        if (from == ForgeDirection.UNKNOWN) {
            return null;
        }
        return new FluidTankInfo[]{this.tanks[from.ordinal()].getInfo()};
    }

    public IGridNode getActionableNode() {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            return null;
        }
        if (this.node == null) {
            this.node = AEApi.instance().createGridNode((IGridBlock)this.gridBlock);
        }
        return this.node;
    }

    @Override
    public double getPowerUsage() {
        return 1.0;
    }

    @Override
    public DimensionalCoord getLocation() {
        return new DimensionalCoord((TileEntity)this);
    }

    public int fillToNetwork(FluidStack resource, boolean doFill) {
        IGridNode node = this.getGridNode(ForgeDirection.UNKNOWN);
        if (node == null || resource == null) {
            return 0;
        }
        IGrid grid = node.getGrid();
        if (grid == null) {
            return 0;
        }
        IStorageGrid storage = (IStorageGrid)grid.getCache(IStorageGrid.class);
        if (storage == null) {
            return 0;
        }
        FluidStack copy = resource.copy();
        IAEFluidStack notRemoved = doFill ? (IAEFluidStack)storage.getFluidInventory().injectItems((IAEStack)AEApi.instance().storage().createFluidStack(resource), Actionable.MODULATE, (BaseActionSource)new MachineSource((IActionHost)this)) : (IAEFluidStack)storage.getFluidInventory().injectItems((IAEStack)AEApi.instance().storage().createFluidStack(resource), Actionable.SIMULATE, (BaseActionSource)new MachineSource((IActionHost)this));
        if (notRemoved == null) {
            return resource.amount;
        }
        return (int)((long)resource.amount - notRemoved.getStackSize());
    }

    @Override
    public void setFilter(ForgeDirection side, Fluid fluid) {
        if (side == null || side == ForgeDirection.UNKNOWN) {
            return;
        }
        if (fluid == null) {
            this.fluidFilter[side.ordinal()] = -1;
            this.doNextUpdate = true;
            return;
        }
        this.fluidFilter[side.ordinal()] = fluid.getID();
        this.doNextUpdate = true;
    }

    @Override
    public Fluid getFilter(ForgeDirection side) {
        if (side == null || side == ForgeDirection.UNKNOWN) {
            return null;
        }
        return FluidRegistry.getFluid((int)this.fluidFilter[side.ordinal()]);
    }

    @Override
    public IFluidTank getFluidTank(ForgeDirection side) {
        if (side == null || side == ForgeDirection.UNKNOWN) {
            return null;
        }
        return this.tanks[side.ordinal()];
    }

    @Override
    public void setFluid(int _index, Fluid _fluid, EntityPlayer _player) {
        this.setFilter(ForgeDirection.getOrientation((int)_index), _fluid);
    }

    @Override
    public void setFluidTank(ForgeDirection side, FluidStack fluid) {
        if (side == null || side == ForgeDirection.UNKNOWN) {
            return;
        }
        this.tanks[side.ordinal()].setFluid(fluid);
        this.doNextUpdate = true;
    }

    private void forceUpdate() {
        this.func_145831_w().func_147471_g(this.field_145848_d, this.field_145848_d, this.field_145849_e);
        for (IContainerListener listener : this.listeners) {
            if (listener == null) continue;
            listener.updateContainer();
        }
        this.doNextUpdate = false;
    }

    public void registerListener(IContainerListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(IContainerListener listener) {
        this.listeners.remove(listener);
    }

    public void func_145845_h() {
        if (this.func_145831_w() == null || this.func_145831_w().field_72995_K) {
            return;
        }
        if (this.doNextUpdate) {
            this.forceUpdate();
        }
        this.tick();
    }

    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        for (int i = 0; i < this.tanks.length; ++i) {
            tag.func_74782_a("tank#" + i, (NBTBase)this.tanks[i].writeToNBT(new NBTTagCompound()));
            tag.func_74768_a("filter#" + i, this.fluidFilter[i].intValue());
        }
        IGridNode node = this.getGridNode(ForgeDirection.UNKNOWN);
        if (node != null) {
            NBTTagCompound nodeTag = new NBTTagCompound();
            node.saveToNBT("node0", nodeTag);
            tag.func_74782_a("nodes", (NBTBase)nodeTag);
        }
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        for (int i = 0; i < this.tanks.length; ++i) {
            if (tag.func_74764_b("tank#" + i)) {
                this.tanks[i].readFromNBT(tag.func_74775_l("tank#" + i));
            }
            if (!tag.func_74764_b("filter#" + i)) continue;
            this.fluidFilter[i] = tag.func_74762_e("filter#" + i);
        }
        IGridNode node = this.getGridNode(ForgeDirection.UNKNOWN);
        if (tag.func_74764_b("nodes") && node != null) {
            node.loadFromNBT("node0", tag.func_74775_l("nodes"));
            node.updateState();
        }
    }

    public Packet func_145844_m() {
        NBTTagCompound nbtTag = new NBTTagCompound();
        this.func_145841_b(nbtTag);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, nbtTag);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    private void tick() {
        if (this.tickCount < 40 && this.wasIdle) {
            ++this.tickCount;
            return;
        }
        this.tickCount = 0;
        this.wasIdle = true;
        if (this.node == null) {
            return;
        }
        IGrid grid = this.node.getGrid();
        if (grid == null) {
            return;
        }
        IStorageGrid storage = (IStorageGrid)grid.getCache(IStorageGrid.class);
        if (storage == null) {
            return;
        }
        for (int i = 0; i < this.tanks.length; ++i) {
            int accepted;
            IAEFluidStack extracted;
            FluidStack s;
            if (this.tanks[i].getFluid() != null && FluidRegistry.getFluid((int)this.fluidFilter[i]) != this.tanks[i].getFluid().getFluid() && (s = this.tanks[i].drain(20, false)) != null) {
                IAEFluidStack notAdded = (IAEFluidStack)storage.getFluidInventory().injectItems((IAEStack)AEApi.instance().storage().createFluidStack(s.copy()), Actionable.SIMULATE, (BaseActionSource)new MachineSource((IActionHost)this));
                if (notAdded != null) {
                    int toAdd = (int)((long)s.amount - notAdded.getStackSize());
                    storage.getFluidInventory().injectItems((IAEStack)AEApi.instance().storage().createFluidStack(this.tanks[i].drain(toAdd, true)), Actionable.MODULATE, (BaseActionSource)new MachineSource((IActionHost)this));
                    this.doNextUpdate = true;
                    this.wasIdle = false;
                } else {
                    storage.getFluidInventory().injectItems((IAEStack)AEApi.instance().storage().createFluidStack(this.tanks[i].drain(s.amount, true)), Actionable.MODULATE, (BaseActionSource)new MachineSource((IActionHost)this));
                    this.doNextUpdate = true;
                    this.wasIdle = false;
                }
            }
            if (this.tanks[i].getFluid() != null && this.tanks[i].getFluid().getFluid() != FluidRegistry.getFluid((int)this.fluidFilter[i]) || FluidRegistry.getFluid((int)this.fluidFilter[i]) == null || (extracted = (IAEFluidStack)storage.getFluidInventory().extractItems((IAEStack)AEApi.instance().storage().createFluidStack(new FluidStack(FluidRegistry.getFluid((int)this.fluidFilter[i]), 20)), Actionable.SIMULATE, (BaseActionSource)new MachineSource((IActionHost)this))) == null || (accepted = this.tanks[i].fill(extracted.getFluidStack(), false)) == 0) continue;
            this.tanks[i].fill(((IAEFluidStack)storage.getFluidInventory().extractItems((IAEStack)AEApi.instance().storage().createFluidStack(new FluidStack(FluidRegistry.getFluid((int)this.fluidFilter[i]), accepted)), Actionable.MODULATE, (BaseActionSource)new MachineSource((IActionHost)this))).getFluidStack(), true);
            this.doNextUpdate = true;
            this.wasIdle = false;
        }
    }

    public NBTTagCompound writeFilter(NBTTagCompound tag) {
        for (int i = 0; i < this.fluidFilter.length; ++i) {
            tag.func_74768_a("fluid#" + i, this.fluidFilter[i].intValue());
        }
        return tag;
    }

    public void readFilter(NBTTagCompound tag) {
        for (int i = 0; i < this.fluidFilter.length; ++i) {
            if (!tag.func_74764_b("fluid#" + i)) continue;
            this.fluidFilter[i] = tag.func_74762_e("fluid#" + i);
        }
    }

    public IStorageMonitorable getMonitorable(ForgeDirection side, BaseActionSource src) {
        return this;
    }

    public IMEMonitor<IAEItemStack> getItemInventory() {
        return new EmptyMeItemMonitor();
    }

    public IMEMonitor<IAEFluidStack> getFluidInventory() {
        if (this.getGridNode(ForgeDirection.UNKNOWN) == null) {
            return null;
        }
        IGrid grid = this.getGridNode(ForgeDirection.UNKNOWN).getGrid();
        if (grid == null) {
            return null;
        }
        IStorageGrid storage = (IStorageGrid)grid.getCache(IStorageGrid.class);
        if (storage == null) {
            return null;
        }
        return storage.getFluidInventory();
    }
}

