/*
 * Decompiled with CFR 0.152.
 */
package extracells.part;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.SecurityPermissions;
import appeng.api.implementations.tiles.ITileStorageMonitorable;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.MachineSource;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartRenderHelper;
import appeng.api.parts.PartItemStack;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IStorageMonitorable;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import extracells.api.IFluidInterface;
import extracells.container.ContainerFluidInterface;
import extracells.container.IContainerListener;
import extracells.gui.GuiFluidInterface;
import extracells.network.packet.other.IFluidSlotPartOrBlock;
import extracells.part.PartECBase;
import extracells.registries.ItemEnum;
import extracells.registries.PartEnum;
import extracells.render.TextureManager;
import extracells.util.EmptyMeItemMonitor;
import extracells.util.PermissionUtil;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.util.Vec3;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;

public class PartFluidInterface
extends PartECBase
implements IFluidHandler,
IFluidInterface,
IFluidSlotPartOrBlock,
ITileStorageMonitorable,
IStorageMonitorable,
IGridTickable {
    List<IContainerListener> listeners = new ArrayList<IContainerListener>();
    private FluidTank tank = new FluidTank(10000){

        public FluidTank readFromNBT(NBTTagCompound nbt) {
            if (!nbt.func_74764_b("Empty")) {
                FluidStack fluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt);
                this.setFluid(fluid);
            } else {
                this.setFluid(null);
            }
            return this;
        }
    };
    private int fluidFilter = -1;
    public boolean doNextUpdate = false;
    private boolean needBreake = false;
    private int tickCount = 0;

    @Override
    public void initializePart(ItemStack partStack) {
        if (partStack.func_77942_o()) {
            this.readFilter(partStack.func_77978_p());
        }
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (resource == null) {
            return 0;
        }
        if ((this.tank.getFluid() == null || this.tank.getFluid().getFluid() == resource.getFluid()) && resource.getFluid() == FluidRegistry.getFluid((int)this.fluidFilter)) {
            int added = this.tank.fill(resource.copy(), doFill);
            if (added == resource.amount) {
                this.doNextUpdate = true;
                return added;
            }
            added += this.fillToNetwork(new FluidStack(resource.getFluid(), resource.amount - added), doFill);
            this.doNextUpdate = true;
            return added;
        }
        int filled = 0;
        if ((filled += this.fillToNetwork(resource, doFill)) < resource.amount) {
            filled += this.tank.fill(new FluidStack(resource.fluidID, resource.amount - filled), doFill);
        }
        if (filled > 0) {
            this.getHost().markForUpdate();
        }
        this.doNextUpdate = true;
        return filled;
    }

    public int fillToNetwork(FluidStack resource, boolean doFill) {
        IGridNode node = this.getGridNode(ForgeDirection.UNKNOWN);
        if (node == null || resource == null) {
            return 0;
        }
        IGrid grid = node.getGrid();
        if (grid == null) {
            return 0;
        }
        IStorageGrid storage = (IStorageGrid)grid.getCache(IStorageGrid.class);
        if (storage == null) {
            return 0;
        }
        FluidStack copy = resource.copy();
        IAEFluidStack notRemoved = doFill ? (IAEFluidStack)storage.getFluidInventory().injectItems((IAEStack)AEApi.instance().storage().createFluidStack(resource), Actionable.MODULATE, (BaseActionSource)new MachineSource((IActionHost)this)) : (IAEFluidStack)storage.getFluidInventory().injectItems((IAEStack)AEApi.instance().storage().createFluidStack(resource), Actionable.SIMULATE, (BaseActionSource)new MachineSource((IActionHost)this));
        if (notRemoved == null) {
            return resource.amount;
        }
        return (int)((long)resource.amount - notRemoved.getStackSize());
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        FluidStack tankFluid = this.tank.getFluid();
        if (resource == null || tankFluid == null || tankFluid.getFluid() != resource.getFluid()) {
            return null;
        }
        return this.drain(from, resource.amount, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        FluidStack drained = this.tank.drain(maxDrain, doDrain);
        if (drained != null) {
            this.getHost().markForUpdate();
        }
        this.doNextUpdate = true;
        return drained;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.tank.fill(new FluidStack(fluid, 1), false) > 0;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        FluidStack tankFluid = this.tank.getFluid();
        return tankFluid != null && tankFluid.getFluid() == fluid;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.tank.getInfo()};
    }

    @Override
    public double getPowerUsage() {
        return 1.0;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderInventory(IPartRenderHelper rh, RenderBlocks renderer) {
        Tessellator ts = Tessellator.field_78398_a;
        IIcon side = TextureManager.BUS_SIDE.getTexture();
        rh.setTexture(side, side, side, TextureManager.INTERFACE.getTextures()[0], side, side);
        rh.setBounds(2.0f, 2.0f, 14.0f, 14.0f, 14.0f, 16.0f);
        rh.renderInventoryBox(renderer);
        rh.renderInventoryFace(TextureManager.INTERFACE.getTextures()[0], ForgeDirection.SOUTH, renderer);
        rh.setTexture(side);
        rh.setBounds(5.0f, 5.0f, 12.0f, 11.0f, 11.0f, 14.0f);
        rh.renderInventoryBox(renderer);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderStatic(int x, int y, int z, IPartRenderHelper rh, RenderBlocks renderer) {
        Tessellator ts = Tessellator.field_78398_a;
        IIcon side = TextureManager.BUS_SIDE.getTexture();
        rh.setTexture(side, side, side, TextureManager.INTERFACE.getTextures()[0], side, side);
        rh.setBounds(2.0f, 2.0f, 14.0f, 14.0f, 14.0f, 16.0f);
        rh.renderBlock(x, y, z, renderer);
        ts.func_78380_c(0x1400000);
        rh.renderFace(x, y, z, TextureManager.INTERFACE.getTextures()[0], ForgeDirection.SOUTH, renderer);
        rh.setTexture(side);
        rh.setBounds(5.0f, 5.0f, 12.0f, 11.0f, 11.0f, 14.0f);
        rh.renderBlock(x, y, z, renderer);
    }

    @Override
    public void getBoxes(IPartCollisionHelper bch) {
        bch.addBox(2.0, 2.0, 14.0, 14.0, 14.0, 16.0);
        bch.addBox(5.0, 5.0, 12.0, 11.0, 11.0, 14.0);
    }

    @Override
    public int cableConnectionRenderTo() {
        return 3;
    }

    public IMEMonitor<IAEItemStack> getItemInventory() {
        return new EmptyMeItemMonitor();
    }

    public IMEMonitor<IAEFluidStack> getFluidInventory() {
        if (this.getGridNode(ForgeDirection.UNKNOWN) == null) {
            return null;
        }
        IGrid grid = this.getGridNode(ForgeDirection.UNKNOWN).getGrid();
        if (grid == null) {
            return null;
        }
        IStorageGrid storage = (IStorageGrid)grid.getCache(IStorageGrid.class);
        if (storage == null) {
            return null;
        }
        return storage.getFluidInventory();
    }

    public IStorageMonitorable getMonitorable(ForgeDirection side, BaseActionSource src) {
        return this;
    }

    @Override
    public void setFluid(int _index, Fluid _fluid, EntityPlayer _player) {
        this.setFilter(ForgeDirection.getOrientation((int)_index), _fluid);
    }

    @Override
    public void setFilter(ForgeDirection side, Fluid fluid) {
        if (fluid == null) {
            this.fluidFilter = -1;
            this.doNextUpdate = true;
            return;
        }
        this.fluidFilter = fluid.getID();
        this.doNextUpdate = true;
    }

    @Override
    public Fluid getFilter(ForgeDirection side) {
        return FluidRegistry.getFluid((int)this.fluidFilter);
    }

    @Override
    public IFluidTank getFluidTank(ForgeDirection side) {
        return this.tank;
    }

    @Override
    public void setFluidTank(ForgeDirection side, FluidStack fluid) {
        this.tank.setFluid(fluid);
        this.doNextUpdate = true;
    }

    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(1, 40, false, false);
    }

    public TickRateModulation tickingRequest(IGridNode node, int TicksSinceLastCall) {
        FluidStack s;
        IGrid grid;
        if (this.doNextUpdate) {
            this.forceUpdate();
        }
        if ((grid = node.getGrid()) == null) {
            return TickRateModulation.URGENT;
        }
        IStorageGrid storage = (IStorageGrid)grid.getCache(IStorageGrid.class);
        if (storage == null) {
            return TickRateModulation.URGENT;
        }
        if (this.tank.getFluid() != null && FluidRegistry.getFluid((int)this.fluidFilter) != this.tank.getFluid().getFluid() && (s = this.tank.drain(20, false)) != null) {
            IAEFluidStack notAdded = (IAEFluidStack)storage.getFluidInventory().injectItems((IAEStack)AEApi.instance().storage().createFluidStack(s.copy()), Actionable.SIMULATE, (BaseActionSource)new MachineSource((IActionHost)this));
            if (notAdded != null) {
                int toAdd = (int)((long)s.amount - notAdded.getStackSize());
                storage.getFluidInventory().injectItems((IAEStack)AEApi.instance().storage().createFluidStack(this.tank.drain(toAdd, true)), Actionable.MODULATE, (BaseActionSource)new MachineSource((IActionHost)this));
                this.doNextUpdate = true;
                this.needBreake = false;
            } else {
                storage.getFluidInventory().injectItems((IAEStack)AEApi.instance().storage().createFluidStack(this.tank.drain(s.amount, true)), Actionable.MODULATE, (BaseActionSource)new MachineSource((IActionHost)this));
                this.doNextUpdate = true;
                this.needBreake = false;
            }
        }
        if ((this.tank.getFluid() == null || this.tank.getFluid().getFluid() == FluidRegistry.getFluid((int)this.fluidFilter)) && FluidRegistry.getFluid((int)this.fluidFilter) != null) {
            IAEFluidStack extracted = (IAEFluidStack)storage.getFluidInventory().extractItems((IAEStack)AEApi.instance().storage().createFluidStack(new FluidStack(FluidRegistry.getFluid((int)this.fluidFilter), 20)), Actionable.SIMULATE, (BaseActionSource)new MachineSource((IActionHost)this));
            if (extracted == null) {
                return TickRateModulation.URGENT;
            }
            int accepted = this.tank.fill(extracted.getFluidStack(), false);
            if (accepted == 0) {
                return TickRateModulation.URGENT;
            }
            this.tank.fill(((IAEFluidStack)storage.getFluidInventory().extractItems((IAEStack)AEApi.instance().storage().createFluidStack(new FluidStack(FluidRegistry.getFluid((int)this.fluidFilter), accepted)), Actionable.MODULATE, (BaseActionSource)new MachineSource((IActionHost)this))).getFluidStack(), true);
            this.doNextUpdate = true;
            this.needBreake = false;
        }
        return TickRateModulation.URGENT;
    }

    private void forceUpdate() {
        this.getHost().markForUpdate();
        for (IContainerListener listener : this.listeners) {
            if (listener == null) continue;
            listener.updateContainer();
        }
        this.doNextUpdate = false;
    }

    public void registerListener(IContainerListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(IContainerListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void writeToStream(ByteBuf data) throws IOException {
        super.writeToStream(data);
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74782_a("tank", (NBTBase)this.tank.writeToNBT(new NBTTagCompound()));
        tag.func_74768_a("filter", this.fluidFilter);
        ByteBufUtils.writeTag((ByteBuf)data, (NBTTagCompound)tag);
    }

    @Override
    public boolean readFromStream(ByteBuf data) throws IOException {
        super.readFromStream(data);
        NBTTagCompound tag = ByteBufUtils.readTag((ByteBuf)data);
        if (tag.func_74764_b("tank")) {
            this.tank.readFromNBT(tag.func_74775_l("tank"));
        }
        if (tag.func_74764_b("filter")) {
            this.fluidFilter = tag.func_74762_e("filter");
        }
        return true;
    }

    @Override
    public Object getServerGuiElement(EntityPlayer player) {
        return new ContainerFluidInterface(player, this);
    }

    @Override
    public Object getClientGuiElement(EntityPlayer player) {
        return new GuiFluidInterface(player, this, this.getSide());
    }

    @Override
    public ItemStack getItemStack(PartItemStack type) {
        ItemStack is = new ItemStack(ItemEnum.PARTITEM.getItem(), 1, PartEnum.getPartID(this));
        if (type != PartItemStack.Break) {
            is.func_77982_d(this.writeFilter(new NBTTagCompound()));
        }
        return is;
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74782_a("tank", (NBTBase)this.tank.writeToNBT(new NBTTagCompound()));
        data.func_74768_a("filter", this.fluidFilter);
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        if (data.func_74764_b("tank")) {
            this.tank.readFromNBT(data.func_74775_l("tank"));
        }
        if (data.func_74764_b("filter")) {
            this.fluidFilter = data.func_74762_e("filter");
        }
    }

    public NBTTagCompound writeFilter(NBTTagCompound tag) {
        if (FluidRegistry.getFluid((int)this.fluidFilter) == null) {
            return null;
        }
        tag.func_74768_a("filter", this.fluidFilter);
        return tag;
    }

    public void readFilter(NBTTagCompound tag) {
        if (tag.func_74764_b("filter")) {
            this.fluidFilter = tag.func_74762_e("filter");
        }
    }

    @Override
    public boolean onActivate(EntityPlayer player, Vec3 pos) {
        if (PermissionUtil.hasPermission(player, SecurityPermissions.BUILD, this)) {
            return super.onActivate(player, pos);
        }
        return false;
    }
}

