/*
 * Decompiled with CFR 0.152.
 */
package extracells.network;

import appeng.api.parts.IPartHost;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.data.IAEFluidStack;
import cpw.mods.fml.common.network.IGuiHandler;
import extracells.Extracells;
import extracells.api.IFluidInterface;
import extracells.api.IPortableFluidStorageCell;
import extracells.api.IWirelessFluidTermHandler;
import extracells.container.ContainerFluidCrafter;
import extracells.container.ContainerFluidInterface;
import extracells.container.ContainerFluidStorage;
import extracells.gui.GuiFluidCrafter;
import extracells.gui.GuiFluidInterface;
import extracells.gui.GuiFluidStorage;
import extracells.part.PartECBase;
import extracells.registries.BlockEnum;
import extracells.tileentity.TileEntityFluidCrafter;
import extracells.tileentity.TileEntityFluidInterface;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class GuiHandler
implements IGuiHandler {
    private static Object[] temp;

    private static Object getPartContainer(ForgeDirection side, EntityPlayer player, World world, int x, int y, int z) {
        PartECBase part = (PartECBase)((IPartHost)world.func_147438_o(x, y, z)).getPart(side);
        return part.getServerGuiElement(player);
    }

    public static Object getPartGui(ForgeDirection side, EntityPlayer player, World world, int x, int y, int z) {
        IPartHost tileEntity = (IPartHost)world.func_147438_o(x, y, z);
        PartECBase part = (PartECBase)tileEntity.getPart(side);
        return part.getClientGuiElement(player);
    }

    private static Object getContainer(int ID, EntityPlayer player, Object[] args) {
        switch (ID) {
            case 0: {
                IMEMonitor fluidInventory = (IMEMonitor)args[0];
                return new ContainerFluidStorage((IMEMonitor<IAEFluidStack>)fluidInventory, player);
            }
            case 1: {
                IMEMonitor fluidInventory2 = (IMEMonitor)args[0];
                IWirelessFluidTermHandler handler = (IWirelessFluidTermHandler)args[1];
                return new ContainerFluidStorage((IMEMonitor<IAEFluidStack>)fluidInventory2, player, handler);
            }
            case 3: {
                IMEMonitor fluidInventory3 = (IMEMonitor)args[0];
                IPortableFluidStorageCell storageCell = (IPortableFluidStorageCell)args[1];
                return new ContainerFluidStorage((IMEMonitor<IAEFluidStack>)fluidInventory3, player, storageCell);
            }
        }
        return null;
    }

    public static Object getGui(int ID, EntityPlayer player) {
        switch (ID) {
            case 0: {
                return new GuiFluidStorage(player, "extracells.part.fluid.terminal.name");
            }
            case 1: {
                return new GuiFluidStorage(player, "extracells.part.fluid.terminal.name");
            }
            case 3: {
                return new GuiFluidStorage(player, "extracells.item.storage.fluid.portable.name");
            }
        }
        return null;
    }

    public static int getGuiId(PartECBase part) {
        return part.getSide().ordinal();
    }

    public static int getGuiId(int guiId) {
        return guiId + 6;
    }

    public static void launchGui(int ID, EntityPlayer player, Object ... args) {
        temp = args;
        player.openGui((Object)Extracells.instance, ID, null, 0, 0, 0);
    }

    public static void launchGui(int ID, EntityPlayer player, World world, int x, int y, int z) {
        player.openGui((Object)Extracells.instance, ID, world, x, y, z);
    }

    public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        ForgeDirection side = ForgeDirection.getOrientation((int)ID);
        if (world != null && world.func_147439_a(x, y, z) == BlockEnum.FLUIDCRAFTER.getBlock()) {
            TileEntity tileEntity = world.func_147438_o(x, y, z);
            if (tileEntity == null || !(tileEntity instanceof TileEntityFluidCrafter)) {
                return null;
            }
            return new ContainerFluidCrafter(player.field_71071_by, ((TileEntityFluidCrafter)tileEntity).getInventory());
        }
        if (world != null && world.func_147439_a(x, y, z) == BlockEnum.ECBASEBLOCK.getBlock()) {
            TileEntity tileEntity = world.func_147438_o(x, y, z);
            if (tileEntity == null || !(tileEntity instanceof TileEntityFluidInterface)) {
                return null;
            }
            return new ContainerFluidInterface(player, (IFluidInterface)tileEntity);
        }
        if (world != null && side != ForgeDirection.UNKNOWN) {
            return GuiHandler.getPartContainer(side, player, world, x, y, z);
        }
        return GuiHandler.getContainer(ID - 6, player, temp);
    }

    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        ForgeDirection side = ForgeDirection.getOrientation((int)ID);
        if (world.func_147439_a(x, y, z) == BlockEnum.FLUIDCRAFTER.getBlock()) {
            TileEntity tileEntity = world.func_147438_o(x, y, z);
            if (tileEntity == null || !(tileEntity instanceof TileEntityFluidCrafter)) {
                return null;
            }
            return new GuiFluidCrafter(player.field_71071_by, ((TileEntityFluidCrafter)tileEntity).getInventory());
        }
        if (world != null && world.func_147439_a(x, y, z) == BlockEnum.ECBASEBLOCK.getBlock()) {
            TileEntity tileEntity = world.func_147438_o(x, y, z);
            if (tileEntity == null || !(tileEntity instanceof TileEntityFluidInterface)) {
                return null;
            }
            return new GuiFluidInterface(player, (IFluidInterface)tileEntity);
        }
        if (world != null && side != ForgeDirection.UNKNOWN) {
            return GuiHandler.getPartGui(side, player, world, x, y, z);
        }
        return GuiHandler.getGui(ID - 6, player);
    }
}

