/*
 * Decompiled with CFR 0.152.
 */
package extracells.inventory;

import appeng.api.AEApi;
import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.implementations.tiles.ITileStorageMonitorable;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.events.MENetworkCellArrayUpdate;
import appeng.api.networking.events.MENetworkEvent;
import appeng.api.networking.events.MENetworkStorageEvent;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.MachineSource;
import appeng.api.networking.storage.IBaseMonitor;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IMEMonitorHandlerReceiver;
import appeng.api.storage.IStorageMonitorable;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import extracells.part.PartFluidStorage;
import extracells.util.FluidUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class HandlerPartStorageFluid
implements IMEInventoryHandler<IAEFluidStack>,
IMEMonitorHandlerReceiver<IAEFluidStack> {
    private PartFluidStorage node;
    private IFluidHandler tank;
    private AccessRestriction access;
    private List<Fluid> prioritizedFluids = new ArrayList<Fluid>();
    private boolean inverted;
    public ITileStorageMonitorable externalSystem;

    public HandlerPartStorageFluid(PartFluidStorage _node) {
        this.node = _node;
    }

    public AccessRestriction getAccess() {
        return this.access;
    }

    public boolean isPrioritized(IAEFluidStack input) {
        if (input == null) {
            return false;
        }
        for (Fluid fluid : this.prioritizedFluids) {
            if (fluid != input.getFluid()) continue;
            return true;
        }
        return false;
    }

    public boolean canAccept(IAEFluidStack input) {
        if (this.tank == null && this.externalSystem == null || this.access == AccessRestriction.WRITE || this.access == AccessRestriction.NO_ACCESS || input == null) {
            return false;
        }
        if (this.externalSystem != null) {
            IStorageMonitorable monitor = this.externalSystem.getMonitorable(this.node.getSide().getOpposite(), (BaseActionSource)new MachineSource((IActionHost)this.node));
            if (monitor == null) {
                return false;
            }
            IMEMonitor fluidInventory = monitor.getFluidInventory();
            if (fluidInventory == null) {
                return false;
            }
            return fluidInventory.canAccept((IAEStack)input);
        }
        FluidTankInfo[] infoArray = this.tank.getTankInfo(this.node.getSide().getOpposite());
        if (infoArray != null && infoArray.length > 0) {
            FluidTankInfo info = infoArray[0];
            if (info.fluid == null || info.fluid.amount == 0 || info.fluid.fluidID == input.getFluidStack().fluidID) {
                if (this.inverted) {
                    return !this.prioritizedFluids.isEmpty() || !this.isPrioritized(input);
                }
                return this.prioritizedFluids.isEmpty() || this.isPrioritized(input);
            }
        }
        return false;
    }

    public int getPriority() {
        return this.node.getPriority();
    }

    public int getSlot() {
        return 0;
    }

    public boolean validForPass(int i) {
        return true;
    }

    public IAEFluidStack injectItems(IAEFluidStack input, Actionable mode, BaseActionSource src) {
        if (this.externalSystem != null && input != null) {
            IStorageMonitorable monitor = this.externalSystem.getMonitorable(this.node.getSide().getOpposite(), src);
            if (monitor == null) {
                return null;
            }
            IMEMonitor fluidInventory = monitor.getFluidInventory();
            if (fluidInventory == null) {
                return null;
            }
            return (IAEFluidStack)fluidInventory.injectItems((IAEStack)input, mode, src);
        }
        if (this.tank == null || input == null || !this.canAccept(input)) {
            return input;
        }
        FluidStack toFill = input.getFluidStack();
        int filled = 0;
        int filled2 = 0;
        while ((filled2 = this.tank.fill(this.node.getSide().getOpposite(), new FluidStack(toFill.fluidID, toFill.amount - filled), mode == Actionable.MODULATE)) != 0 && (filled += filled2) != toFill.amount) {
        }
        if (filled == toFill.amount) {
            return null;
        }
        return FluidUtil.createAEFluidStack(toFill.fluidID, (long)(toFill.amount - filled));
    }

    public IAEFluidStack extractItems(IAEFluidStack request, Actionable mode, BaseActionSource src) {
        FluidStack drain;
        if (this.externalSystem != null && request != null && (AccessRestriction.WRITE != this.access || AccessRestriction.NO_ACCESS != this.access)) {
            IStorageMonitorable monitor = this.externalSystem.getMonitorable(this.node.getSide().getOpposite(), src);
            if (monitor == null) {
                return null;
            }
            IMEMonitor fluidInventory = monitor.getFluidInventory();
            if (fluidInventory == null) {
                return null;
            }
            return (IAEFluidStack)fluidInventory.extractItems((IAEStack)request, mode, src);
        }
        if (this.tank == null || request == null || this.access == AccessRestriction.WRITE || this.access == AccessRestriction.NO_ACCESS) {
            return null;
        }
        FluidStack toDrain = request.getFluidStack();
        int drained = 0;
        int drained2 = 0;
        while (toDrain.amount != (drained += (drained2 = (drain = this.tank.drain(this.node.getSide().getOpposite(), new FluidStack(toDrain.fluidID, toDrain.amount - drained), mode == Actionable.MODULATE)) == null ? 0 : drain.amount)) && drained2 != 0) {
        }
        if (drained == 0) {
            return null;
        }
        if (drained == toDrain.amount) {
            return request;
        }
        return FluidUtil.createAEFluidStack(toDrain.fluidID, (long)drained);
    }

    public IItemList<IAEFluidStack> getAvailableItems(IItemList<IAEFluidStack> out) {
        FluidTankInfo[] infoArray;
        if (this.externalSystem != null) {
            IStorageMonitorable monitor = this.externalSystem.getMonitorable(this.node.getSide().getOpposite(), (BaseActionSource)new MachineSource((IActionHost)this.node));
            if (monitor == null) {
                return out;
            }
            IMEMonitor fluidInventory = monitor.getFluidInventory();
            if (fluidInventory == null) {
                return out;
            }
            IItemList list = this.externalSystem.getMonitorable(this.node.getSide().getOpposite(), (BaseActionSource)new MachineSource((IActionHost)this.node)).getFluidInventory().getStorageList();
            for (IAEFluidStack stack : list) {
                out.add((IAEStack)stack);
            }
        } else if (this.tank != null && (infoArray = this.tank.getTankInfo(this.node.getSide().getOpposite())) != null && infoArray.length > 0) {
            out.add((IAEStack)AEApi.instance().storage().createFluidStack(infoArray[0].fluid));
        }
        return out;
    }

    public StorageChannel getChannel() {
        return StorageChannel.FLUIDS;
    }

    public void onNeighborChange() {
        IMEMonitor fluidInventory;
        IStorageMonitorable monitor;
        if (this.externalSystem != null && (monitor = this.externalSystem.getMonitorable(this.node.getSide().getOpposite(), (BaseActionSource)new MachineSource((IActionHost)this.node))) != null && (fluidInventory = monitor.getFluidInventory()) != null) {
            fluidInventory.removeListener((IMEMonitorHandlerReceiver)this);
        }
        this.tank = null;
        ForgeDirection orientation = this.node.getSide();
        TileEntity hostTile = this.node.getHostTile();
        if (hostTile == null) {
            return;
        }
        if (hostTile.func_145831_w() == null) {
            return;
        }
        TileEntity tileEntity = hostTile.func_145831_w().func_147438_o(hostTile.field_145851_c + orientation.offsetX, hostTile.field_145848_d + orientation.offsetY, hostTile.field_145849_e + orientation.offsetZ);
        this.tank = null;
        this.externalSystem = null;
        if (tileEntity instanceof ITileStorageMonitorable) {
            this.externalSystem = (ITileStorageMonitorable)tileEntity;
            IStorageMonitorable monitor2 = this.externalSystem.getMonitorable(this.node.getSide().getOpposite(), (BaseActionSource)new MachineSource((IActionHost)this.node));
            if (monitor2 == null) {
                return;
            }
            IMEMonitor fluidInventory2 = monitor2.getFluidInventory();
            if (fluidInventory2 == null) {
                return;
            }
            fluidInventory2.addListener((IMEMonitorHandlerReceiver)this, null);
            return;
        }
        if (tileEntity instanceof IFluidHandler) {
            this.tank = (IFluidHandler)tileEntity;
        }
    }

    public void setInverted(boolean _inverted) {
        this.inverted = _inverted;
    }

    public void setPrioritizedFluids(Fluid[] _fluids) {
        this.prioritizedFluids.clear();
        for (Fluid fluid : _fluids) {
            if (fluid == null) continue;
            this.prioritizedFluids.add(fluid);
        }
    }

    public boolean isValid(Object verificationToken) {
        return true;
    }

    public void postChange(IBaseMonitor<IAEFluidStack> monitor, Iterable<IAEFluidStack> change, BaseActionSource actionSource) {
        IGridNode gridNode = this.node.getGridNode();
        if (gridNode != null) {
            IGrid grid = gridNode.getGrid();
            if (grid != null) {
                grid.postEvent((MENetworkEvent)new MENetworkCellArrayUpdate());
                gridNode.getGrid().postEvent((MENetworkEvent)new MENetworkStorageEvent(this.node.getGridBlock().getFluidMonitor(), StorageChannel.FLUIDS));
            }
            this.node.getHost().markForUpdate();
        }
    }

    public void onListUpdate() {
    }
}

