/*
 * Decompiled with CFR 0.152.
 */
package extracells.crafting;

import appeng.api.AEApi;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import extracells.api.crafting.IFluidCraftingPatternDetails;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;

public class CraftingPattern
implements IFluidCraftingPatternDetails {
    private final ICraftingPatternDetails pattern;
    private IAEFluidStack[] fluidsCondensed = null;
    private IAEFluidStack[] fluids = null;

    public CraftingPattern(ICraftingPatternDetails _pattern) {
        this.pattern = _pattern;
    }

    public ItemStack getPattern() {
        return this.pattern.getPattern();
    }

    public boolean isValidItemForSlot(int slotIndex, ItemStack itemStack, World world) {
        return this.pattern.isValidItemForSlot(slotIndex, itemStack, world);
    }

    public boolean isCraftable() {
        return false;
    }

    public IAEItemStack[] getInputs() {
        return this.removeFluidContainers(this.pattern.getInputs(), false);
    }

    public IAEItemStack[] getCondensedInputs() {
        return this.removeFluidContainers(this.pattern.getCondensedInputs(), true);
    }

    public IAEItemStack[] getCondensedOutputs() {
        return this.pattern.getCondensedOutputs();
    }

    public IAEItemStack[] getOutputs() {
        return this.pattern.getOutputs();
    }

    public boolean canSubstitute() {
        return this.pattern.canSubstitute();
    }

    public ItemStack getOutput(InventoryCrafting craftingInv, World world) {
        return this.pattern.getOutput(craftingInv, world);
    }

    public void setPriority(int priority) {
        this.pattern.setPriority(priority);
    }

    @Override
    public IAEFluidStack[] getCondensedFluidInputs() {
        if (this.fluidsCondensed == null) {
            this.getCondensedInputs();
        }
        return this.fluidsCondensed;
    }

    @Override
    public IAEFluidStack[] getFluidInputs() {
        if (this.fluids == null) {
            this.getInputs();
        }
        return this.fluids;
    }

    public IAEItemStack[] removeFluidContainers(IAEItemStack[] requirements, boolean isCondenced) {
        IAEItemStack[] returnStack = new IAEItemStack[requirements.length];
        IAEFluidStack[] fluidStacks = new IAEFluidStack[requirements.length];
        int removed = 0;
        int i = 0;
        for (IAEItemStack currentRequirement : requirements) {
            if (currentRequirement != null) {
                FluidStack fluid = null;
                if (FluidContainerRegistry.isFilledContainer((ItemStack)currentRequirement.getItemStack())) {
                    fluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)currentRequirement.getItemStack());
                } else if (currentRequirement.getItem() instanceof IFluidContainerItem) {
                    fluid = ((IFluidContainerItem)currentRequirement.getItem()).getFluid(currentRequirement.getItemStack());
                }
                if (fluid == null) {
                    returnStack[i] = currentRequirement;
                } else {
                    ++removed;
                    fluidStacks[i] = AEApi.instance().storage().createFluidStack(new FluidStack(FluidContainerRegistry.getFluidForFilledItem((ItemStack)currentRequirement.getItemStack()), (int)(1000L * currentRequirement.getStackSize())));
                }
            }
            ++i;
        }
        if (isCondenced) {
            int i2 = 0;
            IAEFluidStack[] fluids = new IAEFluidStack[removed];
            for (IAEFluidStack fluid : fluidStacks) {
                if (fluid == null) continue;
                fluids[i2] = fluid;
                ++i2;
            }
            int i3 = 0;
            IAEItemStack[] items = new IAEItemStack[requirements.length - removed];
            for (IAEItemStack item : returnStack) {
                if (item == null) continue;
                items[i3] = item;
                ++i3;
            }
            returnStack = items;
            this.fluidsCondensed = fluids;
        } else {
            this.fluids = fluidStacks;
        }
        return returnStack;
    }

    public int getPriority() {
        return this.pattern.getPriority();
    }
}

