/*
 * Decompiled with CFR 0.152.
 */
package extracells.container;

import appeng.api.AEApi;
import appeng.api.config.SecurityPermissions;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.storage.IBaseMonitor;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IMEMonitorHandlerReceiver;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IItemList;
import extracells.container.slot.SlotRespective;
import extracells.gui.GuiFluidTerminal;
import extracells.gui.widget.fluid.IFluidSelectorContainer;
import extracells.network.packet.part.PacketFluidTerminal;
import extracells.part.PartFluidTerminal;
import extracells.util.PermissionUtil;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.inventory.SlotFurnace;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;

public class ContainerFluidTerminal
extends Container
implements IMEMonitorHandlerReceiver<IAEFluidStack>,
IFluidSelectorContainer {
    private PartFluidTerminal terminal;
    private IMEMonitor<IAEFluidStack> monitor;
    private IItemList<IAEFluidStack> fluidStackList = AEApi.instance().storage().createFluidList();
    private Fluid selectedFluid;
    private EntityPlayer player;
    private GuiFluidTerminal guiFluidTerminal;

    public ContainerFluidTerminal(PartFluidTerminal _terminal, EntityPlayer _player) {
        this.terminal = _terminal;
        this.player = _player;
        if (!this.player.field_70170_p.field_72995_K) {
            this.monitor = this.terminal.getGridBlock().getFluidMonitor();
            if (this.monitor != null) {
                this.monitor.addListener((IMEMonitorHandlerReceiver)this, null);
                this.fluidStackList = this.monitor.getStorageList();
            }
            this.terminal.addContainer(this);
        }
        this.func_75146_a(new SlotRespective(this.terminal.getInventory(), 0, 8, 74));
        this.func_75146_a((Slot)new SlotFurnace(this.player, this.terminal.getInventory(), 1, 26, 74));
        this.bindPlayerInventory(this.player.field_71071_by);
    }

    public PartFluidTerminal getTerminal() {
        return this.terminal;
    }

    protected void bindPlayerInventory(InventoryPlayer inventoryPlayer) {
        int i;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)inventoryPlayer, j + i * 9 + 9, 8 + j * 18, i * 18 + 104));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.func_75146_a(new Slot((IInventory)inventoryPlayer, i, 8 + i * 18, 162));
        }
    }

    public void setGui(GuiFluidTerminal _guiFluidTerminal) {
        if (_guiFluidTerminal != null) {
            this.guiFluidTerminal = _guiFluidTerminal;
        }
    }

    public boolean func_75145_c(EntityPlayer entityplayer) {
        return true;
    }

    public boolean isValid(Object verificationToken) {
        return true;
    }

    public void postChange(IBaseMonitor<IAEFluidStack> monitor, Iterable<IAEFluidStack> change, BaseActionSource actionSource) {
        this.fluidStackList = ((IMEMonitor)monitor).getStorageList();
        new PacketFluidTerminal(this.player, this.fluidStackList).sendPacketToPlayer(this.player);
    }

    public void func_75134_a(EntityPlayer entityPlayer) {
        super.func_75134_a(entityPlayer);
        if (!entityPlayer.field_70170_p.field_72995_K) {
            if (this.monitor != null) {
                this.monitor.removeListener((IMEMonitorHandlerReceiver)this);
            }
            this.terminal.removeContainer(this);
        }
    }

    public void onListUpdate() {
    }

    public void forceFluidUpdate() {
        if (this.monitor != null) {
            new PacketFluidTerminal(this.player, (IItemList<IAEFluidStack>)this.monitor.getStorageList()).sendPacketToPlayer(this.player);
        }
    }

    public void updateFluidList(IItemList<IAEFluidStack> _fluidStackList) {
        this.fluidStackList = _fluidStackList;
        if (this.guiFluidTerminal != null) {
            this.guiFluidTerminal.updateFluids();
        }
    }

    public Fluid getSelectedFluid() {
        return this.selectedFluid;
    }

    @Override
    public void setSelectedFluid(Fluid _selectedFluid) {
        new PacketFluidTerminal(this.player, _selectedFluid, this.terminal).sendPacketToServer();
    }

    public void receiveSelectedFluid(Fluid _selectedFluid) {
        this.selectedFluid = _selectedFluid;
        if (this.guiFluidTerminal != null) {
            this.guiFluidTerminal.updateSelectedFluid();
        }
    }

    public IItemList<IAEFluidStack> getFluidStackList() {
        return this.fluidStackList;
    }

    public EntityPlayer getPlayer() {
        return this.player;
    }

    public ItemStack func_82846_b(EntityPlayer player, int slotnumber) {
        ItemStack itemstack = null;
        Slot slot = (Slot)this.field_75151_b.get(slotnumber);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if (this.terminal.getInventory().func_94041_b(0, itemstack1)) {
                if (slotnumber == 1 || slotnumber == 0 ? !this.func_75135_a(itemstack1, 2, 36, false) : !this.func_75135_a(itemstack1, 0, 1, false)) {
                    return null;
                }
                if (itemstack1.field_77994_a == 0) {
                    slot.func_75215_d(null);
                } else {
                    slot.func_75218_e();
                }
            } else {
                return null;
            }
        }
        return itemstack;
    }

    public ItemStack func_75144_a(int slotNumber, int p_75144_2_, int p_75144_3_, EntityPlayer player) {
        ItemStack stack;
        Object returnStack = null;
        boolean hasPermission = true;
        if (!(slotNumber != 0 && slotNumber != 1 || (stack = player.field_71071_by.func_70445_o()) == null || FluidContainerRegistry.isFilledContainer((ItemStack)stack) && PermissionUtil.hasPermission(player, SecurityPermissions.INJECT, this.getTerminal()) || FluidContainerRegistry.isEmptyContainer((ItemStack)stack) && PermissionUtil.hasPermission(player, SecurityPermissions.EXTRACT, this.getTerminal()))) {
            ItemStack slotStack = ((Slot)this.field_75151_b.get(slotNumber)).func_75211_c();
            returnStack = slotStack == null ? null : slotStack.func_77946_l();
            hasPermission = false;
        }
        if (hasPermission) {
            returnStack = super.func_75144_a(slotNumber, p_75144_2_, p_75144_3_, player);
        }
        if (player instanceof EntityPlayerMP) {
            EntityPlayerMP p = (EntityPlayerMP)player;
            p.func_71120_a((Container)this);
        }
        return returnStack;
    }
}

