/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.tile.tank;

import cofh.core.util.fluid.FluidTankAdv;
import com.google.common.base.Throwables;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidTank;
import powercrystals.minefactoryreloaded.tile.tank.TankNetwork;
import powercrystals.minefactoryreloaded.tile.tank.TileEntityTank;

public class FluidTankMulti
implements IFluidTank {
    FluidTankAdv[] tanks = new FluidTankAdv[2];
    int length;
    int index;
    private FluidStack fluid = null;
    private TankNetwork grid;

    public FluidTankMulti(TankNetwork tankNetwork) {
        this.grid = tankNetwork;
    }

    public void addTank(FluidTankAdv fluidTankAdv) {
        int n = this.length;
        while (n-- > 0) {
            if (this.tanks[n] != fluidTankAdv) continue;
            return;
        }
        if (++this.length >= this.tanks.length) {
            FluidTankAdv[] fluidTankAdvArray = this.tanks;
            this.tanks = new FluidTankAdv[this.length * 2];
            System.arraycopy(fluidTankAdvArray, 0, this.tanks, 0, this.length - 1);
        }
        this.tanks[this.length - 1] = fluidTankAdv;
        this.fill(fluidTankAdv.drain(fluidTankAdv.getCapacity(), true), true);
    }

    public void removeTank(FluidTankAdv fluidTankAdv) {
        int n = this.length;
        while (n-- > 0 && this.tanks[n] != fluidTankAdv) {
        }
        if (n < 0) {
            return;
        }
        FluidStack fluidStack = this.tanks;
        if (--this.length != n) {
            System.arraycopy(fluidStack, n + 1, fluidStack, n, this.length - n + 1);
        }
        if (this.length <= ((FluidTankAdv[])fluidStack).length / 4) {
            this.tanks = new FluidTankAdv[((FluidTankAdv[])fluidStack).length / 2];
            if (n > 0) {
                System.arraycopy(fluidStack, 0, this.tanks, 0, n);
            }
        }
        if (this.index >= n) {
            --this.index;
        }
        if ((fluidStack = fluidTankAdv.getFluid()) != null) {
            this.fluid.amount -= fluidStack.amount;
            if (this.fluid.amount <= 0) {
                this.fluid = null;
                this.grid.updateNodes();
            }
        }
        this.tanks[this.length] = null;
        fluidTankAdv.setFluid(fluidStack);
    }

    public void empty() {
        int n = this.length;
        while (n-- > 0) {
            this.tanks[n] = null;
        }
        this.length = 0;
        this.index = 0;
        this.fluid = null;
    }

    public FluidStack getFluid() {
        return this.fluid;
    }

    public int getFluidAmount() {
        return this.fluid == null ? 0 : this.fluid.amount;
    }

    public int getCapacity() {
        return this.length * TileEntityTank.CAPACITY;
    }

    public FluidTankInfo getInfo() {
        return new FluidTankInfo((IFluidTank)this);
    }

    public int fill(FluidStack fluidStack, boolean bl) {
        int n = 0;
        if (fluidStack != null && (this.fluid == null || this.fluid.isFluidEqual(fluidStack))) {
            int n2;
            for (n2 = this.index; n2 < this.length && (n += this.tanks[n2].fill(fluidStack, bl)) < fluidStack.amount; ++n2) {
            }
            if (n2 == this.length) {
                --n2;
            }
            if (bl) {
                this.index = n2;
                boolean bl2 = false;
                if (this.fluid == null) {
                    bl2 = true;
                    this.fluid = new FluidStack(fluidStack, 0);
                }
                this.fluid.amount += n;
                if (bl2) {
                    this.grid.updateNodes();
                }
            }
        }
        return n;
    }

    public FluidStack drain(int n, boolean bl) {
        try {
            if (this.fluid != null) {
                FluidStack fluidStack = new FluidStack(this.fluid, 0);
                int n2 = this.index;
                while (n2 >= 0) {
                    int n3 = this.tanks[n2].getFluidAmount();
                    FluidStack fluidStack2 = this.tanks[n2].drain(n, bl);
                    if (fluidStack2 != null) {
                        fluidStack.amount += fluidStack2.amount;
                        n -= fluidStack2.amount;
                        if (n3 == fluidStack2.amount) {
                            --n2;
                        }
                    }
                    if (fluidStack2 != null && n > 0) continue;
                    break;
                }
                if (n2 == -1) {
                    ++n2;
                }
                if (bl) {
                    this.index = n2;
                    this.fluid.amount -= fluidStack.amount;
                    if (this.fluid.amount <= 0) {
                        this.fluid = null;
                        this.grid.updateNodes();
                    }
                }
                return fluidStack;
            }
        }
        catch (Throwable throwable) {
            System.out.format("index: %s, length: %s, tanks.length: %s, ", this.index, this.length, this.tanks.length);
            throw Throwables.propagate((Throwable)throwable);
        }
        return null;
    }

    public FluidStack drain(FluidStack fluidStack, boolean bl) {
        if (this.fluid != null && this.fluid.isFluidEqual(fluidStack)) {
            return this.drain(fluidStack.amount, bl);
        }
        return null;
    }
}

