/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.tile.machine;

import cofh.core.util.fluid.FluidTankAdv;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import powercrystals.minefactoryreloaded.MFRRegistry;
import powercrystals.minefactoryreloaded.core.ITankContainerBucketable;
import powercrystals.minefactoryreloaded.core.OreDictionaryArbiter;
import powercrystals.minefactoryreloaded.core.UtilInventory;
import powercrystals.minefactoryreloaded.gui.client.GuiFactoryInventory;
import powercrystals.minefactoryreloaded.gui.client.GuiUnifier;
import powercrystals.minefactoryreloaded.gui.container.ContainerUnifier;
import powercrystals.minefactoryreloaded.setup.Machine;
import powercrystals.minefactoryreloaded.tile.base.TileEntityFactoryInventory;

public class TileEntityUnifier
extends TileEntityFactoryInventory
implements ITankContainerBucketable {
    private boolean ignoreChange = false;
    private static FluidStack _biofuel;
    private static FluidStack _ethanol;
    private int _roundingCompensation = 1;
    private Map<String, ItemStack> _preferredOutputs = new HashMap<String, ItemStack>();

    public TileEntityUnifier() {
        super(Machine.Unifier);
        this.setManageSolids(true);
    }

    public static void updateUnifierLiquids() {
        _biofuel = FluidRegistry.getFluidStack((String)"biofuel", (int)1);
        _ethanol = FluidRegistry.getFluidStack((String)"bioethanol", (int)1);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiFactoryInventory getGui(InventoryPlayer inventoryPlayer) {
        return new GuiUnifier(this.getContainer(inventoryPlayer), this);
    }

    @Override
    public ContainerUnifier getContainer(InventoryPlayer inventoryPlayer) {
        return new ContainerUnifier(this, inventoryPlayer);
    }

    public boolean canUpdate() {
        return false;
    }

    private void unifyInventory() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            ItemStack itemStack = null;
            if (this._inventory[0] != null) {
                ArrayList<String> arrayList = OreDictionaryArbiter.getAllOreNames(this._inventory[0]);
                if (arrayList == null || arrayList.size() != 1 || MFRRegistry.getUnifierBlacklist().containsKey(arrayList.get(0))) {
                    itemStack = this._inventory[0].func_77946_l();
                } else if (this._preferredOutputs.containsKey(arrayList.get(0))) {
                    itemStack = this._preferredOutputs.get(arrayList.get(0)).func_77946_l();
                    itemStack.field_77994_a = this._inventory[0].field_77994_a;
                } else {
                    itemStack = OreDictionaryArbiter.getOres((String)arrayList.get(0)).get(0).func_77946_l();
                    itemStack.field_77994_a = this._inventory[0].field_77994_a;
                }
                if (itemStack != null && this._inventory[0].func_77973_b().equals(itemStack.func_77973_b())) {
                    itemStack = this._inventory[0].func_77946_l();
                }
                this.moveItemStack(itemStack);
            }
        }
    }

    private void moveItemStack(ItemStack itemStack) {
        if (itemStack == null) {
            return;
        }
        int n = itemStack.field_77994_a;
        if (this._inventory[1] == null) {
            n = Math.min(Math.min(this.func_70297_j_(), itemStack.func_77976_d()), itemStack.field_77994_a);
        } else {
            if (!UtilInventory.stacksEqual(itemStack, this._inventory[1], false)) {
                return;
            }
            if (itemStack.func_77978_p() != null | this._inventory[1].func_77978_p() != null) {
                return;
            }
            n = Math.min(itemStack.field_77994_a, this._inventory[1].func_77976_d() - this._inventory[1].field_77994_a);
        }
        if (this._inventory[1] == null) {
            this._inventory[1] = itemStack.func_77946_l();
            this._inventory[1].field_77994_a = n;
            this._inventory[0].field_77994_a -= n;
        } else {
            this._inventory[1].field_77994_a += n;
            this._inventory[0].field_77994_a -= n;
        }
        if (this._inventory[0].field_77994_a == 0) {
            this._inventory[0] = null;
        }
    }

    @Override
    public void func_70299_a(int n, ItemStack itemStack) {
        this._inventory[n] = itemStack;
        if (n > 1) {
            this.updatePreferredOutput();
        }
        if (itemStack != null && itemStack.field_77994_a <= 0) {
            this._inventory[n] = null;
        }
        this.unifyInventory();
        this.ignoreChange = true;
        this.func_70296_d();
        this.ignoreChange = false;
    }

    protected void updatePreferredOutput() {
        this._preferredOutputs.clear();
        for (int i = 2; i < 11; ++i) {
            ArrayList<String> arrayList;
            if (this._inventory[i] == null || (arrayList = OreDictionaryArbiter.getAllOreNames(this._inventory[i])) == null) continue;
            for (String string : arrayList) {
                this._preferredOutputs.put(string, this._inventory[i].func_77946_l());
            }
        }
    }

    @Override
    protected void onFactoryInventoryChanged() {
        if (!this.ignoreChange) {
            this.updatePreferredOutput();
            this.unifyInventory();
        }
    }

    public int func_70302_i_() {
        return 11;
    }

    @Override
    public boolean shouldDropSlotWhenBroken(int n) {
        return n < 2;
    }

    @Override
    public int func_70297_j_() {
        return 64;
    }

    @Override
    public int getSizeInventorySide(ForgeDirection forgeDirection) {
        return 2;
    }

    @Override
    public boolean func_102007_a(int n, ItemStack itemStack, int n2) {
        return n == 0;
    }

    @Override
    public boolean func_102008_b(int n, ItemStack itemStack, int n2) {
        return n == 1;
    }

    @Override
    public boolean allowBucketFill(ItemStack itemStack) {
        return true;
    }

    @Override
    public boolean allowBucketDrain(ItemStack itemStack) {
        return true;
    }

    public int fill(ForgeDirection forgeDirection, FluidStack fluidStack, boolean bl) {
        if (fluidStack == null || fluidStack.amount == 0) {
            return 0;
        }
        FluidStack fluidStack2 = this.unifierTransformLiquid(fluidStack, bl);
        if (fluidStack2 == null || fluidStack2.amount == 0) {
            return 0;
        }
        int n = this._tanks[0].fill(fluidStack2, bl);
        if (n == fluidStack2.amount) {
            return fluidStack.amount;
        }
        return n * fluidStack.amount / fluidStack2.amount + (fluidStack.amount & this._roundingCompensation);
    }

    private FluidStack unifierTransformLiquid(FluidStack fluidStack, boolean bl) {
        if (_ethanol != null & _biofuel != null) {
            if (_ethanol.isFluidEqual(fluidStack)) {
                return new FluidStack(TileEntityUnifier._biofuel.fluidID, fluidStack.amount);
            }
            if (_biofuel.isFluidEqual(fluidStack)) {
                return new FluidStack(TileEntityUnifier._ethanol.fluidID, fluidStack.amount);
            }
        }
        return null;
    }

    public FluidStack drain(ForgeDirection forgeDirection, int n, boolean bl) {
        return this.drain(n, bl);
    }

    public FluidStack drain(ForgeDirection forgeDirection, FluidStack fluidStack, boolean bl) {
        return this.drain(fluidStack, bl);
    }

    @Override
    protected FluidTankAdv[] createTanks() {
        return new FluidTankAdv[]{new FluidTankAdv(4000)};
    }

    public boolean canFill(ForgeDirection forgeDirection, Fluid fluid) {
        return true;
    }

    public boolean canDrain(ForgeDirection forgeDirection, Fluid fluid) {
        return true;
    }
}

