/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.tile.base;

import cofh.api.energy.IEnergyHandler;
import cofh.api.energy.IEnergyProvider;
import cofh.api.energy.IEnergyReceiver;
import cofh.core.util.CoreUtils;
import cofh.lib.util.helpers.EnergyHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import powercrystals.minefactoryreloaded.setup.Machine;
import powercrystals.minefactoryreloaded.tile.base.TileEntityFactoryInventory;

public abstract class TileEntityFactoryGenerator
extends TileEntityFactoryInventory
implements IEnergyProvider {
    private boolean deadCache;
    private IEnergyReceiver[] receiverCache;
    private int _ticksBetweenConsumption;
    private int _outputPulseSize;
    private int _ticksSinceLastConsumption = 0;
    private int _energyMax;
    private int _energy;

    protected TileEntityFactoryGenerator(Machine machine, int n) {
        super(machine);
        if (machine.getActivationEnergy() <= 0) {
            throw new IllegalStateException("Generators cannot produce 0 energy.");
        }
        this._ticksBetweenConsumption = n;
        this._outputPulseSize = machine.getActivationEnergy();
        this._energyMax = machine.getMaxEnergyStorage();
    }

    @Override
    public void func_145829_t() {
        super.func_145829_t();
        this.deadCache = true;
        this.receiverCache = null;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            boolean bl;
            if (this.deadCache) {
                this.reCache();
            }
            boolean bl2 = bl = ++this._ticksSinceLastConsumption < this._ticksBetweenConsumption;
            if (CoreUtils.isRedstonePowered((TileEntity)this)) {
                this.setIsActive(false);
                return;
            }
            this.setIsActive(this.hasFuel());
            int n = Math.min(this._energy, this._outputPulseSize);
            this._energy -= n - this.transmitEnergy(n);
            if (bl || !this.canConsumeFuel(this._energyMax - this._energy)) {
                return;
            }
            if (this.consumeFuel()) {
                this._energy += this.produceEnergy();
                this._ticksSinceLastConsumption = 0;
            }
        }
    }

    protected abstract boolean canConsumeFuel(int var1);

    protected abstract boolean consumeFuel();

    protected abstract boolean hasFuel();

    protected abstract int produceEnergy();

    protected final int transmitEnergy(int n) {
        if (this._inventory[0] != null) {
            n -= EnergyHelper.insertEnergyIntoContainer((ItemStack)this._inventory[0], (int)n, (boolean)false);
        }
        if (n <= 0) {
            return 0;
        }
        if (this.receiverCache != null) {
            int n2 = this.receiverCache.length;
            while (n2-- > 0) {
                IEnergyReceiver iEnergyReceiver = this.receiverCache[n2];
                if (iEnergyReceiver == null) continue;
                ForgeDirection forgeDirection = ForgeDirection.VALID_DIRECTIONS[n2];
                if (iEnergyReceiver.receiveEnergy(forgeDirection, n, true) > 0) {
                    n -= iEnergyReceiver.receiveEnergy(forgeDirection, n, false);
                }
                if (n > 0) continue;
                return 0;
            }
        }
        return n;
    }

    public int getBuffer() {
        return this._energy;
    }

    public void setBuffer(int n) {
        this._energy = n;
    }

    public int getBufferMax() {
        return this._energyMax;
    }

    public int func_70302_i_() {
        return 1;
    }

    @Override
    public boolean func_102007_a(int n, ItemStack itemStack, int n2) {
        return EnergyHelper.isEnergyContainerItem((ItemStack)itemStack);
    }

    @Override
    public boolean func_102008_b(int n, ItemStack itemStack, int n2) {
        return this._inventory[0] != null && EnergyHelper.insertEnergyIntoContainer((ItemStack)this._inventory[0], (int)2, (boolean)true) < 2;
    }

    private void reCache() {
        if (this.deadCache) {
            for (ForgeDirection forgeDirection : ForgeDirection.VALID_DIRECTIONS) {
                this.onNeighborTileChange(this.field_145851_c + forgeDirection.offsetX, this.field_145848_d + forgeDirection.offsetY, this.field_145849_e + forgeDirection.offsetZ);
            }
            this.deadCache = false;
        }
    }

    @Override
    public void onNeighborTileChange(int n, int n2, int n3) {
        TileEntity tileEntity = this.field_145850_b.func_147438_o(n, n2, n3);
        if (n < this.field_145851_c) {
            this.addCache(tileEntity, 5);
        } else if (n > this.field_145851_c) {
            this.addCache(tileEntity, 4);
        } else if (n3 < this.field_145849_e) {
            this.addCache(tileEntity, 3);
        } else if (n3 > this.field_145849_e) {
            this.addCache(tileEntity, 2);
        } else if (n2 < this.field_145848_d) {
            this.addCache(tileEntity, 1);
        } else if (n2 > this.field_145848_d) {
            this.addCache(tileEntity, 0);
        }
    }

    private void addCache(TileEntity tileEntity, int n) {
        if (this.receiverCache != null) {
            this.receiverCache[n] = null;
        }
        if (tileEntity instanceof IEnergyHandler && ((IEnergyHandler)tileEntity).canConnectEnergy(ForgeDirection.VALID_DIRECTIONS[n])) {
            if (this.receiverCache == null) {
                this.receiverCache = new IEnergyHandler[6];
            }
            this.receiverCache[n] = (IEnergyHandler)tileEntity;
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nBTTagCompound) {
        super.func_145841_b(nBTTagCompound);
        if (this._ticksSinceLastConsumption > 0) {
            nBTTagCompound.func_74768_a("ticksSinceLastConsumption", this._ticksSinceLastConsumption);
        }
    }

    @Override
    public void writeItemNBT(NBTTagCompound nBTTagCompound) {
        super.writeItemNBT(nBTTagCompound);
        if (this._energy > 0) {
            nBTTagCompound.func_74768_a("energyStored", this._energy);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nBTTagCompound) {
        super.func_145839_a(nBTTagCompound);
        this._ticksSinceLastConsumption = nBTTagCompound.func_74762_e("ticksSinceLastConsumption");
        this._energy = nBTTagCompound.func_74762_e(nBTTagCompound.func_74764_b("energyStored") ? "energyStored" : "buffer");
    }

    public boolean canConnectEnergy(ForgeDirection forgeDirection) {
        return true;
    }

    public int extractEnergy(ForgeDirection forgeDirection, int n, boolean bl) {
        if ((n = Math.min(this._energy, Math.min(this._outputPulseSize, n))) <= 0) {
            return 0;
        }
        if (!bl) {
            this._energy -= n;
        }
        return n;
    }

    public int getEnergyStored(ForgeDirection forgeDirection) {
        return this._energy;
    }

    public int getMaxEnergyStored(ForgeDirection forgeDirection) {
        return this._energyMax;
    }
}

