/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.setup.recipe;

import cofh.lib.util.helpers.ItemHelper;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.MissingModsException;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.versioning.DefaultArtifactVersion;
import java.util.Collections;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import powercrystals.minefactoryreloaded.MineFactoryReloadedCore;
import powercrystals.minefactoryreloaded.setup.MFRConfig;
import powercrystals.minefactoryreloaded.setup.MFRThings;
import powercrystals.minefactoryreloaded.setup.Machine;
import powercrystals.minefactoryreloaded.setup.recipe.Vanilla;

public class EnderIO
extends Vanilla {
    private static final String EIO = "EnderIO";
    String redstone = "dustRedstone";
    ItemStack capacitorBasic;
    ItemStack capacitorDouble;
    ItemStack capacitorOctadic;
    ItemStack gear;
    ItemStack chassis;
    ItemStack zombieElectrode;
    ItemStack zombieController;
    ItemStack frankNZombie;
    ItemStack enderTransmitter;
    ItemStack dsAxe;
    ItemStack dsPick;
    ItemStack dsSword;
    ItemStack probe;
    ItemStack conduitLiquid;
    ItemStack xpRod;
    ItemStack soulVial;
    ItemStack fireWaterBucket;
    ItemStack light;
    ItemStack reservoir;
    ItemStack dimTrans;
    ItemStack vacuumChest;
    ItemStack tank;
    ItemStack tankPressurized;
    ItemStack xpObelisk;
    ItemStack darkSteelAnvil;
    ItemStack capBank;
    ItemStack reinforcedObsidian;
    ItemStack crafter;
    ItemStack combustionGen;

    @Override
    protected void gatherItems() {
        if (!Loader.isModLoaded((String)EIO)) {
            MineFactoryReloadedCore.log().fatal("EnderIO is required for EnderIO recipes to be enabled.");
            throw new MissingModsException(Collections.singleton(new DefaultArtifactVersion(EIO)));
        }
        this.capacitorBasic = this.stackFor("itemBasicCapacitor");
        this.capacitorDouble = this.stackFor("itemBasicCapacitor", 1);
        this.capacitorOctadic = this.stackFor("itemBasicCapacitor", 2);
        this.chassis = this.stackFor("itemMachinePart");
        this.gear = this.stackFor("itemMachinePart", 1);
        this.zombieElectrode = this.stackFor("itemFrankenSkull");
        this.zombieController = this.stackFor("itemFrankenSkull", 1);
        this.frankNZombie = this.stackFor("itemFrankenSkull", 2);
        this.enderTransmitter = this.stackFor("itemFrankenSkull", 3);
        this.dsAxe = this.stackFor("item.darkSteel_axe");
        this.dsSword = this.stackFor("item.darkSteel_sword");
        this.dsPick = this.stackFor("item.darkSteel_pickaxe");
        this.probe = this.stackFor("itemConduitProbe");
        this.conduitLiquid = this.stackFor("itemLiquidConduit");
        this.xpRod = this.stackFor("itemXpTransfer");
        this.soulVial = this.stackFor("itemSoulVessel");
        this.fireWaterBucket = this.stackFor("bucketFire_water");
        this.light = this.stackForBlock("blockElectricLight", 2);
        this.reservoir = this.stackForBlock("blockReservoir");
        this.dimTrans = this.stackForBlock("blockTransceiver");
        this.vacuumChest = this.stackForBlock("blockVacuumChest");
        this.tank = this.stackForBlock("blockTank");
        this.tankPressurized = this.stackForBlock("blockTank", 1);
        this.xpObelisk = this.stackForBlock("blockExperienceObelisk");
        this.darkSteelAnvil = this.stackForBlock("blockDarkSteelAnvil");
        this.capBank = this.stackForBlock("blockCapacitorBank");
        this.reinforcedObsidian = this.stackForBlock("blockReinforcedObsidian");
        this.crafter = this.stackForBlock("blockCrafter");
        this.combustionGen = this.stackForBlock("blockCombustionGenerator");
    }

    private ItemStack stackFor(String string) {
        return this.stackFor(string, 0);
    }

    private ItemStack stackFor(String string, int n) {
        return new ItemStack(GameRegistry.findItem((String)EIO, (String)string), 1, n);
    }

    private ItemStack stackForBlock(String string) {
        return this.stackForBlock(string, 0);
    }

    private ItemStack stackForBlock(String string, int n) {
        return new ItemStack(GameRegistry.findBlock((String)EIO, (String)string), 1, n);
    }

    @Override
    protected void registerMachines() {
        String string = "ingot";
        this.registerMachine(Machine.Planter, "PTP", "SFS", "OCO", Character.valueOf('P'), "sheetPlastic", Character.valueOf('T'), Items.field_151162_bE, Character.valueOf('S'), Blocks.field_150331_J, Character.valueOf('F'), this.chassis, Character.valueOf('O'), string + "ElectricalSteel", Character.valueOf('C'), this.zombieController);
        this.registerMachine(Machine.Fisher, "PTP", "SFS", "OCO", Character.valueOf('P'), "sheetPlastic", Character.valueOf('T'), Items.field_151112_aM, Character.valueOf('S'), Items.field_151133_ar, Character.valueOf('F'), this.chassis, Character.valueOf('O'), string + "Iron", Character.valueOf('C'), this.zombieController);
        this.registerMachine(Machine.Harvester, "PTP", "SFS", "OCO", Character.valueOf('P'), "sheetPlastic", Character.valueOf('T'), this.dsAxe, Character.valueOf('S'), Items.field_151097_aZ, Character.valueOf('F'), this.chassis, Character.valueOf('O'), string + "Gold", Character.valueOf('C'), this.zombieController);
        this.registerMachine(Machine.Rancher, "PTP", "SFS", "OCO", Character.valueOf('P'), "sheetPlastic", Character.valueOf('T'), this.conduitLiquid, Character.valueOf('S'), Items.field_151097_aZ, Character.valueOf('F'), this.chassis, Character.valueOf('O'), string + "ElectricalSteel", Character.valueOf('C'), this.zombieController);
        this.registerMachine(Machine.Fertilizer, "PTP", "SFS", "OCO", Character.valueOf('P'), "sheetPlastic", Character.valueOf('T'), Items.field_151069_bo, Character.valueOf('S'), Items.field_151116_aA, Character.valueOf('F'), this.chassis, Character.valueOf('O'), string + "ElectricalSteel", Character.valueOf('C'), this.zombieController);
        this.registerMachine(Machine.Vet, "PTP", "TFT", "OCO", Character.valueOf('P'), "sheetPlastic", Character.valueOf('T'), MFRThings.syringeEmptyItem, Character.valueOf('F'), this.chassis, Character.valueOf('O'), string + "Copper", Character.valueOf('C'), this.zombieElectrode);
        this.registerMachine(Machine.ItemCollector, 8, new Object[]{"P P", " F ", "PCP", Character.valueOf('P'), "sheetPlastic", Character.valueOf('F'), this.chassis, Character.valueOf('C'), Blocks.field_150486_ae});
        this.registerMachine(Machine.BlockBreaker, "PTP", "SFA", "OCO", Character.valueOf('P'), "sheetPlastic", Character.valueOf('T'), string + "ElectricalSteel", Character.valueOf('S'), this.dsPick, Character.valueOf('F'), this.chassis, Character.valueOf('A'), Items.field_151037_a, Character.valueOf('O'), string + "Iron", Character.valueOf('C'), this.redstone);
        this.registerMachine(Machine.WeatherCollector, "PBP", "TFT", "OCO", Character.valueOf('P'), "sheetPlastic", Character.valueOf('B'), Blocks.field_150411_aY, Character.valueOf('T'), Items.field_151133_ar, Character.valueOf('F'), this.chassis, Character.valueOf('O'), string + "ElectricalSteel", Character.valueOf('C'), this.redstone);
        this.registerMachine(Machine.SludgeBoiler, "PTP", "SFS", "OCO", Character.valueOf('P'), "sheetPlastic", Character.valueOf('T'), Items.field_151133_ar, Character.valueOf('S'), Blocks.field_150460_al, Character.valueOf('F'), this.chassis, Character.valueOf('O'), string + "Iron", Character.valueOf('C'), this.redstone);
        this.registerMachine(Machine.Sewer, 4, new Object[]{"PTP", "SFS", "SQS", Character.valueOf('P'), "sheetPlastic", Character.valueOf('T'), Items.field_151133_ar, Character.valueOf('S'), Items.field_151118_aC, Character.valueOf('F'), this.chassis, Character.valueOf('Q'), this.reservoir});
        this.registerMachine(Machine.Composter, "PTP", "SFS", "OCO", Character.valueOf('P'), "sheetPlastic", Character.valueOf('T'), Blocks.field_150460_al, Character.valueOf('S'), Blocks.field_150331_J, Character.valueOf('F'), this.chassis, Character.valueOf('O'), Items.field_151118_aC, Character.valueOf('C'), this.redstone);
        this.registerMachine(Machine.Breeder, "PTP", "SFS", "OCO", Character.valueOf('P'), "sheetPlastic", Character.valueOf('T'), Items.field_151153_ao, Character.valueOf('S'), Items.field_151150_bK, Character.valueOf('F'), this.chassis, Character.valueOf('O'), "dyePurple", Character.valueOf('C'), this.zombieElectrode);
        this.registerMachine(Machine.Grinder, "PTP", "OFO", "SCS", Character.valueOf('P'), "sheetPlastic", Character.valueOf('T'), this.dsSword, Character.valueOf('O'), Items.field_151122_aG, Character.valueOf('F'), this.chassis, Character.valueOf('S'), string + "ElectricalSteel", Character.valueOf('C'), this.conduitLiquid);
        this.registerMachine(Machine.AutoEnchanter, "PTP", "SFS", "OCO", Character.valueOf('P'), "sheetPlastic", Character.valueOf('T'), Blocks.field_150343_Z, Character.valueOf('S'), Items.field_151122_aG, Character.valueOf('F'), this.chassis, Character.valueOf('O'), "gemDiamond", Character.valueOf('C'), this.xpRod);
        this.registerMachine(Machine.Chronotyper, "PTP", "TFT", "OCO", Character.valueOf('P'), "sheetPlastic", Character.valueOf('T'), "gemEmerald", Character.valueOf('F'), this.chassis, Character.valueOf('O'), "dyePurple", Character.valueOf('C'), this.soulVial);
        this.registerMachine(Machine.Ejector, 8, new Object[]{"PPP", " T ", "OFO", Character.valueOf('P'), "sheetPlastic", Character.valueOf('T'), Blocks.field_150438_bZ, Character.valueOf('F'), this.chassis, Character.valueOf('O'), this.redstone});
        this.registerMachine(Machine.ItemRouter, 8, new Object[]{"PTP", "SFS", "PHP", Character.valueOf('P'), "sheetPlastic", Character.valueOf('T'), Blocks.field_150486_ae, Character.valueOf('S'), this.probe, Character.valueOf('F'), this.chassis, Character.valueOf('H'), Blocks.field_150438_bZ});
        this.registerMachine(Machine.LiquidRouter, 8, new Object[]{"PTP", "SFS", "PHP", Character.valueOf('P'), "sheetPlastic", Character.valueOf('T'), this.conduitLiquid, Character.valueOf('S'), this.probe, Character.valueOf('F'), this.chassis, Character.valueOf('H'), Blocks.field_150438_bZ});
        int n = MFRConfig.craftSingleDSU.getBoolean(false) ? 1 : 4;
        this.registerMachine(Machine.DeepStorageUnit, n, new Object[]{"PCP", "CFC", "PCP", Character.valueOf('P'), "sheetPlastic", Character.valueOf('C'), this.reinforcedObsidian, Character.valueOf('F'), this.dimTrans});
        if (MFRConfig.enableCheapDSU.getBoolean(false)) {
            this.registerMachine(Machine.DeepStorageUnit, "PCP", "CFC", "PCP", Character.valueOf('P'), "sheetPlastic", Character.valueOf('C'), this.vacuumChest, Character.valueOf('F'), this.chassis);
        }
        this.registerMachine(Machine.LiquiCrafter, "PTP", "SFS", "OCO", Character.valueOf('P'), "sheetPlastic", Character.valueOf('T'), Blocks.field_150462_ai, Character.valueOf('S'), this.tank, Character.valueOf('F'), this.chassis, Character.valueOf('O'), Items.field_151122_aG, Character.valueOf('C'), this.crafter);
        this.registerMachine(Machine.LavaFabricator, "PTP", "SFS", "OCO", Character.valueOf('P'), "sheetPlastic", Character.valueOf('T'), Blocks.field_150343_Z, Character.valueOf('S'), Items.field_151064_bs, Character.valueOf('F'), this.chassis, Character.valueOf('O'), Items.field_151072_bj, Character.valueOf('C'), this.redstone);
        this.registerMachine(Machine.SteamBoiler, "PPP", "TBT", "OOO", Character.valueOf('P'), "sheetPlastic", Character.valueOf('T'), this.tankPressurized, Character.valueOf('B'), Machine.SludgeBoiler.getItemStack(), Character.valueOf('O'), Blocks.field_150385_bj);
        this.registerMachine(Machine.AutoJukebox, "PJP", "PFP", Character.valueOf('P'), "sheetPlastic", Character.valueOf('J'), Blocks.field_150421_aI, Character.valueOf('F'), this.chassis);
        this.registerMachine(Machine.Unifier, "PTP", "OFO", "SCS", Character.valueOf('P'), "sheetPlastic", Character.valueOf('T'), this.probe, Character.valueOf('O'), Items.field_151132_bS, Character.valueOf('F'), this.chassis, Character.valueOf('S'), string + "ElectricalSteel", Character.valueOf('C'), Items.field_151122_aG);
        this.registerMachine(Machine.AutoSpawner, "PTP", "SFS", "OCO", Character.valueOf('P'), "sheetPlastic", Character.valueOf('T'), Items.field_151075_bm, Character.valueOf('S'), Items.field_151064_bs, Character.valueOf('F'), this.chassis, Character.valueOf('O'), "gemEmerald", Character.valueOf('C'), this.zombieController);
        this.registerMachine(Machine.BioReactor, "PTP", "SFS", "OCO", Character.valueOf('P'), "sheetPlastic", Character.valueOf('T'), Items.field_151071_bq, Character.valueOf('S'), "slimeball", Character.valueOf('F'), this.chassis, Character.valueOf('O'), Items.field_151118_aC, Character.valueOf('C'), Items.field_151102_aT);
        this.registerMachine(Machine.BioFuelGenerator, "PTP", "SFS", "OCO", Character.valueOf('P'), "sheetPlastic", Character.valueOf('T'), Blocks.field_150460_al, Character.valueOf('S'), Blocks.field_150331_J, Character.valueOf('F'), this.chassis, Character.valueOf('O'), Items.field_151072_bj, Character.valueOf('C'), Blocks.field_150331_J);
        this.registerMachine(Machine.AutoDisenchanter, "PTP", "SFS", "OCO", Character.valueOf('P'), "sheetPlastic", Character.valueOf('T'), Blocks.field_150385_bj, Character.valueOf('S'), Items.field_151122_aG, Character.valueOf('F'), this.chassis, Character.valueOf('O'), "gemDiamond", Character.valueOf('C'), this.xpObelisk);
        this.registerMachine(Machine.Slaughterhouse, "GIG", "SFS", "XCX", Character.valueOf('G'), "sheetPlastic", Character.valueOf('S'), this.dsSword, Character.valueOf('X'), this.dsAxe, Character.valueOf('I'), string + "ElectricalSteel", Character.valueOf('F'), this.chassis, Character.valueOf('C'), this.redstone);
        this.registerMachine(Machine.MeatPacker, "GSG", "BFB", "BCB", Character.valueOf('G'), "sheetPlastic", Character.valueOf('B'), Blocks.field_150336_V, Character.valueOf('S'), this.fireWaterBucket, Character.valueOf('F'), this.chassis, Character.valueOf('C'), this.redstone);
        this.registerMachine(Machine.EnchantmentRouter, "PBP", "SFS", "PSP", Character.valueOf('P'), "sheetPlastic", Character.valueOf('B'), Items.field_151122_aG, Character.valueOf('S'), Items.field_151107_aW, Character.valueOf('F'), this.chassis);
        this.registerMachine(Machine.LaserDrill, "GFG", "CFC", "DHD", Character.valueOf('G'), "sheetPlastic", Character.valueOf('D'), "gemDiamond", Character.valueOf('H'), "blockGlassHardened", Character.valueOf('F'), this.light, Character.valueOf('C'), this.capacitorOctadic);
        this.registerMachine(Machine.LaserDrillPrecharger, "GSG", "HFH", "CDC", Character.valueOf('G'), "sheetPlastic", Character.valueOf('D'), "gemDiamond", Character.valueOf('S'), new ItemStack(MFRThings.pinkSlimeItem, 1, 1), Character.valueOf('H'), "blockGlassHardened", Character.valueOf('F'), this.light, Character.valueOf('C'), this.capacitorDouble);
        this.registerMachine(Machine.AutoAnvil, "GGG", "AFA", "OCO", Character.valueOf('G'), "sheetPlastic", Character.valueOf('A'), Blocks.field_150467_bQ, Character.valueOf('F'), this.chassis, Character.valueOf('C'), this.darkSteelAnvil, Character.valueOf('O'), string + "Iron");
        this.registerMachine(Machine.BlockSmasher, "GPG", "HFH", "BCB", Character.valueOf('G'), "sheetPlastic", Character.valueOf('P'), Blocks.field_150331_J, Character.valueOf('H'), MFRThings.factoryHammerItem, Character.valueOf('B'), Items.field_151122_aG, Character.valueOf('F'), this.chassis, Character.valueOf('C'), this.redstone);
        this.registerMachine(Machine.RedNote, "GNG", "CFC", Character.valueOf('G'), "sheetPlastic", Character.valueOf('C'), "cableRedNet", Character.valueOf('N'), Blocks.field_150323_B, Character.valueOf('F'), this.chassis);
        this.registerMachine(Machine.AutoBrewer, "GBG", "CFC", "RPR", Character.valueOf('G'), "sheetPlastic", Character.valueOf('C'), this.conduitLiquid, Character.valueOf('B'), Items.field_151067_bt, Character.valueOf('R'), Items.field_151107_aW, Character.valueOf('F'), this.chassis, Character.valueOf('P'), this.redstone);
        this.registerMachine(Machine.FruitPicker, "GXG", "SFS", "OCO", Character.valueOf('G'), "sheetPlastic", Character.valueOf('X'), this.dsAxe, Character.valueOf('S'), Items.field_151097_aZ, Character.valueOf('F'), this.chassis, Character.valueOf('C'), this.zombieController, Character.valueOf('O'), string + "ElectricalSteel");
        this.registerMachine(Machine.BlockPlacer, "GDG", "DMD", "GSG", Character.valueOf('G'), "sheetPlastic", Character.valueOf('D'), Blocks.field_150367_z, Character.valueOf('S'), this.redstone, Character.valueOf('M'), this.chassis);
        this.registerMachine(Machine.MobCounter, "GGG", "RCR", "SMS", Character.valueOf('G'), "sheetPlastic", Character.valueOf('R'), Items.field_151107_aW, Character.valueOf('C'), Items.field_151132_bS, Character.valueOf('S'), this.probe, Character.valueOf('M'), this.chassis);
        this.registerMachine(Machine.SteamTurbine, "PTP", "SFS", "OCO", Character.valueOf('P'), "sheetPlastic", Character.valueOf('T'), this.combustionGen, Character.valueOf('S'), Blocks.field_150331_J, Character.valueOf('F'), this.chassis, Character.valueOf('O'), string + "ElectricalSteel", Character.valueOf('C'), this.gear);
        this.registerMachine(Machine.ChunkLoader, "PEP", "TET", "OCO", Character.valueOf('P'), "sheetPlastic", Character.valueOf('T'), this.dimTrans, Character.valueOf('E'), this.capBank, Character.valueOf('F'), this.capacitorOctadic, Character.valueOf('O'), string + "EnergeticAlloy", Character.valueOf('C'), this.capacitorOctadic);
        if (MFRConfig.enableCheapCL.getBoolean(false)) {
            this.registerMachine(Machine.ChunkLoader, "PEP", "FDF", "OCO", Character.valueOf('P'), "sheetPlastic", Character.valueOf('D'), this.dimTrans, Character.valueOf('E'), this.capBank, Character.valueOf('F'), this.chassis, Character.valueOf('O'), string + "EnergeticAlloy", Character.valueOf('C'), this.capacitorOctadic);
        }
        this.registerMachine(Machine.Fountain, "PBP", "TFT", "OCO", Character.valueOf('P'), "sheetPlastic", Character.valueOf('B'), Blocks.field_150411_aY, Character.valueOf('T'), this.tank, Character.valueOf('F'), this.chassis, Character.valueOf('O'), string + "ElectricalSteel", Character.valueOf('C'), this.redstone);
        this.registerMachine(Machine.MobRouter, "PPP", "BRB", "OCO", Character.valueOf('P'), "sheetPlastic", Character.valueOf('B'), Blocks.field_150411_aY, Character.valueOf('R'), Machine.ItemRouter.getItemStack(), Character.valueOf('O'), "dyeOrange", Character.valueOf('C'), Machine.Chronotyper.getItemStack());
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)ItemHelper.stack((Block)MFRThings.plasticTank, (int)1), (Object[])new Object[]{"PPP", "P P", "PMP", Character.valueOf('P'), "sheetPlastic", Character.valueOf('M'), MFRThings.machineBaseItem}));
    }

    @Override
    protected void registerMiscItems() {
        String string = "ingot";
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(MFRThings.fertilizerItem, 16), new Object[]{"WBW", "STS", "WBW", Character.valueOf('W'), Items.field_151015_O, Character.valueOf('B'), new ItemStack(Items.field_151100_aR, 1, 15), Character.valueOf('S'), Items.field_151007_F, Character.valueOf('T'), "stickWood"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(MFRThings.spyglassItem), new Object[]{"GLG", "PLP", " S ", Character.valueOf('G'), "ingotGold", Character.valueOf('L'), "blockGlass", Character.valueOf('P'), "sheetPlastic", Character.valueOf('S'), "stickWood"}));
        if (MFRConfig.enablePortaSpawner.getBoolean(true)) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(MFRThings.portaSpawnerItem), new Object[]{"GLG", "DND", "GLG", Character.valueOf('G'), string + "ElectricalSteel", Character.valueOf('L'), "blockGlass", Character.valueOf('D'), "ingotVibrantAlloy", Character.valueOf('N'), Items.field_151156_bN}));
        }
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(MFRThings.detCordBlock, 12), new Object[]{"PPP", "PTP", "PPP", Character.valueOf('P'), "itemRubber", Character.valueOf('T'), Blocks.field_150335_W}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(MFRThings.fishingRodItem, 1), new Object[]{"DD ", "DFD", "TDD", Character.valueOf('D'), "wireExplosive", Character.valueOf('F'), Items.field_151112_aM, Character.valueOf('T'), Blocks.field_150429_aA}));
    }

    @Override
    protected void registerRedNet() {
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)MFRThings.rednetCableBlock, 8), new Object[]{"PPP", "RRR", "PPP", Character.valueOf('R'), this.redstone, Character.valueOf('P'), "sheetPlastic"}));
        ItemStack itemStack = ItemHelper.stack((Block)MFRThings.plasticPipeBlock);
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapelessRecipe((ItemStack)ItemHelper.stack((Block)MFRThings.rednetCableBlock, (int)5), (Object[])new Object[]{itemStack, itemStack, itemStack, itemStack, itemStack, this.redstone, this.redstone}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack((Block)MFRThings.rednetCableBlock, 1, 2), new Object[]{"nuggetGold", "nuggetGold", "nuggetGold", this.redstone, this.redstone, new ItemStack((Block)MFRThings.rednetCableBlock)}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack((Block)MFRThings.rednetCableBlock, 6, 2), new Object[]{"ingotGold", "ingotGold", Blocks.field_150451_bX, new ItemStack((Block)MFRThings.rednetCableBlock), new ItemStack((Block)MFRThings.rednetCableBlock), new ItemStack((Block)MFRThings.rednetCableBlock), new ItemStack((Block)MFRThings.rednetCableBlock), new ItemStack((Block)MFRThings.rednetCableBlock), new ItemStack((Block)MFRThings.rednetCableBlock)}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(MFRThings.machineItem, 1, 1), new Object[]{"PRP", "RGR", "PIP", Character.valueOf('R'), this.redstone, Character.valueOf('P'), "sheetPlastic", Character.valueOf('G'), "blockGlass", Character.valueOf('I'), "ingotIron"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)MFRThings.rednetLogicBlock), new Object[]{"RDR", "LGL", "PHP", Character.valueOf('H'), new ItemStack(MFRThings.machineItem, 1, 1), Character.valueOf('P'), "sheetPlastic", Character.valueOf('G'), "ingotGold", Character.valueOf('L'), "gemLapis", Character.valueOf('D'), "gemDiamond", Character.valueOf('R'), this.redstone}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(MFRThings.logicCardItem, 1, 0), new Object[]{"RPR", "PGP", "RPR", Character.valueOf('P'), "sheetPlastic", Character.valueOf('G'), "ingotGold", Character.valueOf('R'), this.redstone}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(MFRThings.logicCardItem, 1, 1), new Object[]{"GPG", "PCP", "RGR", Character.valueOf('C'), new ItemStack(MFRThings.logicCardItem, 1, 0), Character.valueOf('P'), "sheetPlastic", Character.valueOf('G'), "ingotGold", Character.valueOf('R'), this.redstone}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(MFRThings.logicCardItem, 1, 2), new Object[]{"DPD", "RCR", "GDG", Character.valueOf('C'), new ItemStack(MFRThings.logicCardItem, 1, 1), Character.valueOf('P'), "sheetPlastic", Character.valueOf('G'), "ingotGold", Character.valueOf('D'), "gemDiamond", Character.valueOf('R'), this.redstone}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(MFRThings.rednetMeterItem, 1, 0), new Object[]{" G", "PR", "PP", Character.valueOf('P'), "sheetPlastic", Character.valueOf('G'), "nuggetGold", Character.valueOf('R'), this.redstone}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(MFRThings.rednetMeterItem, 1, 1), new Object[]{"RGR", "IMI", "PPP", Character.valueOf('P'), "sheetPlastic", Character.valueOf('G'), this.capacitorBasic, Character.valueOf('I'), "ingotCopper", Character.valueOf('R'), this.redstone, Character.valueOf('M'), new ItemStack(MFRThings.rednetMeterItem, 1, 0)}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(MFRThings.rednetMemoryCardItem, 1, 0), new Object[]{"GGG", "PRP", "PPP", Character.valueOf('P'), "sheetPlastic", Character.valueOf('G'), "nuggetGold", Character.valueOf('R'), this.redstone}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)MFRThings.rednetPanelBlock, 1, 0), new Object[]{"PCP", "PBP", "KPK", Character.valueOf('P'), "sheetPlastic", Character.valueOf('C'), MFRThings.rednetCableBlock, Character.valueOf('B'), Blocks.field_150342_X, Character.valueOf('K'), new ItemStack(Items.field_151100_aR, 1, 0)}));
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(MFRThings.rednetMemoryCardItem, 1, 0), (Object[])new Object[]{new ItemStack(MFRThings.rednetMemoryCardItem, 1, 0)});
    }
}

