/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.core;

import buildcraft.api.tools.IToolWrench;
import cofh.api.item.IToolHammer;
import cofh.lib.util.helpers.StringHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.input.Keyboard;
import powercrystals.minefactoryreloaded.api.IMFRHammer;
import powercrystals.minefactoryreloaded.setup.MFRThings;

public class MFRUtil {
    public static final int[] COLORS_DYE = new int[]{0x1E1E1E, 0xB62222, 4679965, 8405024, 0x404080, 0x803880, 5547675, 0xA3A3A3, 0x505050, 14188964, 4833610, 14203168, 9283574, 13054117, 14902784, 0xF0F0F0};
    public static final int[] COLORS = new int[16];
    public static final List<ForgeDirection> VALID_DIRECTIONS;
    private static boolean bcWrenchExists;

    @SideOnly(value=Side.CLIENT)
    public static boolean isAltKeyDown() {
        return Keyboard.isKeyDown((int)56) || Keyboard.isKeyDown((int)184);
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean isCtrlKeyDown() {
        if (Minecraft.field_142025_a) {
            return Keyboard.isKeyDown((int)219) || Keyboard.isKeyDown((int)220);
        }
        return Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)157);
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean isShiftKeyDown() {
        return Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
    }

    public static String shiftForInfo() {
        return StringHelper.shiftForDetails();
    }

    public static String empty() {
        return EnumChatFormatting.ITALIC + "<" + MFRUtil.localize("info.cofh.empty", true) + ">" + EnumChatFormatting.RESET;
    }

    public static String energy() {
        return MFRUtil.localize("info.cofh.energy", true);
    }

    public static String getFluidName(FluidStack fluidStack) {
        return StringHelper.getFluidName((FluidStack)fluidStack);
    }

    public static String localize(String string) {
        return MFRUtil.localize(string + ".name", false, string);
    }

    public static String localize(String string, String string2) {
        return MFRUtil.localize(string + string2 + ".name", true, string2);
    }

    public static String localize(String string, boolean bl) {
        return MFRUtil.localize(string, bl, string);
    }

    public static String localize(String string, boolean bl, String string2) {
        if (!StatCollector.func_94522_b((String)string)) {
            return bl ? string2 : (StatCollector.func_94522_b((String)string2) ? MFRUtil.localize(StatCollector.func_74838_a((String)string2), true) : string2);
        }
        return StatCollector.func_74838_a((String)string);
    }

    public static boolean isHoldingUsableTool(EntityPlayer entityPlayer, int n, int n2, int n3) {
        if (entityPlayer.field_71071_by.func_70448_g() == null) {
            return false;
        }
        Item item = entityPlayer.field_71071_by.func_70448_g().func_77973_b();
        if (item instanceof IToolHammer) {
            return ((IToolHammer)item).isUsable(entityPlayer.field_71071_by.func_70448_g(), (EntityLivingBase)entityPlayer, n, n2, n3);
        }
        if (item instanceof IMFRHammer) {
            return true;
        }
        return bcWrenchExists && MFRUtil.canHandleBCWrench(item, entityPlayer, n, n2, n3);
    }

    public static void usedWrench(EntityPlayer entityPlayer, int n, int n2, int n3) {
        if (entityPlayer.field_71071_by.func_70448_g() == null) {
            return;
        }
        Item item = entityPlayer.field_71071_by.func_70448_g().func_77973_b();
        if (item instanceof IToolHammer) {
            ((IToolHammer)item).toolUsed(entityPlayer.field_71071_by.func_70448_g(), (EntityLivingBase)entityPlayer, n, n2, n3);
        } else if (!(item instanceof IMFRHammer) && bcWrenchExists) {
            MFRUtil.bcWrenchUsed(item, entityPlayer, n, n2, n3);
        }
    }

    private static boolean canHandleBCWrench(Item item, EntityPlayer entityPlayer, int n, int n2, int n3) {
        return item instanceof IToolWrench && ((IToolWrench)item).canWrench(entityPlayer, n, n2, n3);
    }

    private static void bcWrenchUsed(Item item, EntityPlayer entityPlayer, int n, int n2, int n3) {
        if (item instanceof IToolWrench) {
            ((IToolWrench)item).wrenchUsed(entityPlayer, n, n2, n3);
        }
    }

    public static boolean isHoldingHammer(EntityPlayer entityPlayer) {
        if (entityPlayer.field_71071_by.func_70448_g() == null) {
            return false;
        }
        Item item = entityPlayer.field_71071_by.func_70448_g().func_77973_b();
        return item instanceof IMFRHammer;
    }

    public static boolean isHolding(EntityPlayer entityPlayer, Class<? extends Item> clazz) {
        if (entityPlayer.field_71071_by.func_70448_g() == null) {
            return false;
        }
        Item item = entityPlayer.field_71071_by.func_70448_g().func_77973_b();
        return item != null && clazz.isAssignableFrom(item.getClass());
    }

    public static <V extends Entity, T extends Class<V>> V prepareMob(T t, World world) {
        try {
            Entity entity = (Entity)t.getConstructor(World.class).newInstance(world);
            return (V)entity;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static final TileEntity getTile(World world, int n, int n2, int n3) {
        return world.func_72938_d(n, n3).getTileEntityUnsafe(n & 0xF, n2, n3 & 0xF);
    }

    public static ForgeDirection[] directionsWithoutConveyors(World world, int n, int n2, int n3) {
        ArrayList<ForgeDirection> arrayList = new ArrayList<ForgeDirection>();
        Block block = MFRThings.conveyorBlock;
        for (ForgeDirection forgeDirection : ForgeDirection.VALID_DIRECTIONS) {
            if (world.func_147439_a(n + forgeDirection.offsetX, n2 + forgeDirection.offsetY, n3 + forgeDirection.offsetZ).equals(block)) continue;
            arrayList.add(forgeDirection);
        }
        return arrayList.toArray(new ForgeDirection[arrayList.size()]);
    }

    public static void notifyNearbyBlocks(World world, int n, int n2, int n3, Block block) {
        ForgeDirection[] forgeDirectionArray = ForgeDirection.VALID_DIRECTIONS;
        if (world.func_72899_e(n, n2, n3)) {
            for (int i = 0; i < 6; ++i) {
                ForgeDirection forgeDirection = forgeDirectionArray[i];
                int n4 = n + forgeDirection.offsetX;
                int n5 = n2 + forgeDirection.offsetY;
                int n6 = n3 + forgeDirection.offsetZ;
                if (!world.func_72899_e(n4, n5, n6)) continue;
                world.func_147460_e(n4, n5, n6, block);
            }
        }
    }

    public static void notifyNearbyBlocksExcept(World world, int n, int n2, int n3, Block block) {
        ForgeDirection[] forgeDirectionArray = ForgeDirection.VALID_DIRECTIONS;
        if (world.func_72899_e(n, n2, n3) && world.func_147439_a(n, n2, n3) != block) {
            world.func_147460_e(n, n2, n3, block);
            for (int i = 0; i < 6; ++i) {
                ForgeDirection forgeDirection = forgeDirectionArray[i];
                int n4 = n + forgeDirection.offsetX;
                int n5 = n2 + forgeDirection.offsetY;
                int n6 = n3 + forgeDirection.offsetZ;
                if (!world.func_72899_e(n4, n5, n6) || world.func_147439_a(n4, n5, n6) == block) continue;
                world.func_147460_e(n4, n5, n6, block);
            }
        }
    }

    public static void wideNotifyNearbyBlocksExcept(World world, int n, int n2, int n3, Block block) {
        ForgeDirection[] forgeDirectionArray = ForgeDirection.VALID_DIRECTIONS;
        for (int i = 0; i < 6; ++i) {
            ForgeDirection forgeDirection = forgeDirectionArray[i];
            int n4 = n + forgeDirection.offsetX;
            int n5 = n2 + forgeDirection.offsetY;
            int n6 = n3 + forgeDirection.offsetZ;
            if (!world.func_72899_e(n4, n5, n6) || world.func_147439_a(n4, n5, n6) == block) continue;
            world.func_147460_e(n4, n5, n6, block);
            for (int j = 0; j < 6; ++j) {
                if ((j ^ 1) == i) continue;
                ForgeDirection forgeDirection2 = forgeDirectionArray[j];
                int n7 = n4 + forgeDirection2.offsetX;
                int n8 = n5 + forgeDirection2.offsetY;
                int n9 = n6 + forgeDirection2.offsetZ;
                if (!world.func_72899_e(n7, n8, n9) || world.func_147439_a(n7, n8, n9) == block) continue;
                world.func_147460_e(n7, n8, n9, block);
            }
        }
    }

    public static NBTTagCompound writeModifierToNBT(String string, AttributeModifier attributeModifier) {
        NBTTagCompound nBTTagCompound = new NBTTagCompound();
        nBTTagCompound.func_74778_a("AttributeName", string);
        nBTTagCompound.func_74778_a("Name", attributeModifier.func_111166_b());
        nBTTagCompound.func_74780_a("Amount", attributeModifier.func_111164_d());
        nBTTagCompound.func_74768_a("Operation", attributeModifier.func_111169_c());
        nBTTagCompound.func_74772_a("UUIDMost", attributeModifier.func_111167_a().getMostSignificantBits());
        nBTTagCompound.func_74772_a("UUIDLeast", attributeModifier.func_111167_a().getLeastSignificantBits());
        return nBTTagCompound;
    }

    static {
        int n = 16;
        int n2 = 0;
        while (n-- > 0) {
            MFRUtil.COLORS[n2] = COLORS_DYE[n];
            ++n2;
        }
        VALID_DIRECTIONS = Arrays.asList(ForgeDirection.VALID_DIRECTIONS);
        bcWrenchExists = false;
        try {
            Class.forName("buildcraft.api.tools.IToolWrench");
            bcWrenchExists = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

