/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.circuits.digital;

import net.minecraft.nbt.NBTTagCompound;
import powercrystals.minefactoryreloaded.api.rednet.IRedNetLogicCircuit;

public class Counter
implements IRedNetLogicCircuit {
    private int _count;
    private boolean _lastIncrementState;
    private boolean _lastDecrementState;

    @Override
    public byte getInputCount() {
        return 4;
    }

    @Override
    public byte getOutputCount() {
        return 2;
    }

    @Override
    public int[] recalculateOutputValues(long l, int[] nArray) {
        int n = nArray[2];
        if (n <= 0) {
            return new int[]{0, this._count};
        }
        int n2 = nArray[3] > 0 ? 0 : (this._count = nArray[3] < 0 ? n - 1 : this._count);
        if (nArray[0] > 0 && !this._lastIncrementState) {
            ++this._count;
        } else if (nArray[1] > 0 && !this._lastDecrementState) {
            --this._count;
        }
        this._lastIncrementState = nArray[0] > 0;
        boolean bl = this._lastDecrementState = nArray[1] > 0;
        if (this._count >= n) {
            this._count = 0;
            return new int[]{15, this._count};
        }
        if (this._count < 0) {
            this._count = n - 1;
            return new int[]{15, this._count};
        }
        return new int[]{0, this._count};
    }

    @Override
    public String getUnlocalizedName() {
        return "circuit.mfr.counter";
    }

    @Override
    public String getInputPinLabel(int n) {
        switch (n) {
            case 0: {
                return "INC";
            }
            case 1: {
                return "DEC";
            }
            case 2: {
                return "PRE";
            }
            case 3: {
                return "R";
            }
        }
        return "";
    }

    @Override
    public String getOutputPinLabel(int n) {
        return n == 0 ? "Q" : "V";
    }

    @Override
    public void readFromNBT(NBTTagCompound nBTTagCompound) {
        this._count = nBTTagCompound.func_74762_e("count");
        this._lastIncrementState = nBTTagCompound.func_74767_n("lastIncrementState");
        this._lastDecrementState = nBTTagCompound.func_74767_n("lastDecrementState");
    }

    @Override
    public void writeToNBT(NBTTagCompound nBTTagCompound) {
        nBTTagCompound.func_74768_a("count", this._count);
        nBTTagCompound.func_74757_a("lastIncrementState", this._lastIncrementState);
        nBTTagCompound.func_74757_a("lastDecrementState", this._lastDecrementState);
    }
}

