/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.block;

import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import powercrystals.minefactoryreloaded.MineFactoryReloadedCore;
import powercrystals.minefactoryreloaded.api.rednet.IRedNetInputNode;
import powercrystals.minefactoryreloaded.api.rednet.connectivity.RedNetConnectionType;
import powercrystals.minefactoryreloaded.block.BlockFactory;
import powercrystals.minefactoryreloaded.core.MFRUtil;
import powercrystals.minefactoryreloaded.tile.base.TileEntityFactory;
import powercrystals.minefactoryreloaded.tile.rednet.TileEntityRedNetHistorian;

public class BlockRedNetPanel
extends BlockFactory
implements IRedNetInputNode {
    public BlockRedNetPanel() {
        super(0.8f);
        this.func_149663_c("mfr.rednet.panel");
    }

    public void func_149719_a(IBlockAccess iBlockAccess, int n, int n2, int n3) {
        TileEntity tileEntity = iBlockAccess.func_147438_o(n, n2, n3);
        if (tileEntity instanceof TileEntityFactory) {
            if (((TileEntityFactory)tileEntity).getDirectionFacing() == ForgeDirection.NORTH) {
                this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.25f);
            } else if (((TileEntityFactory)tileEntity).getDirectionFacing() == ForgeDirection.SOUTH) {
                this.func_149676_a(0.0f, 0.0f, 0.75f, 1.0f, 1.0f, 1.0f);
            } else if (((TileEntityFactory)tileEntity).getDirectionFacing() == ForgeDirection.EAST) {
                this.func_149676_a(0.75f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            } else if (((TileEntityFactory)tileEntity).getDirectionFacing() == ForgeDirection.WEST) {
                this.func_149676_a(0.0f, 0.0f, 0.0f, 0.25f, 1.0f, 1.0f);
            }
        }
    }

    @Override
    public void func_149689_a(World world, int n, int n2, int n3, EntityLivingBase entityLivingBase, ItemStack itemStack) {
        super.func_149689_a(world, n, n2, n3, entityLivingBase, itemStack);
        if (entityLivingBase == null) {
            return;
        }
        TileEntity tileEntity = BlockRedNetPanel.getTile(world, n, n2, n3);
        if (tileEntity instanceof TileEntityFactory && ((TileEntityFactory)tileEntity).canRotate()) {
            int n4 = MathHelper.func_76128_c((double)((double)(entityLivingBase.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
            if (n4 == 0) {
                ((TileEntityFactory)tileEntity).rotateDirectlyTo(3);
            } else if (n4 == 1) {
                ((TileEntityFactory)tileEntity).rotateDirectlyTo(4);
            } else if (n4 == 2) {
                ((TileEntityFactory)tileEntity).rotateDirectlyTo(2);
            } else if (n4 == 3) {
                ((TileEntityFactory)tileEntity).rotateDirectlyTo(5);
            }
        }
    }

    @Override
    public boolean activated(World world, int n, int n2, int n3, EntityPlayer entityPlayer, int n4) {
        ItemStack itemStack = entityPlayer.field_71071_by.func_70448_g();
        TileEntity tileEntity = BlockRedNetPanel.getTile(world, n, n2, n3);
        if (MFRUtil.isHoldingUsableTool(entityPlayer, n, n2, n3) && tileEntity instanceof TileEntityFactory && ((TileEntityFactory)tileEntity).canRotate()) {
            ((TileEntityFactory)tileEntity).rotate(ForgeDirection.getOrientation((int)n4));
            world.func_147471_g(n, n2, n3);
            MFRUtil.usedWrench(entityPlayer, n, n2, n3);
            return true;
        }
        if (tileEntity instanceof TileEntityFactory && ((TileEntityFactory)tileEntity).getContainer(entityPlayer.field_71071_by) != null) {
            entityPlayer.openGui((Object)MineFactoryReloadedCore.instance(), 0, world, n, n2, n3);
            return true;
        }
        if (tileEntity instanceof TileEntityRedNetHistorian && itemStack != null && itemStack.func_77973_b().equals(Items.field_151100_aR)) {
            ((TileEntityRedNetHistorian)tileEntity).setSelectedSubnet(15 - itemStack.func_77960_j());
            world.func_147471_g(n, n2, n3);
            return true;
        }
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return MineFactoryReloadedCore.renderIdRedNetPanel;
    }

    @Override
    public boolean isSideSolid(IBlockAccess iBlockAccess, int n, int n2, int n3, ForgeDirection forgeDirection) {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    @Override
    public TileEntity func_149915_a(World world, int n) {
        return new TileEntityRedNetHistorian();
    }

    @Override
    public RedNetConnectionType getConnectionType(World world, int n, int n2, int n3, ForgeDirection forgeDirection) {
        TileEntity tileEntity = world.func_147438_o(n, n2, n3);
        if (tileEntity instanceof TileEntityFactory) {
            return forgeDirection == ((TileEntityFactory)tileEntity).getDirectionFacing() ? RedNetConnectionType.CableAll : RedNetConnectionType.None;
        }
        return RedNetConnectionType.None;
    }

    @Override
    public void onInputsChanged(World world, int n, int n2, int n3, ForgeDirection forgeDirection, int[] nArray) {
        TileEntity tileEntity = world.func_147438_o(n, n2, n3);
        if (tileEntity instanceof TileEntityRedNetHistorian) {
            ((TileEntityRedNetHistorian)tileEntity).valuesChanged(nArray);
        }
    }

    @Override
    public void onInputChanged(World world, int n, int n2, int n3, ForgeDirection forgeDirection, int n4) {
    }

    @Override
    public void func_149651_a(IIconRegister iIconRegister) {
        this.field_149761_L = iIconRegister.func_94245_a("minefactoryreloaded:" + this.func_149739_a());
    }
}

