/*
 * Decompiled with CFR 0.152.
 */
package appeng.util.inv;

import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IItemList;
import appeng.util.inv.IMEAdaptor;
import appeng.util.inv.ItemSlot;
import java.util.Iterator;

public class IMEAdaptorIterator
implements Iterator<ItemSlot> {
    final Iterator<IAEItemStack> stack;
    final ItemSlot slot = new ItemSlot();
    int offset = 0;
    boolean hasNext;
    final IMEAdaptor parent;
    final int containerSize;

    public IMEAdaptorIterator(IMEAdaptor parent, IItemList<IAEItemStack> availableItems) {
        this.stack = availableItems.iterator();
        this.containerSize = parent.maxSlots;
        this.parent = parent;
    }

    @Override
    public boolean hasNext() {
        this.hasNext = this.stack.hasNext();
        return this.offset < this.containerSize || this.hasNext;
    }

    @Override
    public ItemSlot next() {
        this.slot.slot = this.offset++;
        this.slot.isExtractable = true;
        if (this.parent.maxSlots < this.offset) {
            this.parent.maxSlots = this.offset;
        }
        if (this.hasNext) {
            IAEItemStack item = this.stack.next();
            this.slot.setAEItemStack(item);
            return this.slot;
        }
        this.slot.setItemStack(null);
        return this.slot;
    }

    @Override
    public void remove() {
        throw new RuntimeException("Not Implemented!");
    }
}

