/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.spatial;

import appeng.api.networking.GridFlags;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.me.GridAccessException;
import appeng.me.cluster.IAEMultiBlock;
import appeng.me.cluster.implementations.SpatialPylonCalculator;
import appeng.me.cluster.implementations.SpatialPylonCluster;
import appeng.me.helpers.AENetworkProxy;
import appeng.me.helpers.AENetworkProxyMultiblock;
import appeng.tile.TileEvent;
import appeng.tile.events.TileEventType;
import appeng.tile.grid.AENetworkTile;
import io.netty.buffer.ByteBuf;
import java.util.EnumSet;
import net.minecraftforge.common.util.ForgeDirection;

public class TileSpatialPylon
extends AENetworkTile
implements IAEMultiBlock {
    public final int DISPLAY_END_MIN = 1;
    public final int DISPLAY_END_MAX = 2;
    public final int DISPLAY_MIDDLE = 3;
    public final int DISPLAY_X = 4;
    public final int DISPLAY_Y = 8;
    public final int DISPLAY_Z = 12;
    public final int MB_STATUS = 15;
    public final int DISPLAY_ENABLED = 16;
    public final int DISPLAY_POWERED_ENABLED = 32;
    public final int NET_STATUS = 48;
    int displayBits = 0;
    SpatialPylonCluster cluster;
    final SpatialPylonCalculator calc = new SpatialPylonCalculator(this);
    boolean didHaveLight = false;

    @Override
    protected AENetworkProxy createProxy() {
        return new AENetworkProxyMultiblock(this, "proxy", this.getItemFromTile(this), true);
    }

    @Override
    public boolean canBeRotated() {
        return false;
    }

    @TileEvent(value=TileEventType.NETWORK_READ)
    public boolean readFromStream_TileSpatialPylon(ByteBuf data) {
        int old = this.displayBits;
        this.displayBits = data.readByte();
        return old != this.displayBits;
    }

    @TileEvent(value=TileEventType.NETWORK_WRITE)
    public void writeToStream_TileSpatialPylon(ByteBuf data) {
        data.writeByte(this.displayBits);
    }

    public TileSpatialPylon() {
        this.gridProxy.setFlags(GridFlags.REQUIRE_CHANNEL, GridFlags.MULTIBLOCK);
        this.gridProxy.setIdlePowerUsage(0.5);
        this.gridProxy.setValidSides(EnumSet.noneOf(ForgeDirection.class));
    }

    @Override
    public void onReady() {
        super.onReady();
        this.onNeighborBlockChange();
    }

    @Override
    public void markForUpdate() {
        boolean hasLight;
        super.markForUpdate();
        boolean bl = hasLight = this.getLightValue() > 0;
        if (hasLight != this.didHaveLight) {
            this.didHaveLight = hasLight;
            this.field_145850_b.func_147451_t(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public int getLightValue() {
        if ((this.displayBits & this.DISPLAY_POWERED_ENABLED) == this.DISPLAY_POWERED_ENABLED) {
            return 8;
        }
        return 0;
    }

    @MENetworkEventSubscribe
    public void powerRender(MENetworkPowerStatusChange c) {
        this.recalculateDisplay();
    }

    @MENetworkEventSubscribe
    public void activeRender(MENetworkChannelsChanged c) {
        this.recalculateDisplay();
    }

    @Override
    public void func_145843_s() {
        this.disconnect(false);
        super.func_145843_s();
    }

    @Override
    public void onChunkUnload() {
        this.disconnect(false);
        super.onChunkUnload();
    }

    public void onNeighborBlockChange() {
        this.calc.calculateMultiblock(this.field_145850_b, this.getLocation());
    }

    @Override
    public SpatialPylonCluster getCluster() {
        return this.cluster;
    }

    public void recalculateDisplay() {
        int oldBits = this.displayBits;
        this.displayBits = 0;
        if (this.cluster != null) {
            this.displayBits = this.cluster.min.equals(this.getLocation()) ? this.DISPLAY_END_MIN : (this.cluster.max.equals(this.getLocation()) ? this.DISPLAY_END_MAX : this.DISPLAY_MIDDLE);
            switch (this.cluster.currentAxis) {
                case X: {
                    this.displayBits |= this.DISPLAY_X;
                    break;
                }
                case Y: {
                    this.displayBits |= this.DISPLAY_Y;
                    break;
                }
                case Z: {
                    this.displayBits |= this.DISPLAY_Z;
                    break;
                }
                default: {
                    this.displayBits = 0;
                }
            }
            try {
                if (this.gridProxy.getEnergy().isNetworkPowered()) {
                    this.displayBits |= this.DISPLAY_POWERED_ENABLED;
                }
                if (this.cluster.isValid && this.gridProxy.isActive()) {
                    this.displayBits |= this.DISPLAY_ENABLED;
                }
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
        if (oldBits != this.displayBits) {
            this.markForUpdate();
        }
    }

    public void updateStatus(SpatialPylonCluster c) {
        this.cluster = c;
        this.gridProxy.setValidSides(c == null ? EnumSet.noneOf(ForgeDirection.class) : EnumSet.allOf(ForgeDirection.class));
        this.recalculateDisplay();
    }

    @Override
    public void disconnect(boolean b) {
        if (this.cluster != null) {
            this.cluster.destroy();
            this.updateStatus(null);
        }
    }

    @Override
    public boolean isValid() {
        return true;
    }

    public int getDisplayBits() {
        return this.displayBits;
    }
}

