/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.powersink;

import appeng.api.config.PowerUnits;
import appeng.tile.powersink.RotaryCraft;
import appeng.transformer.annotations.integration;
import cofh.api.energy.IEnergyReceiver;
import net.minecraftforge.common.util.ForgeDirection;

@integration.Interface(iname="RF", iface="cofh.api.energy.IEnergyReceiver")
public abstract class RedstoneFlux
extends RotaryCraft
implements IEnergyReceiver {
    public final int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        int networkRFDemand = (int)Math.floor(this.getExternalPowerDemand(PowerUnits.RF, maxReceive));
        int usedRF = Math.min(maxReceive, networkRFDemand);
        if (!simulate) {
            this.injectExternalPower(PowerUnits.RF, usedRF);
        }
        return usedRF;
    }

    public final int getEnergyStored(ForgeDirection from) {
        return (int)Math.floor(PowerUnits.AE.convertTo(PowerUnits.RF, this.getAECurrentPower()));
    }

    public final int getMaxEnergyStored(ForgeDirection from) {
        return (int)Math.floor(PowerUnits.AE.convertTo(PowerUnits.RF, this.getAEMaxPower()));
    }

    public final boolean canConnectEnergy(ForgeDirection from) {
        return this.getPowerSides().contains(from);
    }
}

