/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.powersink;

import appeng.api.config.PowerUnits;
import appeng.core.AppEng;
import appeng.integration.IntegrationType;
import appeng.integration.abstraction.IMJ5;
import appeng.integration.abstraction.helpers.BaseMJPerdition;
import appeng.tile.TileEvent;
import appeng.tile.events.TileEventType;
import appeng.tile.powersink.AERootPoweredTile;
import appeng.transformer.annotations.integration;
import appeng.util.Platform;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerHandler;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

@integration.Interface(iname="MJ5", iface="buildcraft.api.power.IPowerReceptor")
public abstract class MinecraftJoules5
extends AERootPoweredTile
implements IPowerReceptor {
    BaseMJPerdition bcPowerWrapper;

    @integration.Method(iname="MJ5")
    @TileEvent(value=TileEventType.TICK)
    public void Tick_MinecraftJoules5() {
        if (this.bcPowerWrapper != null) {
            this.bcPowerWrapper.Tick();
        }
    }

    public MinecraftJoules5() {
        if (Platform.isServer()) {
            try {
                IMJ5 mjIntegration;
                if (AppEng.instance.isIntegrationEnabled(IntegrationType.MJ5) && (mjIntegration = (IMJ5)AppEng.instance.getIntegration(IntegrationType.MJ5)) != null) {
                    this.bcPowerWrapper = (BaseMJPerdition)mjIntegration.createPerdition(this);
                    if (this.bcPowerWrapper != null) {
                        this.bcPowerWrapper.configure(1, 380, 0.2f, 1000);
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @integration.Method(iname="MJ5")
    public final PowerHandler.PowerReceiver getPowerReceiver(ForgeDirection side) {
        if (this.getPowerSides().contains(side) && this.bcPowerWrapper != null) {
            return this.bcPowerWrapper.getPowerReceiver();
        }
        return null;
    }

    @integration.Method(iname="MJ5")
    public final void doWork(PowerHandler workProvider) {
        float required = (float)this.getExternalPowerDemand(PowerUnits.MJ, this.bcPowerWrapper.getPowerReceiver().getEnergyStored());
        double failed = this.injectExternalPower(PowerUnits.MJ, this.bcPowerWrapper.useEnergy(0.0, required, true));
        if (failed > 0.01) {
            this.bcPowerWrapper.addEnergy((float)failed);
        }
    }

    @integration.Method(iname="MJ5")
    public final World getWorld() {
        return this.field_145850_b;
    }
}

