/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.networking;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.util.AECableType;
import appeng.me.GridAccessException;
import appeng.tile.TileEvent;
import appeng.tile.events.TileEventType;
import appeng.tile.grid.AENetworkPowerTile;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.tile.inventory.InvOperation;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEnergyAcceptor
extends AENetworkPowerTile {
    final int[] sides = new int[0];
    static final AppEngInternalInventory inv = new AppEngInternalInventory(null, 0);

    @Override
    public AECableType getCableConnectionType(ForgeDirection dir) {
        return AECableType.COVERED;
    }

    @TileEvent(value=TileEventType.TICK)
    public void Tick_TileEnergyAcceptor() {
        if (this.internalCurrentPower > 0.0) {
            try {
                IEnergyGrid eg = this.gridProxy.getEnergy();
                double powerRequested = this.internalCurrentPower - eg.injectPower(this.internalCurrentPower, Actionable.SIMULATE);
                if (powerRequested > 0.0) {
                    eg.injectPower(this.extractAEPower(powerRequested, Actionable.MODULATE, PowerMultiplier.ONE), Actionable.MODULATE);
                }
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
    }

    @Override
    protected double getFunnelPowerDemand(double maxRequired) {
        try {
            IEnergyGrid grid = this.gridProxy.getEnergy();
            return grid.getEnergyDemand(maxRequired);
        }
        catch (GridAccessException e) {
            return super.getFunnelPowerDemand(maxRequired);
        }
    }

    @Override
    protected double funnelPowerIntoStorage(double newPower, Actionable mode) {
        try {
            IEnergyGrid grid = this.gridProxy.getEnergy();
            double leftOver = grid.injectPower(newPower, mode);
            if (mode == Actionable.SIMULATE) {
                return leftOver;
            }
            return 0.0;
        }
        catch (GridAccessException e) {
            return super.funnelPowerIntoStorage(newPower, mode);
        }
    }

    public TileEnergyAcceptor() {
        this.gridProxy.setIdlePowerUsage(0.0);
        this.internalMaxPower = 100.0;
    }

    @Override
    public IInventory getInternalInventory() {
        return inv;
    }

    @Override
    public void onChangeInventory(IInventory inv, int slot, InvOperation mc, ItemStack removed, ItemStack added) {
    }

    @Override
    public int[] getAccessibleSlotsBySide(ForgeDirection side) {
        return this.sides;
    }
}

