/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.misc;

import appeng.api.AEApi;
import appeng.api.config.CondenserOutput;
import appeng.api.config.Settings;
import appeng.api.implementations.items.IStorageComponent;
import appeng.api.util.IConfigManager;
import appeng.api.util.IConfigurableObject;
import appeng.tile.AEBaseInvTile;
import appeng.tile.TileEvent;
import appeng.tile.events.TileEventType;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.tile.inventory.InvOperation;
import appeng.util.ConfigManager;
import appeng.util.IConfigManagerHost;
import appeng.util.Platform;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileCondenser
extends AEBaseInvTile
implements IFluidHandler,
IConfigManagerHost,
IConfigurableObject {
    final int[] sides = new int[]{0, 1};
    private static final FluidTankInfo[] empty = new FluidTankInfo[]{new FluidTankInfo(null, 10)};
    final AppEngInternalInventory inv = new AppEngInternalInventory(this, 3);
    final ConfigManager cm = new ConfigManager(this);
    public double storedPower = 0.0;

    @TileEvent(value=TileEventType.WORLD_NBT_WRITE)
    public void writeToNBT_TileCondenser(NBTTagCompound data) {
        this.cm.writeToNBT(data);
        data.func_74780_a("storedPower", this.storedPower);
    }

    @TileEvent(value=TileEventType.WORLD_NBT_READ)
    public void readFromNBT_TileCondenser(NBTTagCompound data) {
        this.cm.readFromNBT(data);
        this.storedPower = data.func_74769_h("storedPower");
    }

    public TileCondenser() {
        this.cm.registerSetting(Settings.CONDENSER_OUTPUT, CondenserOutput.TRASH);
    }

    public double getStorage() {
        IStorageComponent sc;
        ItemStack is = this.inv.func_70301_a(2);
        if (is != null && is.func_77973_b() instanceof IStorageComponent && (sc = (IStorageComponent)is.func_77973_b()).isStorageComponent(is)) {
            return sc.getBytes(is) * 8;
        }
        return 0.0;
    }

    public void addPower(double rawPower) {
        this.storedPower += rawPower;
        this.storedPower = Math.max(0.0, Math.min(this.getStorage(), this.storedPower));
        double requiredPower = this.getRequiredPower();
        ItemStack output = this.getOutput();
        while (requiredPower <= this.storedPower && output != null && requiredPower > 0.0 && this.canAddOutput(output)) {
            this.storedPower -= requiredPower;
            this.addOutput(output);
        }
    }

    private boolean canAddOutput(ItemStack output) {
        ItemStack outputStack = this.func_70301_a(1);
        return outputStack == null || Platform.isSameItem(outputStack, output) && outputStack.field_77994_a < outputStack.func_77976_d();
    }

    private void addOutput(ItemStack output) {
        ItemStack outputStack = this.func_70301_a(1);
        if (outputStack == null) {
            this.func_70299_a(1, output.func_77946_l());
        } else {
            ++outputStack.field_77994_a;
            this.func_70299_a(1, outputStack);
        }
    }

    private ItemStack getOutput() {
        switch ((CondenserOutput)this.cm.getSetting(Settings.CONDENSER_OUTPUT)) {
            case MATTER_BALLS: {
                return AEApi.instance().materials().materialMatterBall.stack(1);
            }
            case SINGULARITY: {
                return AEApi.instance().materials().materialSingularity.stack(1);
            }
        }
        return null;
    }

    public double getRequiredPower() {
        return ((CondenserOutput)this.cm.getSetting((Enum)Settings.CONDENSER_OUTPUT)).requiredPower;
    }

    @Override
    public void func_70299_a(int i, ItemStack itemstack) {
        if (i == 0) {
            if (itemstack != null) {
                this.addPower(itemstack.field_77994_a);
            }
        } else {
            this.inv.func_70299_a(1, itemstack);
        }
    }

    @Override
    public boolean func_94041_b(int i, ItemStack itemstack) {
        return i == 0;
    }

    @Override
    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return i != 0;
    }

    @Override
    public boolean func_102007_a(int i, ItemStack itemstack, int j) {
        return i == 0;
    }

    @Override
    public int[] getAccessibleSlotsBySide(ForgeDirection side) {
        return this.sides;
    }

    @Override
    public IInventory getInternalInventory() {
        return this.inv;
    }

    @Override
    public void onChangeInventory(IInventory inv, int slot, InvOperation mc, ItemStack removed, ItemStack added) {
        ItemStack is;
        if (slot == 0 && (is = inv.func_70301_a(0)) != null) {
            this.addPower(is.field_77994_a);
            inv.func_70299_a(0, null);
        }
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (doFill) {
            this.addPower((resource == null ? 0.0 : (double)resource.amount) / 500.0);
        }
        return resource == null ? 0 : resource.amount;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return empty;
    }

    @Override
    public void updateSetting(IConfigManager manager, Enum settingName, Enum newValue) {
        this.addPower(0.0);
    }

    @Override
    public IConfigManager getConfigManager() {
        return this.cm;
    }
}

