/*
 * Decompiled with CFR 0.152.
 */
package appeng.recipes.game;

import appeng.api.exceptions.MissingIngredientError;
import appeng.api.exceptions.RegistrationError;
import appeng.api.recipes.IIngredient;
import appeng.recipes.game.IRecipeBakeable;
import java.util.ArrayList;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;

public class ShapelessRecipe
implements IRecipe,
IRecipeBakeable {
    private ItemStack output = null;
    private final ArrayList<Object> input = new ArrayList();
    private boolean disable = false;

    public boolean isEnabled() {
        return !this.disable;
    }

    public ShapelessRecipe(ItemStack result, Object ... recipe) {
        this.output = result.func_77946_l();
        for (Object in : recipe) {
            if (!(in instanceof IIngredient)) {
                StringBuilder ret = new StringBuilder("Invalid shapeless ore recipe: ");
                for (Object tmp : recipe) {
                    ret.append(tmp).append(", ");
                }
                ret.append(this.output);
                throw new RuntimeException(ret.toString());
            }
            this.input.add(in);
        }
    }

    public int func_77570_a() {
        return this.input.size();
    }

    public ItemStack func_77571_b() {
        return this.output;
    }

    public ItemStack func_77572_b(InventoryCrafting var1) {
        return this.output.func_77946_l();
    }

    public boolean func_77569_a(InventoryCrafting var1, World world) {
        if (this.disable) {
            return false;
        }
        ArrayList<Object> required = new ArrayList<Object>(this.input);
        for (int x = 0; x < var1.func_70302_i_(); ++x) {
            ItemStack slot = var1.func_70301_a(x);
            if (slot == null) continue;
            boolean inRecipe = false;
            for (Object next : required) {
                boolean match = false;
                if (next instanceof IIngredient) {
                    try {
                        for (ItemStack item : ((IIngredient)next).getItemStackSet()) {
                            match = match || this.checkItemEquals(item, slot);
                        }
                    }
                    catch (RegistrationError e) {
                    }
                    catch (MissingIngredientError e) {
                        // empty catch block
                    }
                }
                if (!match) continue;
                inRecipe = true;
                required.remove(next);
                break;
            }
            if (inRecipe) continue;
            return false;
        }
        return required.isEmpty();
    }

    private boolean checkItemEquals(ItemStack target, ItemStack input) {
        return target.func_77973_b() == input.func_77973_b() && (target.func_77960_j() == Short.MAX_VALUE || target.func_77960_j() == input.func_77960_j());
    }

    public ArrayList<Object> getInput() {
        return this.input;
    }

    @Override
    public void bake() throws RegistrationError {
        try {
            this.disable = false;
            for (Object o : this.getInput()) {
                if (!(o instanceof IIngredient)) continue;
                ((IIngredient)o).bake();
            }
        }
        catch (MissingIngredientError e) {
            this.disable = true;
        }
    }
}

