/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.reporting;

import appeng.api.implementations.IPowerChannelState;
import appeng.api.implementations.parts.IPartMonitor;
import appeng.api.networking.GridFlags;
import appeng.api.networking.events.MENetworkBootingStatusChange;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartRenderHelper;
import appeng.client.texture.CableBusTextures;
import appeng.me.GridAccessException;
import appeng.parts.AEBasePart;
import appeng.util.Platform;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraftforge.common.util.ForgeDirection;

public class PartMonitor
extends AEBasePart
implements IPartMonitor,
IPowerChannelState {
    CableBusTextures frontDark = CableBusTextures.PartMonitor_Colored;
    CableBusTextures frontBright = CableBusTextures.PartMonitor_Bright;
    CableBusTextures frontColored = CableBusTextures.PartMonitor_Colored;
    boolean notLightSource = !this.getClass().equals(PartMonitor.class);
    final int POWERED_FLAG = 4;
    final int BOOTING_FLAG = 8;
    final int CHANNEL_FLAG = 16;
    byte spin = 0;
    int clientFlags = 0;
    float opacity = -1.0f;

    @Override
    public void onPlacement(EntityPlayer player, ItemStack held, ForgeDirection side) {
        super.onPlacement(player, held, side);
        byte rotation = (byte)(MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 2.5)) & 3);
        if (side == ForgeDirection.UP) {
            this.spin = rotation;
        } else if (side == ForgeDirection.DOWN) {
            this.spin = rotation;
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74776_a("opacity", this.opacity);
        data.func_74774_a("spin", this.spin);
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        if (data.func_74764_b("opacity")) {
            this.opacity = data.func_74760_g("opacity");
        }
        this.spin = data.func_74771_c("spin");
    }

    @Override
    public boolean onPartActivate(EntityPlayer player, Vec3 pos) {
        TileEntity te = this.getTile();
        if (!player.func_70093_af() && Platform.isWrench(player, player.field_71071_by.func_70448_g(), te.field_145851_c, te.field_145848_d, te.field_145849_e)) {
            if (Platform.isServer()) {
                if (this.spin > 3) {
                    this.spin = 0;
                }
                switch (this.spin) {
                    case 0: {
                        this.spin = 1;
                        break;
                    }
                    case 1: {
                        this.spin = (byte)3;
                        break;
                    }
                    case 2: {
                        this.spin = 0;
                        break;
                    }
                    case 3: {
                        this.spin = (byte)2;
                    }
                }
                this.host.markForUpdate();
                this.saveChanges();
            }
            return true;
        }
        return super.onPartActivate(player, pos);
    }

    @MENetworkEventSubscribe
    public void bootingRender(MENetworkBootingStatusChange c) {
        if (this.notLightSource) {
            this.getHost().markForUpdate();
        }
    }

    @Override
    public void onNeighborChanged() {
        this.opacity = -1.0f;
        this.getHost().markForUpdate();
    }

    @MENetworkEventSubscribe
    public void powerRender(MENetworkPowerStatusChange c) {
        this.getHost().markForUpdate();
    }

    @Override
    public void writeToStream(ByteBuf data) throws IOException {
        super.writeToStream(data);
        this.clientFlags = this.spin & 3;
        try {
            if (this.proxy.getEnergy().isNetworkPowered()) {
                this.clientFlags |= this.POWERED_FLAG;
            }
            if (this.proxy.getPath().isNetworkBooting()) {
                this.clientFlags |= this.BOOTING_FLAG;
            }
            if (this.proxy.getNode().meetsChannelRequirements()) {
                this.clientFlags |= this.CHANNEL_FLAG;
            }
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
        data.writeByte((int)((byte)this.clientFlags));
    }

    @Override
    public boolean readFromStream(ByteBuf data) throws IOException {
        super.readFromStream(data);
        int oldFlags = this.clientFlags;
        this.clientFlags = data.readByte();
        this.spin = (byte)(this.clientFlags & 3);
        return this.clientFlags != oldFlags;
    }

    @Override
    public int getLightLevel() {
        return this.blockLight(this.isPowered() ? (this.notLightSource ? 9 : 15) : 0);
    }

    private int blockLight(int emit) {
        if (this.opacity < 0.0f) {
            TileEntity te = this.getTile();
            this.opacity = 255 - te.func_145831_w().getBlockLightOpacity(te.field_145851_c + this.side.offsetX, te.field_145848_d + this.side.offsetY, te.field_145849_e + this.side.offsetZ);
        }
        return (int)((float)emit * (this.opacity / 255.0f));
    }

    @Override
    public boolean isPowered() {
        try {
            if (Platform.isServer()) {
                return this.proxy.getEnergy().isNetworkPowered();
            }
            return (this.clientFlags & this.POWERED_FLAG) == this.POWERED_FLAG;
        }
        catch (GridAccessException e) {
            return false;
        }
    }

    public PartMonitor(ItemStack is) {
        this(PartMonitor.class, is, false);
    }

    protected PartMonitor(Class c, ItemStack is, boolean requireChannel) {
        super(c, is);
        if (requireChannel) {
            this.proxy.setFlags(GridFlags.REQUIRE_CHANNEL);
            this.proxy.setIdlePowerUsage(0.5);
        } else {
            this.proxy.setIdlePowerUsage(0.0625);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderInventory(IPartRenderHelper rh, RenderBlocks renderer) {
        rh.setBounds(2.0f, 2.0f, 14.0f, 14.0f, 14.0f, 16.0f);
        rh.setTexture(CableBusTextures.PartMonitorSides.getIcon(), CableBusTextures.PartMonitorSides.getIcon(), CableBusTextures.PartMonitorBack.getIcon(), this.is.func_77954_c(), CableBusTextures.PartMonitorSides.getIcon(), CableBusTextures.PartMonitorSides.getIcon());
        rh.renderInventoryBox(renderer);
        rh.setInvColor(this.getColor().whiteVariant);
        rh.renderInventoryFace(this.frontBright.getIcon(), ForgeDirection.SOUTH, renderer);
        rh.setInvColor(this.getColor().mediumVariant);
        rh.renderInventoryFace(this.frontDark.getIcon(), ForgeDirection.SOUTH, renderer);
        rh.setInvColor(this.getColor().blackVariant);
        rh.renderInventoryFace(this.frontColored.getIcon(), ForgeDirection.SOUTH, renderer);
        rh.setBounds(4.0f, 4.0f, 13.0f, 12.0f, 12.0f, 14.0f);
        rh.renderInventoryBox(renderer);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderStatic(int x, int y, int z, IPartRenderHelper rh, RenderBlocks renderer) {
        this.renderCache = rh.useSimplifiedRendering(x, y, z, this, this.renderCache);
        rh.setTexture(CableBusTextures.PartMonitorSides.getIcon(), CableBusTextures.PartMonitorSides.getIcon(), CableBusTextures.PartMonitorBack.getIcon(), this.is.func_77954_c(), CableBusTextures.PartMonitorSides.getIcon(), CableBusTextures.PartMonitorSides.getIcon());
        rh.setBounds(2.0f, 2.0f, 14.0f, 14.0f, 14.0f, 16.0f);
        rh.renderBlock(x, y, z, renderer);
        if (this.getLightLevel() > 0) {
            int l = 13;
            Tessellator.field_78398_a.func_78380_c(l << 20 | l << 4);
        }
        byte by = this.spin;
        renderer.field_147873_r = by;
        renderer.field_147867_u = by;
        renderer.field_147871_s = by;
        renderer.field_147869_t = by;
        renderer.field_147875_q = by;
        renderer.field_147865_v = by;
        Tessellator.field_78398_a.func_78378_d(this.getColor().whiteVariant);
        rh.renderFace(x, y, z, this.frontBright.getIcon(), ForgeDirection.SOUTH, renderer);
        Tessellator.field_78398_a.func_78378_d(this.getColor().mediumVariant);
        rh.renderFace(x, y, z, this.frontDark.getIcon(), ForgeDirection.SOUTH, renderer);
        Tessellator.field_78398_a.func_78378_d(this.getColor().blackVariant);
        rh.renderFace(x, y, z, this.frontColored.getIcon(), ForgeDirection.SOUTH, renderer);
        renderer.field_147873_r = 0;
        renderer.field_147867_u = 0;
        renderer.field_147871_s = 0;
        renderer.field_147869_t = 0;
        renderer.field_147875_q = 0;
        renderer.field_147865_v = 0;
        if (this.notLightSource) {
            rh.setTexture(CableBusTextures.PartMonitorSidesStatus.getIcon(), CableBusTextures.PartMonitorSidesStatus.getIcon(), CableBusTextures.PartMonitorBack.getIcon(), this.is.func_77954_c(), CableBusTextures.PartMonitorSidesStatus.getIcon(), CableBusTextures.PartMonitorSidesStatus.getIcon());
        }
        rh.setBounds(4.0f, 4.0f, 13.0f, 12.0f, 12.0f, 14.0f);
        rh.renderBlock(x, y, z, renderer);
        if (this.notLightSource) {
            boolean hasPower;
            boolean hasChan = (this.clientFlags & (this.POWERED_FLAG | this.CHANNEL_FLAG)) == (this.POWERED_FLAG | this.CHANNEL_FLAG);
            boolean bl = hasPower = (this.clientFlags & this.POWERED_FLAG) == this.POWERED_FLAG;
            if (hasChan) {
                int l = 14;
                Tessellator.field_78398_a.func_78380_c(l << 20 | l << 4);
                Tessellator.field_78398_a.func_78378_d(this.getColor().blackVariant);
            } else if (hasPower) {
                int l = 9;
                Tessellator.field_78398_a.func_78380_c(l << 20 | l << 4);
                Tessellator.field_78398_a.func_78378_d(this.getColor().whiteVariant);
            } else {
                Tessellator.field_78398_a.func_78380_c(0);
                Tessellator.field_78398_a.func_78378_d(0);
            }
            rh.renderFace(x, y, z, CableBusTextures.PartMonitorSidesStatusLights.getIcon(), ForgeDirection.EAST, renderer);
            rh.renderFace(x, y, z, CableBusTextures.PartMonitorSidesStatusLights.getIcon(), ForgeDirection.WEST, renderer);
            rh.renderFace(x, y, z, CableBusTextures.PartMonitorSidesStatusLights.getIcon(), ForgeDirection.UP, renderer);
            rh.renderFace(x, y, z, CableBusTextures.PartMonitorSidesStatusLights.getIcon(), ForgeDirection.DOWN, renderer);
        }
    }

    @Override
    public void getBoxes(IPartCollisionHelper bch) {
        bch.addBox(2.0, 2.0, 14.0, 14.0, 14.0, 16.0);
        bch.addBox(4.0, 4.0, 13.0, 12.0, 12.0, 14.0);
    }

    @Override
    public boolean isActive() {
        if (this.notLightSource) {
            return (this.clientFlags & (this.CHANNEL_FLAG | this.POWERED_FLAG)) == (this.CHANNEL_FLAG | this.POWERED_FLAG);
        }
        return this.isPowered();
    }
}

