/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.reporting;

import appeng.client.texture.CableBusTextures;
import appeng.core.sync.GuiBridge;
import appeng.parts.reporting.PartTerminal;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.tile.inventory.InvOperation;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class PartCraftingTerminal
extends PartTerminal {
    final AppEngInternalInventory craftingGrid = new AppEngInternalInventory(this, 9);

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        this.craftingGrid.writeToNBT(data, "craftingGrid");
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.craftingGrid.readFromNBT(data, "craftingGrid");
    }

    @Override
    public void getDrops(List<ItemStack> drops, boolean wrenched) {
        super.getDrops(drops, wrenched);
        for (ItemStack is : this.craftingGrid) {
            if (is == null) continue;
            drops.add(is);
        }
    }

    public PartCraftingTerminal(ItemStack is) {
        super(PartCraftingTerminal.class, is);
        this.frontBright = CableBusTextures.PartCraftingTerm_Bright;
        this.frontColored = CableBusTextures.PartCraftingTerm_Colored;
        this.frontDark = CableBusTextures.PartCraftingTerm_Dark;
    }

    @Override
    public GuiBridge getGui(EntityPlayer p) {
        int x = (int)p.field_70165_t;
        int y = (int)p.field_70163_u;
        int z = (int)p.field_70161_v;
        if (this.getHost().getTile() != null) {
            x = this.tile.field_145851_c;
            y = this.tile.field_145848_d;
            z = this.tile.field_145849_e;
        }
        if (GuiBridge.GUI_CRAFTING_TERMINAL.hasPermissions(this.getHost().getTile(), x, y, z, this.side, p)) {
            return GuiBridge.GUI_CRAFTING_TERMINAL;
        }
        return GuiBridge.GUI_ME;
    }

    @Override
    public void onChangeInventory(IInventory inv, int slot, InvOperation mc, ItemStack removedStack, ItemStack newStack) {
        this.host.markForSave();
    }

    @Override
    public IInventory getInventoryByName(String name) {
        if (name.equals("crafting")) {
            return this.craftingGrid;
        }
        return super.getInventoryByName(name);
    }
}

