/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.misc;

import appeng.api.networking.IGridNode;
import appeng.api.parts.BusSupport;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartHost;
import appeng.api.parts.IPartRenderHelper;
import appeng.api.parts.ISimplifiedBundle;
import appeng.api.parts.PartItemStack;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.List;
import java.util.Random;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class PartCableAnchor
implements IPart {
    protected ISimplifiedBundle renderCache = null;
    ItemStack is = null;
    IPartHost host = null;
    ForgeDirection mySide = ForgeDirection.UP;

    public PartCableAnchor(ItemStack is) {
        this.is = is;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderStatic(int x, int y, int z, IPartRenderHelper rh, RenderBlocks renderer) {
        this.renderCache = rh.useSimplifiedRendering(x, y, z, this, this.renderCache);
        IIcon myIcon = this.is.func_77954_c();
        rh.setTexture(myIcon);
        if (this.host != null && this.host.getFacadeContainer().getFacade(this.mySide) != null) {
            rh.setBounds(7.0f, 7.0f, 10.0f, 9.0f, 9.0f, 14.0f);
        } else {
            rh.setBounds(7.0f, 7.0f, 10.0f, 9.0f, 9.0f, 16.0f);
        }
        rh.renderBlock(x, y, z, renderer);
        rh.setTexture(null);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void randomDisplayTick(World world, int x, int y, int z, Random r) {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderInventory(IPartRenderHelper instance, RenderBlocks renderer) {
        instance.setTexture(this.is.func_77954_c());
        instance.setBounds(7.0f, 7.0f, 4.0f, 9.0f, 9.0f, 14.0f);
        instance.renderInventoryBox(renderer);
        instance.setTexture(null);
    }

    @Override
    public void getBoxes(IPartCollisionHelper bch) {
        if (this.host != null && this.host.getFacadeContainer().getFacade(this.mySide) != null) {
            bch.addBox(7.0, 7.0, 10.0, 9.0, 9.0, 14.0);
        } else {
            bch.addBox(7.0, 7.0, 10.0, 9.0, 9.0, 16.0);
        }
    }

    @Override
    public ItemStack getItemStack(PartItemStack wrenched) {
        return this.is;
    }

    @Override
    public boolean requireDynamicRender() {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderDynamic(double x, double y, double z, IPartRenderHelper rh, RenderBlocks renderer) {
    }

    @Override
    public boolean isSolid() {
        return false;
    }

    @Override
    public boolean canConnectRedstone() {
        return false;
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
    }

    @Override
    public int getLightLevel() {
        return 0;
    }

    @Override
    public void onNeighborChanged() {
    }

    @Override
    public int isProvidingStrongPower() {
        return 0;
    }

    @Override
    public int isProvidingWeakPower() {
        return 0;
    }

    @Override
    public void writeToStream(ByteBuf data) throws IOException {
    }

    @Override
    public boolean readFromStream(ByteBuf data) throws IOException {
        return false;
    }

    @Override
    public IGridNode getGridNode() {
        return null;
    }

    @Override
    public void onEntityCollision(Entity entity) {
    }

    @Override
    public void removeFromWorld() {
    }

    @Override
    public void addToWorld() {
    }

    @Override
    public IGridNode getExternalFacingNode() {
        return null;
    }

    @Override
    public void setPartHostInfo(ForgeDirection side, IPartHost host, TileEntity tile) {
        this.host = host;
        this.mySide = side;
    }

    @Override
    public boolean onActivate(EntityPlayer player, Vec3 pos) {
        return false;
    }

    @Override
    public void getDrops(List<ItemStack> drops, boolean wrenched) {
    }

    @Override
    public int cableConnectionRenderTo() {
        return 0;
    }

    @Override
    public boolean isLadder(EntityLivingBase entity) {
        return this.mySide.offsetY == 0 && (entity.field_70123_F || !entity.field_70122_E);
    }

    @Override
    public boolean onShiftActivate(EntityPlayer player, Vec3 pos) {
        return false;
    }

    @Override
    public void onPlacement(EntityPlayer player, ItemStack held, ForgeDirection side) {
    }

    @Override
    public boolean canBePlacedOn(BusSupport what) {
        return what == BusSupport.CABLE || what == BusSupport.DENSE_CABLE;
    }

    @Override
    public IIcon getBreakingTexture() {
        return null;
    }
}

