/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.automation;

import appeng.api.config.Upgrades;
import appeng.api.implementations.items.IUpgradeModule;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.tile.inventory.IAEAppEngInventory;
import appeng.tile.inventory.InvOperation;
import appeng.util.Platform;
import net.minecraft.block.Block;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class UpgradeInventory
extends AppEngInternalInventory
implements IAEAppEngInventory {
    private final Object itemOrBlock;
    private final IAEAppEngInventory parent;
    private boolean cached = false;
    private int FuzzyUpgrades = 0;
    private int SpeedUpgrades = 0;
    private int RedstoneUpgrades = 0;
    private int CapacityUpgrades = 0;
    private int InverterUpgrades = 0;
    private int CraftingUpgrades = 0;

    public UpgradeInventory(Object itemOrBlock, IAEAppEngInventory _te, int s) {
        super(null, s);
        this.te = this;
        this.parent = _te;
        this.itemOrBlock = itemOrBlock;
    }

    @Override
    protected boolean eventsEnabled() {
        return true;
    }

    @Override
    public boolean func_94041_b(int i, ItemStack itemstack) {
        Upgrades u;
        if (itemstack == null) {
            return false;
        }
        Item it = itemstack.func_77973_b();
        if (it instanceof IUpgradeModule && (u = ((IUpgradeModule)it).getType(itemstack)) != null) {
            return this.getInstalledUpgrades(u) < this.getMaxInstalled(u);
        }
        return false;
    }

    public int getMaxInstalled(Upgrades u) {
        Integer max = null;
        for (ItemStack is : u.getSupported().keySet()) {
            if (is.func_77973_b() == this.itemOrBlock) {
                max = u.getSupported().get(is);
                break;
            }
            if (is.func_77973_b() instanceof ItemBlock && Block.func_149634_a((Item)is.func_77973_b()) == this.itemOrBlock) {
                max = u.getSupported().get(is);
                break;
            }
            if (!(this.itemOrBlock instanceof ItemStack) || !Platform.isSameItem((ItemStack)this.itemOrBlock, is)) continue;
            max = u.getSupported().get(is);
            break;
        }
        if (max == null) {
            return 0;
        }
        return max;
    }

    @Override
    public int func_70297_j_() {
        return 1;
    }

    private void updateUpgradeInfo() {
        this.cached = true;
        this.CraftingUpgrades = 0;
        this.FuzzyUpgrades = 0;
        this.SpeedUpgrades = 0;
        this.RedstoneUpgrades = 0;
        this.CapacityUpgrades = 0;
        this.InverterUpgrades = 0;
        for (ItemStack is : this) {
            if (is == null || is.func_77973_b() == null || !(is.func_77973_b() instanceof IUpgradeModule)) continue;
            Upgrades myUpgrade = ((IUpgradeModule)is.func_77973_b()).getType(is);
            switch (myUpgrade) {
                case CAPACITY: {
                    ++this.CapacityUpgrades;
                    break;
                }
                case FUZZY: {
                    ++this.FuzzyUpgrades;
                    break;
                }
                case REDSTONE: {
                    ++this.RedstoneUpgrades;
                    break;
                }
                case SPEED: {
                    ++this.SpeedUpgrades;
                    break;
                }
                case INVERTER: {
                    ++this.InverterUpgrades;
                    break;
                }
                case CRAFTING: {
                    ++this.CraftingUpgrades;
                    break;
                }
            }
        }
        this.CapacityUpgrades = Math.min(this.CapacityUpgrades, this.getMaxInstalled(Upgrades.CAPACITY));
        this.FuzzyUpgrades = Math.min(this.FuzzyUpgrades, this.getMaxInstalled(Upgrades.FUZZY));
        this.RedstoneUpgrades = Math.min(this.RedstoneUpgrades, this.getMaxInstalled(Upgrades.REDSTONE));
        this.SpeedUpgrades = Math.min(this.SpeedUpgrades, this.getMaxInstalled(Upgrades.SPEED));
        this.InverterUpgrades = Math.min(this.InverterUpgrades, this.getMaxInstalled(Upgrades.INVERTER));
        this.CraftingUpgrades = Math.min(this.CraftingUpgrades, this.getMaxInstalled(Upgrades.CRAFTING));
    }

    public int getInstalledUpgrades(Upgrades u) {
        if (!this.cached) {
            this.updateUpgradeInfo();
        }
        switch (u) {
            case CAPACITY: {
                return this.CapacityUpgrades;
            }
            case FUZZY: {
                return this.FuzzyUpgrades;
            }
            case REDSTONE: {
                return this.RedstoneUpgrades;
            }
            case SPEED: {
                return this.SpeedUpgrades;
            }
            case INVERTER: {
                return this.InverterUpgrades;
            }
            case CRAFTING: {
                return this.CraftingUpgrades;
            }
        }
        return 0;
    }

    @Override
    public void readFromNBT(NBTTagCompound target) {
        super.readFromNBT(target);
        this.updateUpgradeInfo();
    }

    @Override
    public void onChangeInventory(IInventory inv, int slot, InvOperation mc, ItemStack removedStack, ItemStack newStack) {
        this.cached = false;
        if (this.parent != null && Platform.isServer()) {
            this.parent.onChangeInventory(inv, slot, mc, removedStack, newStack);
        }
    }

    @Override
    public void saveChanges() {
        this.parent.saveChanges();
    }
}

