/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts;

import appeng.api.AEApi;
import appeng.api.config.YesNo;
import appeng.api.exceptions.FailedConnection;
import appeng.api.implementations.parts.IPartCable;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.parts.IFacadeContainer;
import appeng.api.parts.IFacadePart;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartHost;
import appeng.api.parts.IPartItem;
import appeng.api.parts.LayerFlags;
import appeng.api.parts.PartItemStack;
import appeng.api.parts.SelectedPart;
import appeng.api.util.AECableType;
import appeng.api.util.AEColor;
import appeng.api.util.DimensionalCoord;
import appeng.client.render.CableRenderHelper;
import appeng.core.AELog;
import appeng.core.AppEng;
import appeng.facade.FacadeContainer;
import appeng.helpers.AEMultiTile;
import appeng.integration.IntegrationType;
import appeng.integration.abstraction.ICLApi;
import appeng.me.GridConnection;
import appeng.parts.BusCollisionHelper;
import appeng.parts.CableBusStorage;
import appeng.parts.ICableBusContainer;
import appeng.parts.PartPlacement;
import appeng.util.Platform;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class CableBusContainer
extends CableBusStorage
implements AEMultiTile,
ICableBusContainer {
    private final EnumSet<LayerFlags> myLayerFlags = EnumSet.noneOf(LayerFlags.class);
    public YesNo hasRedstone = YesNo.UNDECIDED;
    public IPartHost tcb;
    boolean inWorld = false;
    public boolean requiresDynamicRender = false;
    private static final ThreadLocal<Boolean> isLoading = new ThreadLocal();

    @Override
    public boolean isInWorld() {
        return this.inWorld;
    }

    public void setHost(IPartHost host) {
        this.tcb.clearContainer();
        this.tcb = host;
    }

    public CableBusContainer(IPartHost host) {
        this.tcb = host;
    }

    @Override
    public IPart getPart(ForgeDirection side) {
        if (side == ForgeDirection.UNKNOWN) {
            return this.getCenter();
        }
        return this.getSide(side);
    }

    public void rotateLeft() {
        IPart[] newSides = new IPart[6];
        newSides[ForgeDirection.UP.ordinal()] = this.getSide(ForgeDirection.UP);
        newSides[ForgeDirection.DOWN.ordinal()] = this.getSide(ForgeDirection.DOWN);
        newSides[ForgeDirection.EAST.ordinal()] = this.getSide(ForgeDirection.NORTH);
        newSides[ForgeDirection.SOUTH.ordinal()] = this.getSide(ForgeDirection.EAST);
        newSides[ForgeDirection.WEST.ordinal()] = this.getSide(ForgeDirection.SOUTH);
        newSides[ForgeDirection.NORTH.ordinal()] = this.getSide(ForgeDirection.WEST);
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            this.setSide(dir, newSides[dir.ordinal()]);
        }
        this.getFacadeContainer().rotateLeft();
    }

    public void updateDynamicRender() {
        this.requiresDynamicRender = false;
        for (ForgeDirection s : ForgeDirection.VALID_DIRECTIONS) {
            IPart p = this.getPart(s);
            if (p == null) continue;
            this.requiresDynamicRender = this.requiresDynamicRender || p.requireDynamicRender();
        }
    }

    @Override
    public void removePart(ForgeDirection side, boolean suppressUpdate) {
        if (side == ForgeDirection.UNKNOWN) {
            if (this.getCenter() != null) {
                this.getCenter().removeFromWorld();
            }
            this.setCenter(null);
        } else {
            if (this.getSide(side) != null) {
                this.getSide(side).removeFromWorld();
            }
            this.setSide(side, null);
        }
        if (!suppressUpdate) {
            this.updateDynamicRender();
            this.updateConnections();
            this.markForUpdate();
            this.markForSave();
            this.partChanged();
        }
    }

    public void updateConnections() {
        if (this.getCenter() != null) {
            EnumSet<ForgeDirection> sides = EnumSet.allOf(ForgeDirection.class);
            for (ForgeDirection s : ForgeDirection.VALID_DIRECTIONS) {
                if (this.getPart(s) == null && !this.isBlocked(s)) continue;
                sides.remove(s);
            }
            this.getCenter().setValidSides(sides);
            IGridNode n = this.getCenter().getGridNode();
            if (n != null) {
                n.updateState();
            }
        }
    }

    @Override
    public boolean canAddPart(ItemStack is, ForgeDirection side) {
        if (PartPlacement.isFacade(is, side) != null) {
            return true;
        }
        if (is.func_77973_b() instanceof IPartItem) {
            IPartItem bi = (IPartItem)is.func_77973_b();
            is = is.func_77946_l();
            is.field_77994_a = 1;
            IPart bp = bi.createPartFromItemStack(is);
            if (bp != null) {
                if (bp instanceof IPartCable) {
                    boolean canPlace = true;
                    for (ForgeDirection d : ForgeDirection.VALID_DIRECTIONS) {
                        if (this.getPart(d) == null || this.getPart(d).canBePlacedOn(((IPartCable)bp).supportsBuses())) continue;
                        canPlace = false;
                    }
                    if (!canPlace) {
                        return false;
                    }
                    return this.getPart(ForgeDirection.UNKNOWN) == null;
                }
                if (!(bp instanceof IPartCable) && side != ForgeDirection.UNKNOWN) {
                    IPart cable = this.getPart(ForgeDirection.UNKNOWN);
                    if (cable != null && !bp.canBePlacedOn(((IPartCable)cable).supportsBuses())) {
                        return false;
                    }
                    return this.getPart(side) == null;
                }
            }
        }
        return false;
    }

    @Override
    public ForgeDirection addPart(ItemStack is, ForgeDirection side, EntityPlayer player) {
        if (this.canAddPart(is, side) && is.func_77973_b() instanceof IPartItem) {
            IPartItem bi = (IPartItem)is.func_77973_b();
            is = is.func_77946_l();
            is.field_77994_a = 1;
            IPart bp = bi.createPartFromItemStack(is);
            if (bp instanceof IPartCable) {
                IGridNode cn;
                boolean canPlace = true;
                for (ForgeDirection d : ForgeDirection.VALID_DIRECTIONS) {
                    if (this.getPart(d) == null || this.getPart(d).canBePlacedOn(((IPartCable)bp).supportsBuses())) continue;
                    canPlace = false;
                }
                if (!canPlace) {
                    return null;
                }
                if (this.getPart(ForgeDirection.UNKNOWN) != null) {
                    return null;
                }
                this.setCenter((IPartCable)bp);
                bp.setPartHostInfo(ForgeDirection.UNKNOWN, this, this.tcb.getTile());
                if (player != null) {
                    bp.onPlacement(player, is, side);
                }
                if (this.inWorld) {
                    bp.addToWorld();
                }
                if ((cn = this.getCenter().getGridNode()) != null) {
                    for (ForgeDirection ins : ForgeDirection.VALID_DIRECTIONS) {
                        IGridNode sn;
                        IPart sbp = this.getPart(ins);
                        if (sbp == null || (sn = sbp.getGridNode()) == null) continue;
                        try {
                            new GridConnection(cn, sn, ForgeDirection.UNKNOWN);
                        }
                        catch (FailedConnection e) {
                            bp.removeFromWorld();
                            this.setCenter(null);
                            return null;
                        }
                    }
                }
                this.updateConnections();
                this.markForUpdate();
                this.markForSave();
                this.partChanged();
                return ForgeDirection.UNKNOWN;
            }
            if (bp != null && !(bp instanceof IPartCable) && side != ForgeDirection.UNKNOWN) {
                IPart cable = this.getPart(ForgeDirection.UNKNOWN);
                if (cable != null && !bp.canBePlacedOn(((IPartCable)cable).supportsBuses())) {
                    return null;
                }
                this.setSide(side, bp);
                bp.setPartHostInfo(side, this, this.getTile());
                if (player != null) {
                    bp.onPlacement(player, is, side);
                }
                if (this.inWorld) {
                    bp.addToWorld();
                }
                if (this.getCenter() != null) {
                    IGridNode cn = this.getCenter().getGridNode();
                    IGridNode sn = bp.getGridNode();
                    if (cn != null && sn != null) {
                        try {
                            new GridConnection(cn, sn, ForgeDirection.UNKNOWN);
                        }
                        catch (FailedConnection e) {
                            bp.removeFromWorld();
                            this.setSide(side, null);
                            return null;
                        }
                    }
                }
                this.updateDynamicRender();
                this.updateConnections();
                this.markForUpdate();
                this.markForSave();
                this.partChanged();
                return side;
            }
        }
        return null;
    }

    public static boolean isLoading() {
        Boolean is = isLoading.get();
        return is != null && is != false;
    }

    public void addToWorld() {
        if (this.inWorld) {
            return;
        }
        this.inWorld = true;
        isLoading.set(true);
        TileEntity te = this.getTile();
        for (int x = 6; x >= 0; --x) {
            IGridNode cn;
            IPart center;
            IGridNode sn;
            ForgeDirection s = ForgeDirection.getOrientation((int)x);
            IPart part = this.getPart(s);
            if (part == null) continue;
            part.setPartHostInfo(s, this, te);
            part.addToWorld();
            if (s == ForgeDirection.UNKNOWN || (sn = part.getGridNode()) == null || (center = this.getPart(ForgeDirection.UNKNOWN)) == null || (cn = center.getGridNode()) == null) continue;
            try {
                AEApi.instance().createGridConnection(cn, sn);
                continue;
            }
            catch (FailedConnection e) {
                // empty catch block
            }
        }
        this.partChanged();
        isLoading.set(false);
    }

    public void removeFromWorld() {
        if (!this.inWorld) {
            return;
        }
        this.inWorld = false;
        for (ForgeDirection s : ForgeDirection.values()) {
            IPart part = this.getPart(s);
            if (part == null) continue;
            part.removeFromWorld();
        }
        this.partChanged();
    }

    @Override
    public boolean canConnectRedstone(EnumSet<ForgeDirection> enumSet) {
        for (ForgeDirection dir : enumSet) {
            IPart part = this.getPart(dir);
            if (part == null || !part.canConnectRedstone()) continue;
            return true;
        }
        return false;
    }

    @Override
    public IGridNode getGridNode(ForgeDirection side) {
        IGridNode n;
        IPart part = this.getPart(side);
        if (part != null && (n = part.getExternalFacingNode()) != null) {
            return n;
        }
        if (this.getCenter() != null) {
            return this.getCenter().getGridNode();
        }
        return null;
    }

    public Iterable<AxisAlignedBB> getSelectedBoundingBoxesFromPool(boolean ignoreCableConnections, boolean includeFacades, Entity e, boolean visual) {
        LinkedList<AxisAlignedBB> boxes = new LinkedList<AxisAlignedBB>();
        IFacadeContainer fc = this.getFacadeContainer();
        for (ForgeDirection s : ForgeDirection.values()) {
            IFacadePart fp;
            BusCollisionHelper bch = new BusCollisionHelper(boxes, s, e, visual);
            IPart part = this.getPart(s);
            if (part != null) {
                if (ignoreCableConnections && part instanceof IPartCable) {
                    bch.addBox(6.0, 6.0, 6.0, 10.0, 10.0, 10.0);
                } else {
                    part.getBoxes(bch);
                }
            }
            if (!AEApi.instance().partHelper().getCableRenderMode().opaqueFacades && visual || !includeFacades || s == null || s == ForgeDirection.UNKNOWN || (fp = fc.getFacade(s)) == null) continue;
            fp.getBoxes(bch, e);
        }
        return boxes;
    }

    @Override
    public void onEntityCollision(Entity entity) {
        for (ForgeDirection s : ForgeDirection.values()) {
            IPart part = this.getPart(s);
            if (part == null) continue;
            part.onEntityCollision(entity);
        }
    }

    @Override
    public boolean isEmpty() {
        IFacadeContainer fc = this.getFacadeContainer();
        for (ForgeDirection s : ForgeDirection.values()) {
            IFacadePart fp;
            IPart part = this.getPart(s);
            if (part != null) {
                return false;
            }
            if (s == ForgeDirection.UNKNOWN || (fp = fc.getFacade(s)) == null) continue;
            return false;
        }
        return true;
    }

    @Override
    public void onNeighborChanged() {
        this.hasRedstone = YesNo.UNDECIDED;
        for (ForgeDirection s : ForgeDirection.values()) {
            IPart part = this.getPart(s);
            if (part == null) continue;
            part.onNeighborChanged();
        }
    }

    private void updateRedstone() {
        TileEntity te = this.getTile();
        this.hasRedstone = te.func_145831_w().func_72864_z(te.field_145851_c, te.field_145848_d, te.field_145849_e) ? YesNo.YES : YesNo.NO;
    }

    @Override
    public boolean isSolidOnSide(ForgeDirection side) {
        if (side == null || side == ForgeDirection.UNKNOWN) {
            return false;
        }
        IFacadePart fp = this.getFacadeContainer().getFacade(side);
        if (fp != null) {
            return true;
        }
        IPart part = this.getPart(side);
        return part != null && part.isSolid();
    }

    @Override
    public int isProvidingWeakPower(ForgeDirection side) {
        IPart part = this.getPart(side);
        return part != null ? part.isProvidingWeakPower() : 0;
    }

    @Override
    public int isProvidingStrongPower(ForgeDirection side) {
        IPart part = this.getPart(side);
        return part != null ? part.isProvidingStrongPower() : 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void renderStatic(double x, double y, double z) {
        CableRenderHelper.getInstance().renderStatic(this, this.getFacadeContainer());
    }

    @SideOnly(value=Side.CLIENT)
    public void renderDynamic(double x, double y, double z) {
        CableRenderHelper.getInstance().renderDynamic(this, x, y, z);
    }

    public void writeToStream(ByteBuf data) throws IOException {
        int x;
        int sides = 0;
        for (x = 0; x < 7; ++x) {
            IPart p = this.getPart(ForgeDirection.getOrientation((int)x));
            if (p == null) continue;
            sides |= 1 << x;
        }
        data.writeByte((int)((byte)sides));
        for (x = 0; x < 7; ++x) {
            ItemStack is = null;
            IPart p = this.getPart(ForgeDirection.getOrientation((int)x));
            if (p == null) continue;
            is = p.getItemStack(PartItemStack.Network);
            data.writeShort(Item.func_150891_b((Item)is.func_77973_b()));
            data.writeShort(is.func_77960_j());
            p.writeToStream(data);
        }
        this.getFacadeContainer().writeToStream(data);
    }

    public boolean readFromStream(ByteBuf data) throws IOException {
        byte sides = data.readByte();
        boolean updateBlock = false;
        for (int x = 0; x < 7; ++x) {
            ForgeDirection side = ForgeDirection.getOrientation((int)x);
            if ((sides & 1 << x) == 1 << x) {
                ItemStack current;
                IPart p = this.getPart(side);
                short itemID = data.readShort();
                short dmgValue = data.readShort();
                Item myItem = Item.func_150899_d((int)itemID);
                ItemStack itemStack = current = p != null ? p.getItemStack(PartItemStack.Network) : null;
                if (current != null && current.func_77973_b() == myItem && current.func_77960_j() == dmgValue) {
                    if (!p.readFromStream(data)) continue;
                    updateBlock = true;
                    continue;
                }
                this.removePart(side, false);
                side = this.addPart(new ItemStack(myItem, 1, (int)dmgValue), side, null);
                if (side != null) {
                    p = this.getPart(side);
                    p.readFromStream(data);
                    continue;
                }
                throw new RuntimeException("Invalid Stream For CableBus Container.");
            }
            if (this.getPart(side) == null) continue;
            this.removePart(side, false);
        }
        if (this.getFacadeContainer().readFromStream(data)) {
            return true;
        }
        return updateBlock;
    }

    ForgeDirection getSide(IPart part) {
        if (this.getCenter() == part) {
            return ForgeDirection.UNKNOWN;
        }
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            if (this.getSide(side) != part) continue;
            return side;
        }
        throw new RuntimeException("Uhh Bad Part on Side.");
    }

    public void writeToNBT(NBTTagCompound data) {
        data.func_74768_a("hasRedstone", this.hasRedstone.ordinal());
        IFacadeContainer fc = this.getFacadeContainer();
        for (ForgeDirection s : ForgeDirection.values()) {
            fc.writeToNBT(data);
            IPart part = this.getPart(s);
            if (part == null) continue;
            NBTTagCompound def = new NBTTagCompound();
            part.getItemStack(PartItemStack.World).func_77955_b(def);
            NBTTagCompound extra = new NBTTagCompound();
            part.writeToNBT(extra);
            data.func_74782_a("def:" + this.getSide(part).ordinal(), (NBTBase)def);
            data.func_74782_a("extra:" + this.getSide(part).ordinal(), (NBTBase)extra);
        }
    }

    public void readFromNBT(NBTTagCompound data) {
        if (data.func_74764_b("hasRedstone")) {
            this.hasRedstone = YesNo.values()[data.func_74762_e("hasRedstone")];
        }
        for (int x = 0; x < 7; ++x) {
            ForgeDirection side = ForgeDirection.getOrientation((int)x);
            NBTTagCompound def = data.func_74775_l("def:" + side.ordinal());
            NBTTagCompound extra = data.func_74775_l("extra:" + side.ordinal());
            if (def != null && extra != null) {
                ItemStack current;
                IPart p = this.getPart(side);
                ItemStack iss = ItemStack.func_77949_a((NBTTagCompound)def);
                if (iss == null) continue;
                ItemStack itemStack = current = p == null ? null : p.getItemStack(PartItemStack.World);
                if (Platform.isSameItemType(iss, current)) {
                    p.readFromNBT(extra);
                    continue;
                }
                this.removePart(side, true);
                side = this.addPart(iss, side, null);
                if (side != null) {
                    p = this.getPart(side);
                    p.readFromNBT(extra);
                    continue;
                }
                AELog.warning("Invalid NBT For CableBus Container: " + iss.func_77973_b().getClass().getName() + " is not a valid part; it was ignored.", new Object[0]);
                continue;
            }
            this.removePart(side, false);
        }
        this.getFacadeContainer().readFromNBT(data);
    }

    public List getDrops(List drops) {
        for (ForgeDirection s : ForgeDirection.values()) {
            IFacadePart fp;
            IPart part = this.getPart(s);
            if (part != null) {
                drops.add(part.getItemStack(PartItemStack.Break));
                part.getDrops(drops, false);
            }
            if (s == ForgeDirection.UNKNOWN || (fp = this.getFacadeContainer().getFacade(s)) == null) continue;
            drops.add(fp.getItemStack());
        }
        return drops;
    }

    public List getNoDrops(List drops) {
        for (ForgeDirection s : ForgeDirection.values()) {
            IPart part = this.getPart(s);
            if (part == null) continue;
            part.getDrops(drops, false);
        }
        return drops;
    }

    @Override
    public void markForUpdate() {
        this.tcb.markForUpdate();
    }

    @Override
    public DimensionalCoord getLocation() {
        return this.tcb.getLocation();
    }

    @Override
    public TileEntity getTile() {
        return this.tcb.getTile();
    }

    @Override
    public AECableType getCableConnectionType(ForgeDirection dir) {
        AECableType t;
        IPart part = this.getPart(dir);
        if (part != null && part instanceof IGridHost && (t = ((IGridHost)((Object)part)).getCableConnectionType(dir)) != null && t != AECableType.NONE) {
            return t;
        }
        if (this.getCenter() != null) {
            IPartCable c = this.getCenter();
            return c.getCableConnectionType();
        }
        return AECableType.NONE;
    }

    @Override
    public AEColor getColor() {
        if (this.getCenter() != null) {
            IPartCable c = this.getCenter();
            return c.getCableColor();
        }
        return AEColor.Transparent;
    }

    @Override
    public IFacadeContainer getFacadeContainer() {
        return new FacadeContainer(this);
    }

    @Override
    public void clearContainer() {
        throw new RuntimeException("Now that is silly!");
    }

    @Override
    public boolean isBlocked(ForgeDirection side) {
        return this.tcb.isBlocked(side);
    }

    @Override
    public int getLightValue() {
        int light = 0;
        for (ForgeDirection d : ForgeDirection.values()) {
            IPart p = this.getPart(d);
            if (p == null) continue;
            light = Math.max(p.getLightLevel(), light);
        }
        if (light > 0 && AppEng.instance.isIntegrationEnabled(IntegrationType.CLApi)) {
            return ((ICLApi)AppEng.instance.getIntegration(IntegrationType.CLApi)).colorLight(this.getColor(), light);
        }
        return light;
    }

    @Override
    public boolean recolourBlock(ForgeDirection side, AEColor colour, EntityPlayer who) {
        IPart cable = this.getPart(ForgeDirection.UNKNOWN);
        if (cable != null) {
            IPartCable pc = (IPartCable)cable;
            return pc.changeColor(colour, who);
        }
        return false;
    }

    @Override
    public boolean activate(EntityPlayer player, Vec3 pos) {
        SelectedPart p = this.selectPart(pos);
        if (p != null && p.part != null) {
            return p.part.onActivate(player, pos);
        }
        return false;
    }

    @Override
    public SelectedPart selectPart(Vec3 pos) {
        for (ForgeDirection side : ForgeDirection.values()) {
            IPart p = this.getPart(side);
            if (p == null) continue;
            LinkedList<AxisAlignedBB> boxes = new LinkedList<AxisAlignedBB>();
            BusCollisionHelper bch = new BusCollisionHelper(boxes, side, null, true);
            p.getBoxes(bch);
            for (AxisAlignedBB bb : boxes) {
                if (!(bb = bb.func_72314_b(0.002, 0.002, 0.002)).func_72318_a(pos)) continue;
                return new SelectedPart(p, side);
            }
        }
        if (AEApi.instance().partHelper().getCableRenderMode().opaqueFacades) {
            IFacadeContainer fc = this.getFacadeContainer();
            for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
                IFacadePart p = fc.getFacade(side);
                if (p == null) continue;
                LinkedList<AxisAlignedBB> boxes = new LinkedList<AxisAlignedBB>();
                BusCollisionHelper bch = new BusCollisionHelper(boxes, side, null, true);
                p.getBoxes(bch, null);
                for (AxisAlignedBB bb : boxes) {
                    if (!(bb = bb.func_72314_b(0.01, 0.01, 0.01)).func_72318_a(pos)) continue;
                    return new SelectedPart(p, side);
                }
            }
        }
        return new SelectedPart();
    }

    @Override
    public void partChanged() {
        if (this.getCenter() == null) {
            LinkedList<ItemStack> facades = new LinkedList<ItemStack>();
            IFacadeContainer fc = this.getFacadeContainer();
            for (ForgeDirection d : ForgeDirection.VALID_DIRECTIONS) {
                IFacadePart fp = fc.getFacade(d);
                if (fp == null) continue;
                facades.add(fp.getItemStack());
                fc.removeFacade(this.tcb, d);
            }
            if (!facades.isEmpty()) {
                TileEntity te = this.tcb.getTile();
                Platform.spawnDrops(te.func_145831_w(), te.field_145851_c, te.field_145848_d, te.field_145849_e, facades);
            }
        }
        this.tcb.partChanged();
    }

    @Override
    public void markForSave() {
        this.tcb.markForSave();
    }

    @Override
    public void randomDisplayTick(World world, int x, int y, int z, Random r) {
        for (ForgeDirection side : ForgeDirection.values()) {
            IPart p = this.getPart(side);
            if (p == null) continue;
            p.randomDisplayTick(world, x, y, z, r);
        }
    }

    @Override
    public boolean hasRedstone(ForgeDirection side) {
        if (this.hasRedstone == YesNo.UNDECIDED) {
            this.updateRedstone();
        }
        return this.hasRedstone == YesNo.YES;
    }

    @Override
    public boolean isLadder(EntityLivingBase entity) {
        for (ForgeDirection side : ForgeDirection.values()) {
            IPart p = this.getPart(side);
            if (p == null || !p.isLadder(entity)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void securityBreak() {
        for (ForgeDirection d : ForgeDirection.values()) {
            IPart p = this.getPart(d);
            if (p == null || !(p instanceof IGridHost)) continue;
            ((IGridHost)((Object)p)).securityBreak();
        }
    }

    @Override
    public Set<LayerFlags> getLayerFlags() {
        return this.myLayerFlags;
    }

    @Override
    public void cleanup() {
        this.tcb.cleanup();
    }

    @Override
    public void notifyNeighbors() {
        this.tcb.notifyNeighbors();
    }
}

