/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.storage;

import appeng.api.AEApi;
import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.config.SecurityPermissions;
import appeng.api.implementations.items.IBiometricCard;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.PlayerSource;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IItemList;
import appeng.me.GridAccessException;
import appeng.tile.misc.TileSecurity;
import com.mojang.authlib.GameProfile;

public class SecurityInventory
implements IMEInventoryHandler<IAEItemStack> {
    final TileSecurity securityTile;
    public final IItemList<IAEItemStack> storedItems = AEApi.instance().storage().createItemList();

    public SecurityInventory(TileSecurity ts) {
        this.securityTile = ts;
    }

    private boolean hasPermission(BaseActionSource src) {
        if (src.isPlayer()) {
            try {
                return this.securityTile.getProxy().getSecurity().hasPermission(((PlayerSource)src).player, SecurityPermissions.SECURITY);
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public IAEItemStack injectItems(IAEItemStack input, Actionable type, BaseActionSource src) {
        if (this.hasPermission(src) && AEApi.instance().items().itemBiometricCard.sameAsStack(input.getItemStack()) && this.canAccept(input)) {
            if (type == Actionable.SIMULATE) {
                return null;
            }
            this.storedItems.add(input);
            this.securityTile.inventoryChanged();
            return null;
        }
        return input;
    }

    @Override
    public IAEItemStack extractItems(IAEItemStack request, Actionable mode, BaseActionSource src) {
        IAEItemStack target;
        if (this.hasPermission(src) && (target = this.storedItems.findPrecise(request)) != null) {
            IAEItemStack output = target.copy();
            if (mode == Actionable.SIMULATE) {
                return output;
            }
            target.setStackSize(0L);
            this.securityTile.inventoryChanged();
            return output;
        }
        return null;
    }

    @Override
    public IItemList<IAEItemStack> getAvailableItems(IItemList out) {
        for (IAEItemStack ais : this.storedItems) {
            out.add(ais);
        }
        return out;
    }

    @Override
    public StorageChannel getChannel() {
        return StorageChannel.ITEMS;
    }

    @Override
    public AccessRestriction getAccess() {
        return AccessRestriction.READ_WRITE;
    }

    @Override
    public boolean isPrioritized(IAEItemStack input) {
        return false;
    }

    @Override
    public boolean canAccept(IAEItemStack input) {
        if (input.getItem() instanceof IBiometricCard) {
            IBiometricCard tbc = (IBiometricCard)input.getItem();
            GameProfile newUser = tbc.getProfile(input.getItemStack());
            int PlayerID = AEApi.instance().registries().players().getID(newUser);
            if (this.securityTile.getOwner() == PlayerID) {
                return false;
            }
            for (IAEItemStack ais : this.storedItems) {
                if (!ais.isMeaningful()) continue;
                GameProfile thisUser = tbc.getProfile(ais.getItemStack());
                if (thisUser == newUser) {
                    return false;
                }
                if (thisUser == null || !thisUser.equals((Object)newUser)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int getPriority() {
        return 0;
    }

    @Override
    public int getSlot() {
        return 0;
    }

    @Override
    public boolean validForPass(int i) {
        return true;
    }
}

