/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.cluster;

import appeng.api.util.WorldCoord;
import appeng.core.AELog;
import appeng.me.cluster.IAECluster;
import appeng.me.cluster.IAEMultiBlock;
import appeng.util.Platform;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class MBCalculator {
    private final IAEMultiBlock target;

    public MBCalculator(IAEMultiBlock t) {
        this.target = t;
    }

    public abstract boolean isValidTile(TileEntity var1);

    public abstract IAECluster createCluster(World var1, WorldCoord var2, WorldCoord var3);

    public abstract void updateTiles(IAECluster var1, World var2, WorldCoord var3, WorldCoord var4);

    public abstract void disconnect();

    public abstract boolean checkMultiblockScale(WorldCoord var1, WorldCoord var2);

    public boolean isValidTileAt(World w, int x, int y, int z) {
        return this.isValidTile(w.func_147438_o(x, y, z));
    }

    public void calculateMultiblock(World world, WorldCoord loc) {
        block14: {
            if (Platform.isClient()) {
                return;
            }
            try {
                WorldCoord min = loc.copy();
                WorldCoord max = loc.copy();
                while (this.isValidTileAt(world, min.x - 1, min.y, min.z)) {
                    --min.x;
                }
                while (this.isValidTileAt(world, min.x, min.y - 1, min.z)) {
                    --min.y;
                }
                while (this.isValidTileAt(world, min.x, min.y, min.z - 1)) {
                    --min.z;
                }
                while (this.isValidTileAt(world, max.x + 1, max.y, max.z)) {
                    ++max.x;
                }
                while (this.isValidTileAt(world, max.x, max.y + 1, max.z)) {
                    ++max.y;
                }
                while (this.isValidTileAt(world, max.x, max.y, max.z + 1)) {
                    ++max.z;
                }
                if (!this.checkMultiblockScale(min, max) || !this.verifyUnownedRegion(world, min, max)) break block14;
                IAECluster c = this.createCluster(world, min, max);
                try {
                    if (!this.verifyInternalStructure(world, min, max)) {
                        this.disconnect();
                        return;
                    }
                }
                catch (Exception err) {
                    this.disconnect();
                    return;
                }
                boolean updateGrid = false;
                IAECluster cluster = this.target.getCluster();
                if (cluster == null) {
                    this.updateTiles(c, world, min, max);
                    updateGrid = true;
                } else {
                    c = cluster;
                }
                c.updateStatus(updateGrid);
                return;
            }
            catch (Throwable err) {
                AELog.error(err);
            }
        }
        this.disconnect();
    }

    public abstract boolean verifyInternalStructure(World var1, WorldCoord var2, WorldCoord var3);

    public boolean verifyUnownedRegionInner(World w, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, ForgeDirection side) {
        switch (side) {
            case WEST: {
                maxX = --minX;
                break;
            }
            case EAST: {
                minX = ++maxX;
                break;
            }
            case DOWN: {
                maxY = --minY;
                break;
            }
            case NORTH: {
                minZ = ++maxZ;
                break;
            }
            case SOUTH: {
                maxZ = --minZ;
                break;
            }
            case UP: {
                minY = ++maxY;
                break;
            }
            case UNKNOWN: {
                return false;
            }
        }
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    TileEntity te = w.func_147438_o(x, y, z);
                    if (!this.isValidTile(te)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean verifyUnownedRegion(World w, WorldCoord min, WorldCoord max) {
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            if (!this.verifyUnownedRegionInner(w, min.x, min.y, min.z, max.x, max.y, max.z, side)) continue;
            return false;
        }
        return true;
    }
}

