/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.cache;

import appeng.api.networking.events.MENetworkStorageEvent;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.IMEMonitorHandlerReceiver;
import appeng.api.storage.MEMonitorHandler;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.me.cache.GridStorageCache;
import appeng.me.storage.ItemWatcher;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

public class NetworkMonitor<T extends IAEStack<T>>
extends MEMonitorHandler<T> {
    private final GridStorageCache myGridCache;
    private final StorageChannel myChannel;
    boolean sendEvent = false;
    public static final LinkedList depth = new LinkedList();

    public void forceUpdate() {
        this.hasChanged = true;
        Iterator i = this.getListeners();
        while (i.hasNext()) {
            Map.Entry o = i.next();
            IMEMonitorHandlerReceiver receiver = o.getKey();
            if (receiver.isValid(o.getValue())) {
                receiver.onListUpdate();
                continue;
            }
            i.remove();
        }
    }

    public NetworkMonitor(GridStorageCache cache, StorageChannel chan) {
        super(null, chan);
        this.myGridCache = cache;
        this.myChannel = chan;
    }

    @Override
    protected void postChangesToListeners(Iterable<T> changes, BaseActionSource src) {
        this.postChange(true, changes, src);
    }

    protected void postChange(boolean Add, Iterable<T> changes, BaseActionSource src) {
        if (depth.contains(this)) {
            return;
        }
        depth.push(this);
        this.sendEvent = true;
        this.notifyListenersOfChange(changes, src);
        IItemList<IAEStack> myStorageList = this.getStorageList();
        Iterator<T> i$ = changes.iterator();
        while (i$.hasNext()) {
            Collection<ItemWatcher> list;
            IAEStack changedItem;
            IAEStack difference = changedItem = (IAEStack)i$.next();
            if (!Add && changedItem != null) {
                difference = changedItem.copy();
                difference.setStackSize(-changedItem.getStackSize());
            }
            if (!this.myGridCache.interestManager.containsKey(changedItem) || (list = this.myGridCache.interestManager.get(changedItem)).isEmpty()) continue;
            IAEStack fullStack = myStorageList.findPrecise(changedItem);
            if (fullStack == null) {
                fullStack = changedItem.copy();
                fullStack.setStackSize(0L);
            }
            this.myGridCache.interestManager.enableTransactions();
            for (ItemWatcher iw : list) {
                iw.getHost().onStackChange(myStorageList, fullStack, difference, src, this.getChannel());
            }
            this.myGridCache.interestManager.disableTransactions();
        }
        Object last = depth.pop();
        if (last != this) {
            throw new RuntimeException("Invalid Access to Networked Storage API detected.");
        }
    }

    public void onTick() {
        if (this.sendEvent) {
            this.sendEvent = false;
            this.myGridCache.myGrid.postEvent(new MENetworkStorageEvent(this, this.myChannel));
        }
    }

    @Override
    protected IMEInventoryHandler getHandler() {
        switch (this.myChannel) {
            case ITEMS: {
                return this.myGridCache.getItemInventoryHandler();
            }
            case FLUIDS: {
                return this.myGridCache.getFluidInventoryHandler();
            }
        }
        return null;
    }
}

