/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.tools.powered.powersink;

import appeng.api.config.PowerUnits;
import appeng.items.tools.powered.powersink.AERootPoweredItem;
import appeng.transformer.annotations.integration;
import com.google.common.base.Optional;
import ic2.api.item.IElectricItemManager;
import ic2.api.item.ISpecialElectricItem;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

@integration.InterfaceList(value={@integration.Interface(iface="ic2.api.item.ISpecialElectricItem", iname="IC2"), @integration.Interface(iface="ic2.api.item.IElectricItemManager", iname="IC2")})
public class IC2
extends AERootPoweredItem
implements IElectricItemManager,
ISpecialElectricItem {
    public IC2(Class c, Optional<String> subName) {
        super(c, subName);
    }

    public double charge(ItemStack is, double amount, int tier, boolean ignoreTransferLimit, boolean simulate) {
        double addedAmt = amount;
        double limit = this.getTransferLimit(is);
        if (!ignoreTransferLimit && amount > limit) {
            addedAmt = limit;
        }
        return addedAmt - (double)((int)this.injectExternalPower(PowerUnits.EU, is, addedAmt, simulate));
    }

    public double discharge(ItemStack itemStack, double amount, int tier, boolean ignoreTransferLimit, boolean externally, boolean simulate) {
        return 0.0;
    }

    public double getCharge(ItemStack is) {
        return (int)PowerUnits.AE.convertTo(PowerUnits.EU, this.getAECurrentPower(is));
    }

    public boolean canUse(ItemStack is, double amount) {
        return this.getCharge(is) > amount;
    }

    public boolean use(ItemStack is, double amount, EntityLivingBase entity) {
        if (this.canUse(is, amount)) {
            this.extractAEPower(is, PowerUnits.EU.convertTo(PowerUnits.AE, amount));
            return true;
        }
        return false;
    }

    public void chargeFromArmor(ItemStack itemStack, EntityLivingBase entity) {
    }

    public String getToolTip(ItemStack itemStack) {
        return null;
    }

    public boolean canProvideEnergy(ItemStack itemStack) {
        return false;
    }

    public Item getChargedItem(ItemStack itemStack) {
        return itemStack.func_77973_b();
    }

    public Item getEmptyItem(ItemStack itemStack) {
        return itemStack.func_77973_b();
    }

    public double getMaxCharge(ItemStack itemStack) {
        return PowerUnits.AE.convertTo(PowerUnits.EU, this.getAEMaxPower(itemStack));
    }

    public int getTier(ItemStack itemStack) {
        return 1;
    }

    public double getTransferLimit(ItemStack itemStack) {
        return Math.max(32.0, this.getMaxCharge(itemStack) / 200.0);
    }

    @integration.Method(iname="IC2")
    public IElectricItemManager getManager(ItemStack itemStack) {
        return this;
    }
}

