/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.tools.powered;

import appeng.api.AEApi;
import appeng.api.config.Settings;
import appeng.api.config.SortDir;
import appeng.api.config.SortOrder;
import appeng.api.config.ViewItems;
import appeng.api.features.IWirelessTermHandler;
import appeng.api.util.IConfigManager;
import appeng.core.AEConfig;
import appeng.core.features.AEFeature;
import appeng.core.localization.GuiText;
import appeng.items.tools.powered.powersink.AEBasePoweredItem;
import appeng.util.ConfigManager;
import appeng.util.IConfigManagerHost;
import appeng.util.Platform;
import com.google.common.base.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class ToolWirelessTerminal
extends AEBasePoweredItem
implements IWirelessTermHandler {
    public ToolWirelessTerminal() {
        super((Class)ToolWirelessTerminal.class, (Optional<String>)Optional.absent());
        this.setFeature(EnumSet.of(AEFeature.WirelessAccessTerminal, AEFeature.PoweredTools));
        this.maxStoredPower = AEConfig.instance.wirelessTerminalBattery;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77662_d() {
        return false;
    }

    public ItemStack func_77659_a(ItemStack item, World w, EntityPlayer player) {
        AEApi.instance().registries().wireless().openWirelessTerminalGui(item, w, player);
        return item;
    }

    @Override
    public void addCheckedInformation(ItemStack stack, EntityPlayer player, List<String> lines, boolean displayAdditionalInformation) {
        super.addCheckedInformation(stack, player, lines, displayAdditionalInformation);
        if (stack.func_77942_o()) {
            NBTTagCompound tag = Platform.openNbtData(stack);
            if (tag != null) {
                String encKey = tag.func_74779_i("encryptionKey");
                if (encKey == null || encKey.isEmpty()) {
                    lines.add(GuiText.Unlinked.getLocal());
                } else {
                    lines.add(GuiText.Linked.getLocal());
                }
            }
        } else {
            lines.add(StatCollector.func_74838_a((String)"AppEng.GuiITooltip.Unlinked"));
        }
    }

    @Override
    public boolean canHandle(ItemStack is) {
        return AEApi.instance().items().itemWirelessTerminal.sameAsStack(is);
    }

    @Override
    public boolean usePower(EntityPlayer player, double amount, ItemStack is) {
        return this.extractAEPower(is, amount) >= amount - 0.5;
    }

    @Override
    public boolean hasPower(EntityPlayer player, double amt, ItemStack is) {
        return this.getAECurrentPower(is) >= amt;
    }

    @Override
    public IConfigManager getConfigManager(final ItemStack target) {
        ConfigManager out = new ConfigManager(new IConfigManagerHost(){

            @Override
            public void updateSetting(IConfigManager manager, Enum settingName, Enum newValue) {
                NBTTagCompound data = Platform.openNbtData(target);
                manager.writeToNBT(data);
            }
        });
        out.registerSetting(Settings.SORT_BY, SortOrder.NAME);
        out.registerSetting(Settings.VIEW_MODE, ViewItems.ALL);
        out.registerSetting(Settings.SORT_DIRECTION, SortDir.ASCENDING);
        out.readFromNBT((NBTTagCompound)Platform.openNbtData(target).func_74737_b());
        return out;
    }

    @Override
    public String getEncryptionKey(ItemStack item) {
        NBTTagCompound tag = Platform.openNbtData(item);
        return tag.func_74779_i("encryptionKey");
    }

    @Override
    public void setEncryptionKey(ItemStack item, String encKey, String name) {
        NBTTagCompound tag = Platform.openNbtData(item);
        tag.func_74778_a("encryptionKey", encKey);
        tag.func_74778_a("name", name);
    }
}

