/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.tools.powered;

import appeng.api.util.DimensionalCoord;
import appeng.block.misc.BlockTinyTNT;
import appeng.core.AEConfig;
import appeng.core.features.AEFeature;
import appeng.hooks.DispenserBlockTool;
import appeng.hooks.IBlockTool;
import appeng.items.tools.powered.powersink.AEBasePoweredItem;
import appeng.util.InWorldToolOperationResult;
import appeng.util.Platform;
import com.google.common.base.Optional;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Hashtable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.BlockTNT;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class ToolEntropyManipulator
extends AEBasePoweredItem
implements IBlockTool {
    private static Hashtable<Combo, InWorldToolOperationResult> heatUp;
    private static Hashtable<Combo, InWorldToolOperationResult> coolDown;

    public ToolEntropyManipulator() {
        super((Class)ToolEntropyManipulator.class, (Optional<String>)Optional.absent());
        this.setFeature(EnumSet.of(AEFeature.EntropyManipulator, AEFeature.PoweredTools));
        this.maxStoredPower = AEConfig.instance.entropyManipulatorBattery;
        coolDown = new Hashtable();
        coolDown.put(new Combo(Blocks.field_150348_b, 0), new InWorldToolOperationResult(new ItemStack(Blocks.field_150347_e)));
        coolDown.put(new Combo(Blocks.field_150417_aV, 0), new InWorldToolOperationResult(new ItemStack(Blocks.field_150417_aV, 1, 2)));
        coolDown.put(new Combo(Blocks.field_150353_l, Short.MAX_VALUE), new InWorldToolOperationResult(new ItemStack(Blocks.field_150343_Z)));
        coolDown.put(new Combo((Block)Blocks.field_150356_k, Short.MAX_VALUE), new InWorldToolOperationResult(new ItemStack(Blocks.field_150343_Z)));
        coolDown.put(new Combo((Block)Blocks.field_150349_c, Short.MAX_VALUE), new InWorldToolOperationResult(new ItemStack(Blocks.field_150346_d)));
        ArrayList<ItemStack> snowBalls = new ArrayList<ItemStack>();
        snowBalls.add(new ItemStack(Items.field_151126_ay));
        coolDown.put(new Combo((Block)Blocks.field_150358_i, Short.MAX_VALUE), new InWorldToolOperationResult(null, snowBalls));
        coolDown.put(new Combo(Blocks.field_150355_j, Short.MAX_VALUE), new InWorldToolOperationResult(new ItemStack(Blocks.field_150432_aD)));
        heatUp = new Hashtable();
        heatUp.put(new Combo(Blocks.field_150432_aD, 0), new InWorldToolOperationResult(new ItemStack(Blocks.field_150355_j)));
        heatUp.put(new Combo((Block)Blocks.field_150358_i, Short.MAX_VALUE), new InWorldToolOperationResult());
        heatUp.put(new Combo(Blocks.field_150355_j, Short.MAX_VALUE), new InWorldToolOperationResult());
        heatUp.put(new Combo(Blocks.field_150433_aE, Short.MAX_VALUE), new InWorldToolOperationResult(new ItemStack((Block)Blocks.field_150358_i)));
    }

    @Override
    public void postInit() {
        super.postInit();
        BlockDispenser.field_149943_a.func_82595_a((Object)this, (Object)new DispenserBlockTool());
    }

    public static void heat(Block BlockID, int Metadata, World w, int x, int y, int z) {
        InWorldToolOperationResult r = heatUp.get(new Combo(BlockID, Metadata));
        if (r == null) {
            r = heatUp.get(new Combo(BlockID, Short.MAX_VALUE));
        }
        if (r.BlockItem != null) {
            w.func_147465_d(x, y, z, Block.func_149634_a((Item)r.BlockItem.func_77973_b()), r.BlockItem.func_77960_j(), 3);
        } else {
            w.func_147465_d(x, y, z, Platform.air, 0, 3);
        }
        if (r.Drops != null) {
            Platform.spawnDrops(w, x, y, z, r.Drops);
        }
    }

    public static boolean canHeat(Block BlockID, int Metadata) {
        InWorldToolOperationResult r = heatUp.get(new Combo(BlockID, Metadata));
        if (r == null) {
            r = heatUp.get(new Combo(BlockID, Short.MAX_VALUE));
        }
        return r != null;
    }

    public static void cool(Block BlockID, int Metadata, World w, int x, int y, int z) {
        InWorldToolOperationResult r = coolDown.get(new Combo(BlockID, Metadata));
        if (r == null) {
            r = coolDown.get(new Combo(BlockID, Short.MAX_VALUE));
        }
        if (r.BlockItem != null) {
            w.func_147465_d(x, y, z, Block.func_149634_a((Item)r.BlockItem.func_77973_b()), r.BlockItem.func_77960_j(), 3);
        } else {
            w.func_147465_d(x, y, z, Platform.air, 0, 3);
        }
        if (r.Drops != null) {
            Platform.spawnDrops(w, x, y, z, r.Drops);
        }
    }

    public static boolean canCool(Block BlockID, int Metadata) {
        InWorldToolOperationResult r = coolDown.get(new Combo(BlockID, Metadata));
        if (r == null) {
            r = coolDown.get(new Combo(BlockID, Short.MAX_VALUE));
        }
        return r != null;
    }

    public boolean func_77644_a(ItemStack item, EntityLivingBase target, EntityLivingBase hitter) {
        if (this.getAECurrentPower(item) > 1600.0) {
            this.extractAEPower(item, 1600.0);
            target.func_70015_d(8);
        }
        return false;
    }

    public ItemStack func_77659_a(ItemStack item, World w, EntityPlayer p) {
        int z;
        int y;
        int x;
        MovingObjectPosition target = this.func_77621_a(w, p, true);
        if (target == null) {
            return item;
        }
        if (target.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK && (w.func_147439_a(x = target.field_72311_b, y = target.field_72312_c, z = target.field_72309_d).func_149688_o() == Material.field_151587_i || w.func_147439_a(x, y, z).func_149688_o() == Material.field_151586_h) && Platform.hasPermissions(new DimensionalCoord(w, x, y, z), p)) {
            this.func_77648_a(item, p, w, x, y, z, 0, 0.0f, 0.0f, 0.0f);
        }
        return item;
    }

    public boolean func_77648_a(ItemStack item, EntityPlayer p, World w, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (this.getAECurrentPower(item) > 1600.0) {
            if (!p.func_82247_a(x, y, z, side, item)) {
                return false;
            }
            Block Blk = w.func_147439_a(x, y, z);
            int Metadata = w.func_72805_g(x, y, z);
            if (p.func_70093_af()) {
                if (ToolEntropyManipulator.canCool(Blk, Metadata)) {
                    this.extractAEPower(item, 1600.0);
                    ToolEntropyManipulator.cool(Blk, Metadata, w, x, y, z);
                    return true;
                }
            } else {
                if (Blk instanceof BlockTNT) {
                    w.func_147465_d(x, y, z, Platform.air, 0, 3);
                    ((BlockTNT)Blk).func_150114_a(w, x, y, z, 1, (EntityLivingBase)p);
                    return true;
                }
                if (Blk instanceof BlockTinyTNT) {
                    w.func_147465_d(x, y, z, Platform.air, 0, 3);
                    ((BlockTinyTNT)Blk).startFuse(w, x, y, z, (EntityLivingBase)p);
                    return true;
                }
                if (ToolEntropyManipulator.canHeat(Blk, Metadata)) {
                    this.extractAEPower(item, 1600.0);
                    ToolEntropyManipulator.heat(Blk, Metadata, w, x, y, z);
                    return true;
                }
                ItemStack[] stack = Platform.getBlockDrops(w, x, y, z);
                ArrayList<ItemStack> out = new ArrayList<ItemStack>();
                boolean hasFurnaceable = false;
                boolean canFurnaceable = true;
                for (ItemStack i : stack) {
                    ItemStack result = FurnaceRecipes.func_77602_a().func_151395_a(i);
                    if (result != null) {
                        if (result.func_77973_b() instanceof ItemBlock && Block.func_149634_a((Item)result.func_77973_b()) == Blk && result.func_77973_b().getDamage(result) == Metadata) {
                            canFurnaceable = false;
                        }
                        hasFurnaceable = true;
                        out.add(result);
                        continue;
                    }
                    canFurnaceable = false;
                    out.add(i);
                }
                if (hasFurnaceable && canFurnaceable) {
                    this.extractAEPower(item, 1600.0);
                    InWorldToolOperationResult or = InWorldToolOperationResult.getBlockOperationResult(out.toArray(new ItemStack[out.size()]));
                    w.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "fire.ignite", 1.0f, field_77697_d.nextFloat() * 0.4f + 0.8f);
                    if (or.BlockItem == null) {
                        w.func_147465_d(x, y, z, Platform.air, 0, 3);
                    } else {
                        w.func_147465_d(x, y, z, Block.func_149634_a((Item)or.BlockItem.func_77973_b()), or.BlockItem.func_77960_j(), 3);
                    }
                    if (or.Drops != null) {
                        Platform.spawnDrops(w, x, y, z, or.Drops);
                    }
                    return true;
                }
                ForgeDirection dir = ForgeDirection.getOrientation((int)side);
                if (!p.func_82247_a(x += dir.offsetX, y += dir.offsetY, z += dir.offsetZ, side, item)) {
                    return false;
                }
                if (w.func_147437_c(x, y, z)) {
                    this.extractAEPower(item, 1600.0);
                    w.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "fire.ignite", 1.0f, field_77697_d.nextFloat() * 0.4f + 0.8f);
                    w.func_147449_b(x, y, z, (Block)Blocks.field_150480_ab);
                }
                return true;
            }
        }
        return false;
    }

    static class Combo {
        public final Block blk;
        public final int meta;

        public Combo(Block b, int m) {
            this.blk = b;
            this.meta = m;
        }

        public int hashCode() {
            return this.blk.hashCode() ^ this.meta;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Combo other = (Combo)obj;
            return this.blk == other.blk && this.meta == other.meta;
        }
    }
}

