/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.tools;

import appeng.api.implementations.items.IMemoryCard;
import appeng.api.implementations.items.MemoryCardMessages;
import appeng.core.features.AEFeature;
import appeng.core.localization.GuiText;
import appeng.core.localization.PlayerMessages;
import appeng.items.AEBaseItem;
import appeng.util.Platform;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class ToolMemoryCard
extends AEBaseItem
implements IMemoryCard {
    public ToolMemoryCard() {
        super(ToolMemoryCard.class);
        this.setFeature(EnumSet.of(AEFeature.Core));
        this.func_77625_d(1);
    }

    private String getLocalizedName(String ... name) {
        for (String n : name) {
            String l = StatCollector.func_74838_a((String)n);
            if (l.equals(n)) continue;
            return l;
        }
        int i$ = 0;
        String[] arr$ = name;
        int len$ = arr$.length;
        if (i$ < len$) {
            String n;
            n = arr$[i$];
            return n;
        }
        return "";
    }

    @Override
    public void addCheckedInformation(ItemStack stack, EntityPlayer player, List<String> lines, boolean displayAdditionalInformation) {
        lines.add(this.getLocalizedName(this.getSettingsName(stack) + ".name", this.getSettingsName(stack)));
        NBTTagCompound data = this.getData(stack);
        if (data.func_74764_b("tooltip")) {
            lines.add(StatCollector.func_74838_a((String)this.getLocalizedName(data.func_74779_i("tooltip") + ".name", data.func_74779_i("tooltip"))));
        }
    }

    public boolean doesSneakBypassUse(World world, int x, int y, int z, EntityPlayer player) {
        return true;
    }

    @Override
    public void setMemoryCardContents(ItemStack is, String SettingsName, NBTTagCompound data) {
        NBTTagCompound c = Platform.openNbtData(is);
        c.func_74778_a("Config", SettingsName);
        c.func_74782_a("Data", (NBTBase)data);
    }

    @Override
    public String getSettingsName(ItemStack is) {
        NBTTagCompound c = Platform.openNbtData(is);
        String name = c.func_74779_i("Config");
        return name == null || name.isEmpty() ? GuiText.Blank.getUnlocalized() : name;
    }

    @Override
    public NBTTagCompound getData(ItemStack is) {
        NBTTagCompound c = Platform.openNbtData(is);
        NBTTagCompound o = c.func_74775_l("Data");
        if (o == null) {
            o = new NBTTagCompound();
        }
        return (NBTTagCompound)o.func_74737_b();
    }

    public boolean func_77648_a(ItemStack is, EntityPlayer player, World w, int x, int y, int z, int side, float hx, float hy, float hz) {
        if (player.func_70093_af() && !w.field_72995_K) {
            IMemoryCard mem = (IMemoryCard)is.func_77973_b();
            mem.notifyUser(player, MemoryCardMessages.SETTINGS_CLEARED);
            is.func_77982_d(null);
            return true;
        }
        return super.func_77648_a(is, player, w, x, y, z, side, hx, hy, hz);
    }

    @Override
    public void notifyUser(EntityPlayer player, MemoryCardMessages msg) {
        if (Platform.isClient()) {
            return;
        }
        switch (msg) {
            case SETTINGS_CLEARED: {
                player.func_145747_a(PlayerMessages.SettingCleared.get());
                break;
            }
            case INVALID_MACHINE: {
                player.func_145747_a(PlayerMessages.InvalidMachine.get());
                break;
            }
            case SETTINGS_LOADED: {
                player.func_145747_a(PlayerMessages.LoadedSettings.get());
                break;
            }
            case SETTINGS_SAVED: {
                player.func_145747_a(PlayerMessages.SavedSettings.get());
                break;
            }
        }
    }
}

