/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.misc;

import appeng.api.AEApi;
import appeng.api.implementations.ICraftingPatternItem;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.storage.data.IAEItemStack;
import appeng.client.render.items.ItemEncodedPatternRenderer;
import appeng.core.CommonHelper;
import appeng.core.features.AEFeature;
import appeng.core.localization.GuiText;
import appeng.helpers.PatternHelper;
import appeng.items.AEBaseItem;
import appeng.util.Platform;
import java.util.EnumSet;
import java.util.List;
import java.util.WeakHashMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;

public class ItemEncodedPattern
extends AEBaseItem
implements ICraftingPatternItem {
    static final WeakHashMap<ItemStack, ItemStack> simpleCache = new WeakHashMap();

    public ItemEncodedPattern() {
        super(ItemEncodedPattern.class);
        this.setFeature(EnumSet.of(AEFeature.Patterns));
        this.func_77625_d(1);
        if (Platform.isClient()) {
            MinecraftForgeClient.registerItemRenderer((Item)this, (IItemRenderer)new ItemEncodedPatternRenderer());
        }
    }

    private boolean clearPattern(ItemStack stack, EntityPlayer player) {
        if (player.func_70093_af()) {
            if (Platform.isClient()) {
                return false;
            }
            InventoryPlayer inv = player.field_71071_by;
            for (int s = 0; s < player.field_71071_by.func_70302_i_(); ++s) {
                if (inv.func_70301_a(s) != stack) continue;
                inv.func_70299_a(s, AEApi.instance().materials().materialBlankPattern.stack(stack.field_77994_a));
                return true;
            }
        }
        return false;
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        return this.clearPattern(stack, player);
    }

    public ItemStack func_77659_a(ItemStack stack, World w, EntityPlayer player) {
        this.clearPattern(stack, player);
        return stack;
    }

    @Override
    public void addCheckedInformation(ItemStack stack, EntityPlayer player, List<String> lines, boolean displayAdditionalInformation) {
        ICraftingPatternDetails details = this.getPatternForItem(stack, player.field_70170_p);
        if (details == null) {
            lines.add(EnumChatFormatting.RED + GuiText.InvalidPattern.getLocal());
            return;
        }
        boolean isCrafting = details.isCraftable();
        IAEItemStack[] in = details.getCondensedInputs();
        IAEItemStack[] out = details.getCondensedOutputs();
        String label = (isCrafting ? GuiText.Crafts.getLocal() : GuiText.Creates.getLocal()) + ": ";
        String and = ' ' + GuiText.And.getLocal() + ' ';
        String with = GuiText.With.getLocal() + ": ";
        boolean first = true;
        for (IAEItemStack anOut : out) {
            if (anOut == null) continue;
            lines.add((first ? label : and) + anOut.getStackSize() + ' ' + Platform.getItemDisplayName(anOut));
            first = false;
        }
        first = true;
        for (IAEItemStack anIn : in) {
            if (anIn == null) continue;
            lines.add((first ? with : and) + anIn.getStackSize() + ' ' + Platform.getItemDisplayName(anIn));
            first = false;
        }
    }

    public ItemStack getOutput(ItemStack item) {
        ItemStack out = simpleCache.get(item);
        if (out != null) {
            return out;
        }
        World w = CommonHelper.proxy.getWorld();
        if (w == null) {
            return null;
        }
        ICraftingPatternDetails details = this.getPatternForItem(item, w);
        if (details == null) {
            return null;
        }
        out = details.getCondensedOutputs()[0].getItemStack();
        simpleCache.put(item, out);
        return out;
    }

    @Override
    public ICraftingPatternDetails getPatternForItem(ItemStack is, World w) {
        try {
            return new PatternHelper(is, w);
        }
        catch (Throwable t) {
            return null;
        }
    }
}

