/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.materials;

import appeng.api.config.Upgrades;
import appeng.api.implementations.IUpgradeableHost;
import appeng.api.implementations.items.IItemGroup;
import appeng.api.implementations.items.IStorageComponent;
import appeng.api.implementations.items.IUpgradeModule;
import appeng.api.parts.IPartHost;
import appeng.api.parts.SelectedPart;
import appeng.client.texture.MissingIcon;
import appeng.core.AEConfig;
import appeng.core.features.AEFeature;
import appeng.core.features.AEFeatureHandler;
import appeng.core.features.IStackSrc;
import appeng.core.features.MaterialStackSrc;
import appeng.items.AEBaseItem;
import appeng.items.materials.MaterialType;
import appeng.util.InventoryAdaptor;
import appeng.util.Platform;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.oredict.OreDictionary;

public class ItemMultiMaterial
extends AEBaseItem
implements IStorageComponent,
IUpgradeModule {
    final HashMap<Integer, MaterialType> dmgToMaterial = new HashMap();
    public static ItemMultiMaterial instance;

    public ItemMultiMaterial() {
        super(ItemMultiMaterial.class);
        this.setFeature(EnumSet.of(AEFeature.Core));
        this.func_77627_a(true);
        instance = this;
    }

    @Override
    public void addCheckedInformation(ItemStack stack, EntityPlayer player, List<String> lines, boolean displayAdditionalInformation) {
        Upgrades u;
        super.addCheckedInformation(stack, player, lines, displayAdditionalInformation);
        MaterialType mt = this.getTypeByStack(stack);
        if (mt == null) {
            return;
        }
        if (mt == MaterialType.NamePress) {
            NBTTagCompound c = Platform.openNbtData(stack);
            lines.add(c.func_74779_i("InscribeName"));
        }
        if ((u = this.getType(stack)) != null) {
            LinkedList<String> textList = new LinkedList<String>();
            for (Map.Entry<ItemStack, Integer> j : u.getSupported().entrySet()) {
                IItemGroup ig;
                String str;
                String name = null;
                int limit = j.getValue();
                if (j.getKey().func_77973_b() instanceof IItemGroup && (str = (ig = (IItemGroup)j.getKey().func_77973_b()).getUnlocalizedGroupName(u.getSupported().keySet(), j.getKey())) != null) {
                    name = Platform.gui_localize(str) + (limit > 1 ? " (" + limit + ')' : "");
                }
                if (name == null) {
                    name = j.getKey().func_82833_r() + (limit > 1 ? " (" + limit + ')' : "");
                }
                if (textList.contains(name)) continue;
                textList.add(name);
            }
            Pattern p = Pattern.compile("(\\d+)[^\\d]");
            SlightlyBetterSort s = new SlightlyBetterSort(p);
            Collections.sort(textList, s);
            lines.addAll(textList);
        }
    }

    public IStackSrc createMaterial(MaterialType mat) {
        if (!mat.isRegistered()) {
            boolean enabled = true;
            for (AEFeature f : mat.getFeature()) {
                enabled = enabled && AEConfig.instance.isFeatureEnabled(f);
            }
            if (enabled) {
                mat.itemInstance = this;
                int newMaterialNum = mat.damageValue;
                mat.markReady();
                MaterialStackSrc output = mat.stackSrc = new MaterialStackSrc(mat);
                if (this.dmgToMaterial.get(newMaterialNum) != null) {
                    throw new RuntimeException("Meta Overlap detected.");
                }
                this.dmgToMaterial.put(newMaterialNum, mat);
                return output;
            }
            return null;
        }
        throw new RuntimeException("Cannot create the same material twice...");
    }

    public void makeUnique() {
        for (MaterialType mt : ImmutableSet.copyOf(this.dmgToMaterial.values())) {
            String[] names;
            if (mt.getOreName() == null) continue;
            ItemStack replacement = null;
            block1: for (String name : names = mt.getOreName().split(",")) {
                if (replacement != null) break;
                ArrayList options = OreDictionary.getOres((String)name);
                if (options == null || options.size() <= 0) continue;
                for (ItemStack is : options) {
                    if (is == null || is.func_77973_b() == null) continue;
                    replacement = is.func_77946_l();
                    continue block1;
                }
            }
            if (replacement == null || AEConfig.instance.useAEVersion(mt)) {
                for (String name : names) {
                    OreDictionary.registerOre((String)name, (ItemStack)mt.stack(1));
                }
                continue;
            }
            if (mt.itemInstance == this) {
                this.dmgToMaterial.remove(mt.damageValue);
            }
            mt.itemInstance = replacement.func_77973_b();
            mt.damageValue = replacement.func_77960_j();
        }
    }

    public MaterialType getTypeByStack(ItemStack is) {
        if (this.dmgToMaterial.containsKey(is.func_77960_j())) {
            return this.dmgToMaterial.get(is.func_77960_j());
        }
        return MaterialType.InvalidType;
    }

    public IIcon func_77617_a(int dmg) {
        if (this.dmgToMaterial.containsKey(dmg)) {
            return this.dmgToMaterial.get((Object)Integer.valueOf((int)dmg)).IIcon;
        }
        return new MissingIcon(this);
    }

    private String nameOf(ItemStack is) {
        if (is == null) {
            return "null";
        }
        MaterialType mt = this.getTypeByStack(is);
        if (mt == null) {
            return "null";
        }
        return AEFeatureHandler.getName(ItemMultiMaterial.class, mt.name());
    }

    public String func_77667_c(ItemStack is) {
        return "item.appliedenergistics2." + this.nameOf(is);
    }

    public void func_94581_a(IIconRegister icoRegister) {
        for (MaterialType mat : MaterialType.values()) {
            ItemStack what;
            if (mat.damageValue == -1 || this.getTypeByStack(what = new ItemStack((Item)this, 1, mat.damageValue)) == MaterialType.InvalidType) continue;
            String tex = "appliedenergistics2:" + this.nameOf(what);
            mat.IIcon = icoRegister.func_94245_a(tex);
        }
    }

    public boolean hasCustomEntity(ItemStack is) {
        return this.getTypeByStack(is).hasCustomEntity();
    }

    public Entity createEntity(World w, Entity location, ItemStack itemstack) {
        Entity eqi;
        Class<? extends Entity> droppedEntity = this.getTypeByStack(itemstack).getCustomEntityClass();
        try {
            eqi = droppedEntity.getConstructor(World.class, Double.TYPE, Double.TYPE, Double.TYPE, ItemStack.class).newInstance(w, location.field_70165_t, location.field_70163_u, location.field_70161_v, itemstack);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        eqi.field_70159_w = location.field_70159_w;
        eqi.field_70181_x = location.field_70181_x;
        eqi.field_70179_y = location.field_70179_y;
        if (location instanceof EntityItem && eqi instanceof EntityItem) {
            ((EntityItem)eqi).field_145804_b = ((EntityItem)location).field_145804_b;
        }
        return eqi;
    }

    @Override
    public int getBytes(ItemStack is) {
        switch (this.getTypeByStack(is)) {
            case Cell1kPart: {
                return 1024;
            }
            case Cell4kPart: {
                return 4096;
            }
            case Cell16kPart: {
                return 16384;
            }
            case Cell64kPart: {
                return 65536;
            }
        }
        return 0;
    }

    @Override
    public boolean isStorageComponent(ItemStack is) {
        switch (this.getTypeByStack(is)) {
            case Cell1kPart: 
            case Cell4kPart: 
            case Cell16kPart: 
            case Cell64kPart: {
                return true;
            }
        }
        return false;
    }

    @Override
    public Upgrades getType(ItemStack itemstack) {
        switch (this.getTypeByStack(itemstack)) {
            case CardCapacity: {
                return Upgrades.CAPACITY;
            }
            case CardFuzzy: {
                return Upgrades.FUZZY;
            }
            case CardRedstone: {
                return Upgrades.REDSTONE;
            }
            case CardSpeed: {
                return Upgrades.SPEED;
            }
            case CardInverter: {
                return Upgrades.INVERTER;
            }
            case CardCrafting: {
                return Upgrades.CRAFTING;
            }
        }
        return null;
    }

    public boolean onItemUseFirst(ItemStack is, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (player.func_70093_af()) {
            InventoryAdaptor ad;
            IUpgradeModule um;
            Upgrades u;
            TileEntity te = world.func_147438_o(x, y, z);
            IInventory upgrades = null;
            if (te instanceof IPartHost) {
                SelectedPart sp = ((IPartHost)te).selectPart(Vec3.func_72443_a((double)hitX, (double)hitY, (double)hitZ));
                if (sp.part instanceof IUpgradeableHost) {
                    upgrades = ((IUpgradeableHost)((Object)sp.part)).getInventoryByName("upgrades");
                }
            } else if (te instanceof IUpgradeableHost) {
                upgrades = ((IUpgradeableHost)te).getInventoryByName("upgrades");
            }
            if (upgrades != null && is != null && is.func_77973_b() instanceof IUpgradeModule && (u = (um = (IUpgradeModule)is.func_77973_b()).getType(is)) != null && (ad = InventoryAdaptor.getAdaptor(upgrades, ForgeDirection.UNKNOWN)) != null) {
                if (player.field_70170_p.field_72995_K) {
                    return false;
                }
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, ad.addItems(is));
                return true;
            }
        }
        return super.onItemUseFirst(is, player, world, x, y, z, side, hitX, hitY, hitZ);
    }

    public void func_150895_a(Item par1, CreativeTabs par2CreativeTabs, List cList) {
        List<MaterialType> types = Arrays.asList(MaterialType.values());
        Collections.sort(types, new Comparator<MaterialType>(){

            @Override
            public int compare(MaterialType o1, MaterialType o2) {
                return o1.name().compareTo(o2.name());
            }
        });
        for (MaterialType mat : types) {
            if (mat.damageValue < 0 || !mat.isRegistered() || mat.itemInstance != this) continue;
            cList.add(new ItemStack((Item)this, 1, mat.damageValue));
        }
    }

    static class SlightlyBetterSort
    implements Comparator<String> {
        final Pattern p;

        public SlightlyBetterSort(Pattern p) {
            this.p = p;
        }

        @Override
        public int compare(String o1, String o2) {
            try {
                Matcher a = this.p.matcher(o1);
                Matcher b = this.p.matcher(o2);
                if (a.find() && b.find()) {
                    int ia = Integer.parseInt(a.group(1));
                    int ib = Integer.parseInt(b.group(1));
                    return Integer.compare(ia, ib);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return o1.compareTo(o2);
        }
    }
}

