/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.helpers;

import appeng.api.config.Actionable;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IItemList;
import appeng.integration.abstraction.IFZ;
import appeng.util.item.AEItemStack;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;

public class FactorizationBarrel
implements IMEInventory<IAEItemStack> {
    private final TileEntity te;
    final IFZ fProxy;

    public FactorizationBarrel(IFZ proxy, TileEntity tile) {
        this.te = tile;
        this.fProxy = proxy;
    }

    @Override
    public StorageChannel getChannel() {
        return StorageChannel.ITEMS;
    }

    public long remainingItemTypes() {
        return this.fProxy.barrelGetItem(this.te) == null ? 1L : 0L;
    }

    public long remainingItemCount() {
        return this.fProxy.barrelGetMaxItemCount(this.te) - this.fProxy.barrelGetItemCount(this.te);
    }

    public boolean containsItemType(IAEItemStack i, boolean acceptEmpty) {
        ItemStack currentItem = this.fProxy.barrelGetItem(this.te);
        if (acceptEmpty && currentItem == null) {
            return true;
        }
        return i.equals(currentItem);
    }

    public long storedItemCount() {
        return this.fProxy.barrelGetItemCount(this.te);
    }

    @Override
    public IAEItemStack injectItems(IAEItemStack input, Actionable mode, BaseActionSource src) {
        if (input == null) {
            return null;
        }
        if (input.getStackSize() == 0L) {
            return null;
        }
        ItemStack shared = input.getItemStack();
        if (shared.func_77951_h()) {
            return input;
        }
        if (this.remainingItemTypes() > 0L && mode == Actionable.MODULATE) {
            this.fProxy.setItemType(this.te, input.getItemStack());
        }
        if (this.containsItemType(input, mode == Actionable.SIMULATE)) {
            int max = this.fProxy.barrelGetMaxItemCount(this.te);
            int newTotal = (int)this.storedItemCount() + (int)input.getStackSize();
            if (newTotal > max) {
                if (mode == Actionable.MODULATE) {
                    this.fProxy.barrelSetCount(this.te, max);
                }
                IAEItemStack result = input.copy();
                result.setStackSize(newTotal - max);
                return result;
            }
            if (mode == Actionable.MODULATE) {
                this.fProxy.barrelSetCount(this.te, newTotal);
            }
            return null;
        }
        return input;
    }

    @Override
    public IAEItemStack extractItems(IAEItemStack request, Actionable mode, BaseActionSource src) {
        if (this.containsItemType(request, false)) {
            int howMany = (int)this.storedItemCount();
            if (request.getStackSize() >= (long)howMany) {
                if (mode == Actionable.MODULATE) {
                    this.fProxy.setItemType(this.te, null);
                    this.fProxy.barrelSetCount(this.te, 0);
                }
                IAEItemStack r = request.copy();
                r.setStackSize(howMany);
                return r;
            }
            if (mode == Actionable.MODULATE) {
                this.fProxy.barrelSetCount(this.te, (int)((long)howMany - request.getStackSize()));
            }
            return request.copy();
        }
        return null;
    }

    @Override
    public IItemList<IAEItemStack> getAvailableItems(IItemList out) {
        ItemStack i = this.fProxy.barrelGetItem(this.te);
        if (i != null) {
            i.field_77994_a = this.fProxy.barrelGetItemCount(this.te);
            out.addStorage(AEItemStack.create(i));
        }
        return out;
    }
}

