/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules;

import appeng.api.AEApi;
import appeng.api.definitions.Blocks;
import appeng.api.parts.IPartHost;
import appeng.core.AELog;
import appeng.fmp.CableBusPart;
import appeng.fmp.FMPEvent;
import appeng.fmp.FMPPlacementHelper;
import appeng.fmp.PartRegistry;
import appeng.integration.IIntegrationModule;
import appeng.integration.abstraction.IFMP;
import appeng.integration.modules.helpers.FMPPacketEvent;
import appeng.parts.CableBusContainer;
import codechicken.lib.vec.BlockCoord;
import codechicken.microblock.BlockMicroMaterial;
import codechicken.multipart.MultiPartRegistry;
import codechicken.multipart.MultipartGenerator;
import codechicken.multipart.TMultiPart;
import codechicken.multipart.TileMultipart;
import cpw.mods.fml.common.eventhandler.Event;
import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;

public class FMP
implements IIntegrationModule,
MultiPartRegistry.IPartFactory,
MultiPartRegistry.IPartConverter,
IFMP {
    public static FMP instance;

    public TMultiPart createPart(String name, boolean client) {
        for (PartRegistry pr : PartRegistry.values()) {
            if (!pr.getName().equals(name)) continue;
            return pr.construct(0);
        }
        return null;
    }

    public TMultiPart convert(World world, BlockCoord pos) {
        int meta;
        Block blk = world.func_147439_a(pos.x, pos.y, pos.z);
        TMultiPart part = PartRegistry.getPartByBlock(blk, meta = world.func_72805_g(pos.x, pos.y, pos.z));
        if (part instanceof CableBusPart) {
            CableBusPart cbp = (CableBusPart)part;
            cbp.convertFromTile(world.func_147438_o(pos.x, pos.y, pos.z));
        }
        return part;
    }

    @Override
    public void Init() throws Throwable {
        this.createAndRegister(AEApi.instance().blocks().blockQuartz.block(), 0);
        this.createAndRegister(AEApi.instance().blocks().blockQuartzPillar.block(), 0);
        this.createAndRegister(AEApi.instance().blocks().blockQuartzChiseled.block(), 0);
        this.createAndRegister(AEApi.instance().blocks().blockSkyStone.block(), 0);
        this.createAndRegister(AEApi.instance().blocks().blockSkyStone.block(), 1);
        this.createAndRegister(AEApi.instance().blocks().blockSkyStone.block(), 2);
        this.createAndRegister(AEApi.instance().blocks().blockSkyStone.block(), 3);
        PartRegistry[] reg = PartRegistry.values();
        String[] data = new String[reg.length];
        for (int x = 0; x < data.length; ++x) {
            data[x] = reg[x].getName();
        }
        MultiPartRegistry.registerConverter((MultiPartRegistry.IPartConverter)this);
        MultiPartRegistry.registerParts((MultiPartRegistry.IPartFactory)this, (String[])data);
        MultipartGenerator.registerPassThroughInterface((String)"appeng.helpers.AEMultiTile");
    }

    private void createAndRegister(Block block, int i) {
        if (block != null) {
            BlockMicroMaterial.createAndRegister((Block)block, (int)i);
        }
    }

    @Override
    public void PostInit() {
        MinecraftForge.EVENT_BUS.register((Object)new FMPEvent());
    }

    @Override
    public IPartHost getOrCreateHost(TileEntity tile) {
        try {
            BlockCoord loc = new BlockCoord(tile.field_145851_c, tile.field_145848_d, tile.field_145849_e);
            TileMultipart mp = TileMultipart.getOrConvertTile((World)tile.func_145831_w(), (BlockCoord)loc);
            if (mp != null) {
                for (TMultiPart p : mp.partList()) {
                    if (!(p instanceof CableBusPart)) continue;
                    return (IPartHost)p;
                }
                return new FMPPlacementHelper(mp);
            }
        }
        catch (Throwable t) {
            AELog.error(t);
        }
        return null;
    }

    @Override
    public CableBusContainer getCableContainer(TileEntity te) {
        if (te instanceof TileMultipart) {
            TileMultipart mp = (TileMultipart)te;
            for (TMultiPart p : mp.partList()) {
                if (!(p instanceof CableBusPart)) continue;
                return ((CableBusPart)p).cb;
            }
        }
        return null;
    }

    @Override
    public void registerPassThrough(Class<?> layerInterface) {
        try {
            MultipartGenerator.registerPassThroughInterface((String)layerInterface.getName());
        }
        catch (Throwable t) {
            AELog.severe("Failed to register " + layerInterface.getName() + " with FMP, some features may not work with MultiParts.", new Object[0]);
            AELog.error(t);
        }
    }

    @Override
    public Event newFMPPacketEvent(EntityPlayerMP sender) {
        return new FMPPacketEvent(sender);
    }

    public Iterable<Block> blockTypes() {
        Blocks def = AEApi.instance().blocks();
        return Arrays.asList(def.blockMultiPart.block(), def.blockQuartzTorch.block());
    }
}

