/*
 * Decompiled with CFR 0.152.
 */
package appeng.hooks;

import appeng.api.AEApi;
import appeng.api.features.IWorldGen;
import appeng.core.AEConfig;
import appeng.core.features.registries.WorldGenRegistry;
import cpw.mods.fml.common.IWorldGenerator;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenMinable;

public final class QuartzWorldGen
implements IWorldGenerator {
    final WorldGenMinable oreNormal;
    final WorldGenMinable oreCharged;

    public QuartzWorldGen() {
        Block normal = AEApi.instance().blocks().blockQuartzOre.block();
        Block charged = AEApi.instance().blocks().blockQuartzOreCharged.block();
        if (normal != null && charged != null) {
            this.oreNormal = new WorldGenMinable(normal, 0, AEConfig.instance.quartzOresPerCluster, Blocks.field_150348_b);
            this.oreCharged = new WorldGenMinable(charged, 0, AEConfig.instance.quartzOresPerCluster, Blocks.field_150348_b);
        } else {
            this.oreCharged = null;
            this.oreNormal = null;
        }
    }

    public void generate(Random r, int chunkX, int chunkZ, World w, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        int seaLevel = w.field_73011_w.func_76557_i() + 1;
        if (seaLevel < 20) {
            int x = (chunkX << 4) + 8;
            int z = (chunkZ << 4) + 8;
            seaLevel = w.func_72976_f(x, z);
        }
        if (this.oreNormal == null || this.oreCharged == null) {
            return;
        }
        double oreDepthMultiplier = AEConfig.instance.quartzOresClusterAmount * seaLevel / 64;
        int scale = (int)Math.round(r.nextGaussian() * Math.sqrt(oreDepthMultiplier) + oreDepthMultiplier);
        for (int x = 0; x < (r.nextBoolean() ? scale * 2 : scale) / 2; ++x) {
            boolean isCharged = r.nextFloat() > AEConfig.instance.spawnChargedChance;
            WorldGenMinable whichOre = isCharged ? this.oreCharged : this.oreNormal;
            if (!WorldGenRegistry.instance.isWorldGenEnabled(isCharged ? IWorldGen.WorldGenType.ChargedCertusQuartz : IWorldGen.WorldGenType.CertusQuartz, w)) continue;
            int cx = chunkX * 16 + r.nextInt(22);
            int cy = r.nextInt(40 * seaLevel / 64) + r.nextInt(22 * seaLevel / 64) + 12 * seaLevel / 64;
            int cz = chunkZ * 16 + r.nextInt(22);
            whichOre.func_76484_a(w, r, cx, cy, cz);
        }
    }
}

