/*
 * Decompiled with CFR 0.152.
 */
package appeng.hooks;

import appeng.api.features.IWorldGen;
import appeng.core.AEConfig;
import appeng.core.WorldSettings;
import appeng.core.features.registries.WorldGenRegistry;
import appeng.helpers.MeteoritePlacer;
import appeng.hooks.TickHandler;
import appeng.services.helpers.ICompassCallback;
import appeng.util.Platform;
import cpw.mods.fml.common.IWorldGenerator;
import java.util.Collection;
import java.util.Random;
import java.util.concurrent.Callable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;

public final class MeteoriteWorldGen
implements IWorldGenerator {
    public void generate(Random r, int chunkX, int chunkZ, World w, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        if (WorldGenRegistry.instance.isWorldGenEnabled(IWorldGen.WorldGenType.Meteorites, w)) {
            if ((double)r.nextFloat() < AEConfig.instance.meteoriteSpawnChance) {
                int x = r.nextInt(16) + (chunkX << 4);
                int z = r.nextInt(16) + (chunkZ << 4);
                int depth = 180 + r.nextInt(20);
                TickHandler.instance.addCallable(w, new MeteoriteSpawn(x, depth, z, w));
            } else {
                TickHandler.instance.addCallable(w, new MeteoriteSpawn(chunkX << 4, 128, chunkZ << 4, w));
            }
        } else {
            WorldSettings.getInstance().getCompass().updateArea(w, chunkX, chunkZ);
        }
    }

    private boolean tryMeteorite(World w, int depth, int x, int z) {
        for (int tries = 0; tries < 20; ++tries) {
            MeteoritePlacer mp = new MeteoritePlacer();
            if (mp.spawnMeteorite(new MeteoritePlacer.ChunkOnly(w, x >> 4, z >> 4), x, depth, z)) {
                int px = x >> 4;
                int pz = z >> 4;
                for (int cx = px - 6; cx < px + 6; ++cx) {
                    for (int cz = pz - 6; cz < pz + 6; ++cz) {
                        if (!w.func_72863_F().func_73149_a(cx, cz) || px == cx && pz == cz || !WorldSettings.getInstance().hasGenerated(w.field_73011_w.field_76574_g, cx, cz)) continue;
                        MeteoritePlacer mp2 = new MeteoritePlacer();
                        mp2.spawnMeteorite(new MeteoritePlacer.ChunkOnly(w, cx, cz), mp.getSettings());
                    }
                }
                return true;
            }
            if ((depth -= 15) >= 40) continue;
            return false;
        }
        return false;
    }

    private Collection<NBTTagCompound> getNearByMeteorites(World w, int chunkX, int chunkZ) {
        return WorldSettings.getInstance().getNearByMeteorites(w.field_73011_w.field_76574_g, chunkX, chunkZ);
    }

    class MeteoriteSpawn
    implements Callable {
        final int x;
        final int z;
        final World w;
        final int depth;

        public MeteoriteSpawn(int x, int depth, int z, World w) {
            this.x = x;
            this.z = z;
            this.w = w;
            this.depth = depth;
        }

        public Object call() throws Exception {
            boolean isCluster;
            int chunkX = this.x >> 4;
            int chunkZ = this.z >> 4;
            double minSqDist = Double.MAX_VALUE;
            for (NBTTagCompound data : MeteoriteWorldGen.this.getNearByMeteorites(this.w, chunkX, chunkZ)) {
                MeteoritePlacer mp = new MeteoritePlacer();
                mp.spawnMeteorite(new MeteoritePlacer.ChunkOnly(this.w, chunkX, chunkZ), data);
                minSqDist = Math.min(minSqDist, mp.getSqDistance(this.x, this.z));
            }
            boolean bl = isCluster = minSqDist < 900.0 && (double)Platform.getRandomFloat() < AEConfig.instance.meteoriteClusterChance;
            if (minSqDist > (double)AEConfig.instance.minMeteoriteDistanceSq || isCluster) {
                MeteoriteWorldGen.this.tryMeteorite(this.w, this.depth, this.x, this.z);
            }
            WorldSettings.getInstance().setGenerated(this.w.field_73011_w.field_76574_g, chunkX, chunkZ);
            WorldSettings.getInstance().getCompass().updateArea(this.w, chunkX, chunkZ);
            return null;
        }
    }

    static class MyGen
    implements ICompassCallback {
        double distance = 0.0;

        MyGen() {
        }

        @Override
        public void calculatedDirection(boolean hasResult, boolean spin, double radians, double dist) {
            this.distance = hasResult ? dist : Double.MAX_VALUE;
        }
    }
}

