/*
 * Decompiled with CFR 0.152.
 */
package appeng.facade;

import appeng.api.AEApi;
import appeng.api.parts.IFacadeContainer;
import appeng.api.parts.IFacadePart;
import appeng.api.parts.IPartHost;
import appeng.core.AppEng;
import appeng.facade.FacadePart;
import appeng.facade.IFacadeItem;
import appeng.integration.IntegrationType;
import appeng.integration.abstraction.IBC;
import appeng.items.parts.ItemFacade;
import appeng.parts.CableBusStorage;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public class FacadeContainer
implements IFacadeContainer {
    final int facades = 6;
    final CableBusStorage storage;

    public FacadeContainer(CableBusStorage cbs) {
        this.storage = cbs;
    }

    @Override
    public void writeToStream(ByteBuf out) throws IOException {
        int x;
        int facadeSides = 0;
        for (x = 0; x < this.facades; ++x) {
            if (this.getFacade(ForgeDirection.getOrientation((int)x)) == null) continue;
            facadeSides |= 1 << x;
        }
        out.writeByte((int)((byte)facadeSides));
        for (x = 0; x < this.facades; ++x) {
            IFacadePart part = this.getFacade(ForgeDirection.getOrientation((int)x));
            if (part == null) continue;
            int itemID = Item.func_150891_b((Item)part.getItem());
            int dmgValue = part.getItemDamage();
            out.writeInt(itemID * (part.isBC() ? -1 : 1));
            out.writeInt(dmgValue);
        }
    }

    @Override
    public boolean readFromStream(ByteBuf out) throws IOException {
        byte facadeSides = out.readByte();
        boolean changed = false;
        int[] ids = new int[2];
        for (int x = 0; x < this.facades; ++x) {
            ForgeDirection side = ForgeDirection.getOrientation((int)x);
            int ix = 1 << x;
            if ((facadeSides & ix) == ix) {
                ItemFacade ifa;
                ItemStack facade;
                ids[0] = out.readInt();
                ids[1] = out.readInt();
                boolean isBC = ids[0] < 0;
                ids[0] = Math.abs(ids[0]);
                if (isBC && AppEng.instance.isIntegrationEnabled(IntegrationType.BC)) {
                    IBC bc = (IBC)AppEng.instance.getIntegration(IntegrationType.BC);
                    changed = changed || this.storage.getFacade(x) == null;
                    this.storage.setFacade(x, bc.createFacadePart((Block)Block.field_149771_c.func_148754_a(ids[0]), ids[1], side));
                    continue;
                }
                if (isBC || (facade = (ifa = (ItemFacade)AEApi.instance().items().itemFacade.item()).createFromIDs(ids)) == null) continue;
                changed = changed || this.storage.getFacade(x) == null;
                this.storage.setFacade(x, ifa.createPartFromItemStack(facade, side));
                continue;
            }
            changed = changed || this.storage.getFacade(x) != null;
            this.storage.setFacade(x, null);
        }
        return changed;
    }

    @Override
    public void readFromNBT(NBTTagCompound c) {
        for (int x = 0; x < this.facades; ++x) {
            IBC bc;
            ItemStack is;
            this.storage.setFacade(x, null);
            NBTTagCompound t = c.func_74775_l("facade:" + x);
            if (t == null || (is = ItemStack.func_77949_a((NBTTagCompound)t)) == null) continue;
            Item i = is.func_77973_b();
            if (i instanceof IFacadeItem) {
                this.storage.setFacade(x, ((IFacadeItem)i).createPartFromItemStack(is, ForgeDirection.getOrientation((int)x)));
                continue;
            }
            if (!AppEng.instance.isIntegrationEnabled(IntegrationType.BC) || !(bc = (IBC)AppEng.instance.getIntegration(IntegrationType.BC)).isFacade(is)) continue;
            this.storage.setFacade(x, bc.createFacadePart(is, ForgeDirection.getOrientation((int)x)));
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound c) {
        for (int x = 0; x < this.facades; ++x) {
            if (this.storage.getFacade(x) == null) continue;
            NBTTagCompound data = new NBTTagCompound();
            this.storage.getFacade(x).getItemStack().func_77955_b(data);
            c.func_74782_a("facade:" + x, (NBTBase)data);
        }
    }

    @Override
    public boolean addFacade(IFacadePart a) {
        if (this.getFacade(a.getSide()) == null) {
            this.storage.setFacade(a.getSide().ordinal(), a);
            return true;
        }
        return false;
    }

    @Override
    public void removeFacade(IPartHost host, ForgeDirection side) {
        if (side != null && side != ForgeDirection.UNKNOWN && this.storage.getFacade(side.ordinal()) != null) {
            this.storage.setFacade(side.ordinal(), null);
            if (host != null) {
                host.markForUpdate();
            }
        }
    }

    @Override
    public IFacadePart getFacade(ForgeDirection s) {
        return this.storage.getFacade(s.ordinal());
    }

    @Override
    public boolean isEmpty() {
        for (int x = 0; x < this.facades; ++x) {
            if (this.storage.getFacade(x) == null) continue;
            return false;
        }
        return true;
    }

    @Override
    public void rotateLeft() {
        FacadePart[] newFacades = new FacadePart[6];
        newFacades[ForgeDirection.UP.ordinal()] = this.storage.getFacade(ForgeDirection.UP.ordinal());
        newFacades[ForgeDirection.DOWN.ordinal()] = this.storage.getFacade(ForgeDirection.DOWN.ordinal());
        newFacades[ForgeDirection.EAST.ordinal()] = this.storage.getFacade(ForgeDirection.NORTH.ordinal());
        newFacades[ForgeDirection.SOUTH.ordinal()] = this.storage.getFacade(ForgeDirection.EAST.ordinal());
        newFacades[ForgeDirection.WEST.ordinal()] = this.storage.getFacade(ForgeDirection.SOUTH.ordinal());
        newFacades[ForgeDirection.NORTH.ordinal()] = this.storage.getFacade(ForgeDirection.WEST.ordinal());
        for (int x = 0; x < this.facades; ++x) {
            this.storage.setFacade(x, newFacades[x]);
        }
    }
}

